package org.phosphoresce.launcher;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.launcher.exception.PropertiesLoadException;
import org.phosphoresce.launcher.util.LauncherUtil;
import org.phosphoresce.launcher.util.PropertiesUtil;
import org.phosphoresce.launcher.util.StringUtil;

/**
 * JavaAvP[VNc[ZbVNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public final class LauncherSession implements LauncherConstants {

	/** fobOtO */
	private boolean debug;

	/** CuQƐz */
	private String[] library;

	/** CNX */
	private String mainClass;

	/**
	 * RXgN^<br>
	 */
	private LauncherSession() {
		//
	}

	/**
	 * RXgN^<br>
	 * @param properties vpeBt@C
	 * @throws PropertiesLoadException ɃvpeBt@Cǂݍ߂Ȃꍇɔ
	 */
	public LauncherSession(String properties) throws PropertiesLoadException {
		this.debug = Boolean.valueOf(PropertiesUtil.getValue(properties, PROPERTY_DEBUG)).booleanValue();
		this.library = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, PROPERTY_LIBRARY), PROPERTY_DELIM);
		this.mainClass = PropertiesUtil.getValue(properties, PROPERTY_MAINCLASS);
	}

	/**
	 * w肳ꂽt@CIuWFNgċNăfBNgyсA
	 * Cũt@CXgIuWFNgƂĒ񋟂܂B<br>
	 * @param file t@CIuWFNg
	 * @return fBNgyсACũt@CXgIuWFNg
	 */
	private List getFileList(File file) {
		List list = new LinkedList();
		if (file != null) {
			list.add(file);
			if (file.isDirectory()) {
				File[] files = file.listFiles(new FileFilter() {
					public boolean accept(File path) {
						return path != null && LauncherUtil.isLibrary(path.getAbsolutePath());
					}
				});
				for (int i = 0; i <= files.length - 1; i++) {
					list.addAll(getFileList(files[i]));
				}
			}
		}
		return list;
	}

	/**
	 * ێĂQƃCuURLIuWFNgzŎ擾܂B<br>
	 * @return QƃCuSURLIuWFNgz
	 * @throws MalformedURLException URLIuWFNgɃpXϊłȂꍇɔ
	 */
	public URL[] getLibraryURLs() throws MalformedURLException {
		List libraryList = new LinkedList();
		List urlList = new LinkedList();

		for (int i = 0; i <= library.length - 1; i++) {
			libraryList.addAll(getFileList(new File(library[i])));
		}

		for (Iterator iterator = libraryList.iterator(); iterator.hasNext();) {
			File file = (File) iterator.next();
			urlList.add(file.toURL());
		}

		return (URL[]) urlList.toArray(new URL[urlList.size()]);
	}

	/**
	 * fobOtO擾܂B<br>
	 * @return fobOtO
	 */
	public boolean isDebug() {
		return debug;
	}

	/**
	 * CuQƐz擾܂B<br>
	 * @return CuQƐz
	 */
	public String[] getLibrary() {
		return library;
	}

	/**
	 * CNX擾܂B<br>
	 * @return CNX
	 */
	public String getMainClass() {
		return mainClass;
	}

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return \NX
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("-- Launcher Session Information");
		buffer.append("\n");
		buffer.append(" Debug       : " + debug);
		buffer.append("\n");
		buffer.append(" MainClass   : " + mainClass);
		buffer.append("\n");
		buffer.append(" Library     : ");
		for (int i = 0; i <= library.length - 1; i++) {
			buffer.append(i == 0 ? "" : "             ");
			buffer.append(library[i]);
			buffer.append(i == library.length - 1 ? "" : "\n");
		}
		return buffer.toString();
	}
}
