package org.phosphoresce.dbbrowser.gui.panel.querymanage;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.eswing.EPanel;
import org.phosphoresce.commons.eswing.ESplitPane;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;
import org.phosphoresce.dbbrowser.gui.common.component.CatalogSchemaTableListPanel;

/**
 * NGGfB^CReipl<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
final class QueryManageContainerPanel extends EPanel implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** NGsIuWFNg */
	private QueryManageActionContainer actionContainer = null;

	/** NGsZbgpl */
	private ESplitPane queryManageSetPanel = null;

	/** {^pl */
	private QueryManageButtonPanel queryManageButtonPanel = null;

	/** e[uXgpl */
	private CatalogSchemaTableListPanel catalogSchemaTableListPanel = null;

	/** NGҏWʃZbgpl */
	private ESplitPane queryEditResultSetPanel = null;

	/** NGҏWpl */
	private QueryManageEditorPanel queryManageEditorPanel = null;

	/** NGʃG[Zbgpl */
	private ESplitPane queryManageResultErrorSetPanel = null;

	/** NGʃpl */
	private QueryManageResultTablePanel queryManageResultTablePanel = null;

	/** NGsG[Xgpl */
	private QueryManageErrorListPanel queryManageErrorListPanel = null;

	/**
	 * RXgN^<br>
	 */
	public QueryManageContainerPanel() {
		super();
		initialize();
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		getCatalogSchemaTableListPanel().refresh();
		getQueryManageEditorPanel().refresh();
		getQueryManageResultTablePanel().refresh();
		getQueryManageErrorListPanel().refresh();
	}

	/**
	 * NGsIuWFNg擾܂B<br>
	 * @return NGsIuWFNg
	 */
	public QueryManageActionContainer getActionContainer() {
		if (actionContainer == null) {
			actionContainer = new QueryManageActionContainer(this);
		}
		return actionContainer;
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 1;
		gridBagConstraints1.weightx = 1.0;
		gridBagConstraints1.weighty = 1.0;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = GridBagConstraints.BOTH;
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 0.0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(561, 387));
		this.add(getQueryManageButtonPanel(), gridBagConstraints);
		this.add(getQueryManageSetPanel(), gridBagConstraints1);
	}

	/**
	 * NGsZbgpl擾܂B<br>
	 * @return NGsZbgpl
	 */
	private ESplitPane getQueryManageSetPanel() {
		if (queryManageSetPanel == null) {
			queryManageSetPanel = new ESplitPane();
			queryManageSetPanel.setDividerLocation(160);
			queryManageSetPanel.setRightComponent(getQueryEditResultSetPanel());
			queryManageSetPanel.setLeftComponent(getCatalogSchemaTableListPanel());
		}
		return queryManageSetPanel;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return {^pl
	 */
	private QueryManageButtonPanel getQueryManageButtonPanel() {
		if (queryManageButtonPanel == null) {
			queryManageButtonPanel = new QueryManageButtonPanel(getActionContainer());
		}
		return queryManageButtonPanel;
	}

	/**
	 * e[uXgpl擾܂B<br>
	 * @return e[uXgpl
	 */
	public CatalogSchemaTableListPanel getCatalogSchemaTableListPanel() {
		if (catalogSchemaTableListPanel == null) {
			catalogSchemaTableListPanel = new CatalogSchemaTableListPanel();
			catalogSchemaTableListPanel.getTableTreeScrollPane().setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			catalogSchemaTableListPanel.getTableTree().addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					getActionContainer().tableClickAction(e);
				}
			});
		}
		return catalogSchemaTableListPanel;
	}

	/**
	 * NGҏWʃZbgpl擾܂B<br>
	 * @return NGҏWʃZbgpl
	 */
	private ESplitPane getQueryEditResultSetPanel() {
		if (queryEditResultSetPanel == null) {
			queryEditResultSetPanel = new ESplitPane();
			queryEditResultSetPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryEditResultSetPanel.setOneTouchExpandable(true);
			queryEditResultSetPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
			queryEditResultSetPanel.setDividerLocation(80);
			queryEditResultSetPanel.setBottomComponent(getQueryManageResultErrorSetPanel());
			queryEditResultSetPanel.setTopComponent(getQueryManageEditorPanel());
		}
		return queryEditResultSetPanel;
	}

	/**
	 * NGҏWpl擾܂B<br>
	 * @return NGҏWpl
	 */
	public QueryManageEditorPanel getQueryManageEditorPanel() {
		if (queryManageEditorPanel == null) {
			queryManageEditorPanel = new QueryManageEditorPanel(getActionContainer());
			queryManageEditorPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
		}
		return queryManageEditorPanel;
	}

	/**
	 * NGʃG[Zbgpl擾܂B<br>
	 * @return NGʃG[Zbgpl
	 */
	private ESplitPane getQueryManageResultErrorSetPanel() {
		if (queryManageResultErrorSetPanel == null) {
			queryManageResultErrorSetPanel = new ESplitPane();
			queryManageResultErrorSetPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryManageResultErrorSetPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
			queryManageResultErrorSetPanel.setDividerLocation(-1);
			queryManageResultErrorSetPanel.setBottomComponent(getQueryManageErrorListPanel());
			queryManageResultErrorSetPanel.setTopComponent(getQueryManageResultTablePanel());
		}
		return queryManageResultErrorSetPanel;
	}

	/**
	 * NGʃpl擾܂B<br>
	 * @return NGʃpl
	 */
	public QueryManageResultTablePanel getQueryManageResultTablePanel() {
		if (queryManageResultTablePanel == null) {
			queryManageResultTablePanel = new QueryManageResultTablePanel(getActionContainer());
			queryManageResultTablePanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryManageResultTablePanel.setMinimumSize(new Dimension(400, 300));
		}
		return queryManageResultTablePanel;
	}

	/**
	 * NGsG[Xgpl擾܂B<br>
	 * @return NGsG[Xgpl
	 */
	public QueryManageErrorListPanel getQueryManageErrorListPanel() {
		if (queryManageErrorListPanel == null) {
			queryManageErrorListPanel = new QueryManageErrorListPanel();
			queryManageErrorListPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
			queryManageErrorListPanel.setMaximumSize(new Dimension(400, 40));
		}
		return queryManageErrorListPanel;
	}
}
