package org.phosphoresce.dbbrowser.gui.panel.dbinformation;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;

import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.DatabaseQueryspec;
import org.phosphoresce.commons.eswing.ELabel;
import org.phosphoresce.commons.eswing.EList;
import org.phosphoresce.commons.eswing.EScrollPane;
import org.phosphoresce.commons.eswing.extend.EFieldSet;
import org.phosphoresce.dbbrowser.DatabaseBrowserSession;
import org.phosphoresce.dbbrowser.gui.RefreshableComponent;

/**
 * f[^x[XplR|[lgNX<br>
 * f[^x[XNGdltB[hZbg<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/17	Kitagawa		VK쐬
 *-->
 */
public class DatabaseQuerySpecificationFieldSet extends EFieldSet implements RefreshableComponent {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** GLXgLN^x */
	private ELabel extraNameCharactersLabel = null;

	/** GLXgLN^ */
	private ELabel extraNameCharacters = null;

	/** SQLʕ񃉃x */
	private ELabel identifierQuoteStringLabel = null;

	/** SQLʕ */
	private ELabel identifierQuoteString = null;

	/** ChK[hGXP[vx */
	private ELabel searchStringEscapeLabel = null;

	/** ChK[hGXP[v */
	private ELabel searchStringEscape = null;

	/** w֐Xgx */
	private ELabel numericFunctionListLabel = null;

	/** w֐XgXN[yC */
	private EScrollPane numericFunctionListScrollPane = null;

	/** w֐Xg */
	private EList numericFunctionList = null;

	/** SQLL[[hXgx */
	private ELabel sqlKeywordListLabel = null;

	/** SQLL[[hXgXN[yC */
	private EScrollPane sqlKeywordListScrollPane = null;

	/** SQLL[[hXg */
	private EList sqlKeywordList = null;

	/** VXe֐Xgx */
	private ELabel systemFunctionListLabel = null;

	/** VXe֐XgXN[yC */
	private EScrollPane systemFunctionListScrollPane = null;

	/** VXe֐Xg */
	private EList systemFunctionList = null;

	/** ֐Xgx */
	private ELabel timeDateFunctionListLabel = null;

	/** ֐XgXN[yC */
	private EScrollPane timeDateFunctionListScrollPane = null;

	/** ֐Xg */
	private EList timeDateFunctionList = null;

	/**
	 * RXgN^<br>
	 */
	public DatabaseQuerySpecificationFieldSet() {
		super();
		initialize();
	}

	/**
	 * XV܂B<br>
	 * @throws Throwable ɏ̍XVsȂꍇɔ
	 * @see org.phosphoresce.dbbrowser.gui.RefreshableComponent#refresh()
	 */
	public void refresh() throws Throwable {
		DatabaseQueryspec queryspec = new DatabaseQueryspec(DatabaseBrowserSession.instance().getCommonDatabaseSession());
		getExtraNameCharacters().setText(queryspec.getExtraNameCharacters());
		getIdentifierQuoteString().setText(queryspec.getIdentifierQuoteString());
		getSearchStringEscape().setText(queryspec.getSearchStringEscape());
		DefaultListModel numericFunctionListModel = new DefaultListModel();
		for (Iterator iterator = queryspec.getNumericFunctionList().iterator(); iterator.hasNext();) {
			numericFunctionListModel.addElement(iterator.next());
		}
		getNumericFunctionList().setModel(numericFunctionListModel);
		DefaultListModel sqlKeywordListModel = new DefaultListModel();
		for (Iterator iterator = queryspec.getSQLKeywordList().iterator(); iterator.hasNext();) {
			sqlKeywordListModel.addElement(iterator.next());
		}
		getSqlKeywordList().setModel(sqlKeywordListModel);
		DefaultListModel systemFunctionListModel = new DefaultListModel();
		for (Iterator iterator = queryspec.getSystemFunctionList().iterator(); iterator.hasNext();) {
			systemFunctionListModel.addElement(iterator.next());
		}
		getSystemFunctionList().setModel(systemFunctionListModel);
		DefaultListModel timeDateFunctionListModel = new DefaultListModel();
		for (Iterator iterator = queryspec.getTimeDateFunctionList().iterator(); iterator.hasNext();) {
			timeDateFunctionListModel.addElement(iterator.next());
		}
		getTimeDateFunctionList().setModel(timeDateFunctionListModel);
	}

	/**
	 * R|[lgs܂B<br>
	 */
	private void initialize() {
		GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
		gridBagConstraints14.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints14.anchor = GridBagConstraints.WEST;
		gridBagConstraints14.weightx = 1.0D;
		gridBagConstraints14.weighty = 0.0D;
		gridBagConstraints14.gridy = 6;
		gridBagConstraints14.gridx = 1;
		GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
		gridBagConstraints13.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints13.fill = GridBagConstraints.BOTH;
		gridBagConstraints13.weightx = 0.0D;
		gridBagConstraints13.weighty = 0.0D;
		gridBagConstraints13.gridx = 0;
		gridBagConstraints13.gridy = 6;
		GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
		gridBagConstraints12.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints12.anchor = GridBagConstraints.WEST;
		gridBagConstraints12.weightx = 1.0D;
		gridBagConstraints12.weighty = 0.0D;
		gridBagConstraints12.gridy = 5;
		gridBagConstraints12.gridx = 1;
		GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
		gridBagConstraints11.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints11.fill = GridBagConstraints.BOTH;
		gridBagConstraints11.weightx = 0.0D;
		gridBagConstraints11.weighty = 0.0D;
		gridBagConstraints11.gridx = 0;
		gridBagConstraints11.gridy = 5;
		GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
		gridBagConstraints10.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints10.anchor = GridBagConstraints.WEST;
		gridBagConstraints10.weightx = 1.0D;
		gridBagConstraints10.weighty = 0.0D;
		gridBagConstraints10.gridy = 4;
		gridBagConstraints10.gridx = 1;
		GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
		gridBagConstraints9.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints9.fill = GridBagConstraints.BOTH;
		gridBagConstraints9.weightx = 0.0D;
		gridBagConstraints9.weighty = 0.0D;
		gridBagConstraints9.gridx = 0;
		gridBagConstraints9.gridy = 4;
		GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
		gridBagConstraints8.insets = new Insets(2, 0, 2, 0);
		gridBagConstraints8.anchor = GridBagConstraints.WEST;
		gridBagConstraints8.weightx = 1.0D;
		gridBagConstraints8.weighty = 0.0D;
		gridBagConstraints8.gridy = 3;
		gridBagConstraints8.gridx = 1;
		GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
		gridBagConstraints7.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints7.fill = GridBagConstraints.BOTH;
		gridBagConstraints7.weightx = 0.0D;
		gridBagConstraints7.weighty = 0.0D;
		gridBagConstraints7.gridx = 0;
		gridBagConstraints7.gridy = 3;
		GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
		gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints6.fill = GridBagConstraints.BOTH;
		gridBagConstraints6.weightx = 1.0D;
		gridBagConstraints6.weighty = 0.0D;
		gridBagConstraints6.gridx = 1;
		gridBagConstraints6.gridy = 2;
		GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
		gridBagConstraints5.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints5.fill = GridBagConstraints.BOTH;
		gridBagConstraints5.weightx = 0.0D;
		gridBagConstraints5.weighty = 0.0D;
		gridBagConstraints5.gridx = 0;
		gridBagConstraints5.gridy = 2;
		GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
		gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints4.fill = GridBagConstraints.BOTH;
		gridBagConstraints4.weightx = 1.0D;
		gridBagConstraints4.weighty = 0.0D;
		gridBagConstraints4.gridx = 1;
		gridBagConstraints4.gridy = 1;
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints3.fill = GridBagConstraints.BOTH;
		gridBagConstraints3.weightx = 0.0D;
		gridBagConstraints3.weighty = 0.0D;
		gridBagConstraints3.gridx = 0;
		gridBagConstraints3.gridy = 1;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
		gridBagConstraints2.fill = GridBagConstraints.BOTH;
		gridBagConstraints2.weightx = 1.0D;
		gridBagConstraints2.weighty = 0.0D;
		gridBagConstraints2.gridx = 1;
		gridBagConstraints2.gridy = 0;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
		gridBagConstraints1.fill = GridBagConstraints.BOTH;
		gridBagConstraints1.weightx = 0.0D;
		gridBagConstraints1.weighty = 0.0D;
		gridBagConstraints1.gridx = 0;
		gridBagConstraints1.gridy = 0;
		this.setLayout(new GridBagLayout());
		this.setSize(new Dimension(500, 364));
		this.setPreferredSize(new Dimension(500, 364));
		this.setMaximumSize(new Dimension(500, 364));
		this.setMinimumSize(new Dimension(500, 364));
		this.setText("Database Query Specification");
		this.add(getExtraNameCharactersLabel(), gridBagConstraints1);
		this.add(getExtraNameCharacters(), gridBagConstraints2);
		this.add(getIdentifierQuoteStringLabel(), gridBagConstraints3);
		this.add(getIdentifierQuoteString(), gridBagConstraints4);
		this.add(getSearchStringEscapeLabel(), gridBagConstraints5);
		this.add(getSearchStringEscape(), gridBagConstraints6);
		this.add(getNumericFunctionListLabel(), gridBagConstraints7);
		this.add(getNumericFunctionListScrollPane(), gridBagConstraints8);
		this.add(getSqlKeywordListLabel(), gridBagConstraints9);
		this.add(getSqlKeywordListScrollPane(), gridBagConstraints10);
		this.add(getSystemFunctionListLabel(), gridBagConstraints11);
		this.add(getSystemFunctionListScrollPane(), gridBagConstraints12);
		this.add(getTimeDateFunctionListLabel(), gridBagConstraints13);
		this.add(getTimeDateFunctionListScrollPane(), gridBagConstraints14);
	}

	/**
	 * GLXgLN^x擾܂B<br>
	 * @return GLXgLN^x
	 */
	private ELabel getExtraNameCharactersLabel() {
		if (extraNameCharactersLabel == null) {
			extraNameCharactersLabel = new ELabel();
			extraNameCharactersLabel.setPreferredSize(new Dimension(150, 22));
			extraNameCharactersLabel.setText("Extra Name Characters :");
		}
		return extraNameCharactersLabel;
	}

	/**
	 * GLXgLN^擾܂B<br>
	 * @return GLXgLN^
	 */
	private ELabel getExtraNameCharacters() {
		if (extraNameCharacters == null) {
			extraNameCharacters = new ELabel();
			extraNameCharacters.setPreferredSize(new Dimension(150, 22));
		}
		return extraNameCharacters;
	}

	/**
	 * SQLʕ񃉃x擾܂B<br>
	 * @return SQLʕ񃉃x
	 */
	private ELabel getIdentifierQuoteStringLabel() {
		if (identifierQuoteStringLabel == null) {
			identifierQuoteStringLabel = new ELabel();
			identifierQuoteStringLabel.setPreferredSize(new Dimension(150, 22));
			identifierQuoteStringLabel.setText("Identifier Quote String :");
		}
		return identifierQuoteStringLabel;
	}

	/**
	 * SQLʕ擾܂B<br>
	 * @return SQLʕ
	 */
	private ELabel getIdentifierQuoteString() {
		if (identifierQuoteString == null) {
			identifierQuoteString = new ELabel();
			identifierQuoteString.setPreferredSize(new Dimension(150, 22));
		}
		return identifierQuoteString;
	}

	/**
	 * ChK[hGXP[vx擾܂B<br>
	 * @return ChK[hGXP[vx
	 */
	private ELabel getSearchStringEscapeLabel() {
		if (searchStringEscapeLabel == null) {
			searchStringEscapeLabel = new ELabel();
			searchStringEscapeLabel.setPreferredSize(new Dimension(150, 22));
			searchStringEscapeLabel.setText("Search String Escape :");
		}
		return searchStringEscapeLabel;
	}

	/**
	 * ChK[hGXP[v擾܂B<br>
	 * @return ChK[hGXP[v
	 */
	private ELabel getSearchStringEscape() {
		if (searchStringEscape == null) {
			searchStringEscape = new ELabel();
			searchStringEscape.setPreferredSize(new Dimension(150, 22));
		}
		return searchStringEscape;
	}

	/**
	 * w֐Xgx擾܂B<br>
	 * @return 
	 */
	private ELabel getNumericFunctionListLabel() {
		if (numericFunctionListLabel == null) {
			numericFunctionListLabel = new ELabel();
			numericFunctionListLabel.setPreferredSize(new Dimension(150, 22));
			numericFunctionListLabel.setText("Numeric Function List :");
		}
		return numericFunctionListLabel;
	}

	/**
	 * w֐XgXN[yC擾܂B<br>
	 * @return w֐XgXN[yC
	 */
	private EScrollPane getNumericFunctionListScrollPane() {
		if (numericFunctionListScrollPane == null) {
			numericFunctionListScrollPane = new EScrollPane();
			numericFunctionListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			numericFunctionListScrollPane.setPreferredSize(new Dimension(240, 60));
			numericFunctionListScrollPane.setViewportView(getNumericFunctionList());
		}
		return numericFunctionListScrollPane;
	}

	/**
	 * w֐Xg擾܂B<br>
	 * @return w֐Xg
	 */
	private EList getNumericFunctionList() {
		if (numericFunctionList == null) {
			numericFunctionList = new EList();
		}
		return numericFunctionList;
	}

	/**
	 * SQLL[[hXgx擾܂B<br>
	 * @return SQLL[[hXgx
	 */
	private ELabel getSqlKeywordListLabel() {
		if (sqlKeywordListLabel == null) {
			sqlKeywordListLabel = new ELabel();
			sqlKeywordListLabel.setPreferredSize(new Dimension(150, 22));
			sqlKeywordListLabel.setText("SQL Keyword List :");
		}
		return sqlKeywordListLabel;
	}

	/**
	 * SQLL[[hXgXN[yC擾܂B<br>
	 * @return SQLL[[hXgXN[yC
	 */
	private EScrollPane getSqlKeywordListScrollPane() {
		if (sqlKeywordListScrollPane == null) {
			sqlKeywordListScrollPane = new EScrollPane();
			sqlKeywordListScrollPane.setPreferredSize(new Dimension(240, 60));
			sqlKeywordListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			sqlKeywordListScrollPane.setViewportView(getSqlKeywordList());
		}
		return sqlKeywordListScrollPane;
	}

	/**
	 * SQLL[[hXg擾܂B<br>
	 * @return SQLL[[hXg
	 */
	private EList getSqlKeywordList() {
		if (sqlKeywordList == null) {
			sqlKeywordList = new EList();
		}
		return sqlKeywordList;
	}

	/**
	 * VXe֐Xgx擾܂B<br>
	 * @return VXe֐Xgx
	 */
	private ELabel getSystemFunctionListLabel() {
		if (systemFunctionListLabel == null) {
			systemFunctionListLabel = new ELabel();
			systemFunctionListLabel.setPreferredSize(new Dimension(150, 22));
			systemFunctionListLabel.setText("System Function List :");
		}
		return systemFunctionListLabel;
	}

	/**
	 * VXe֐XgXN[yC擾܂B<br>
	 * @return VXe֐XgXN[yC
	 */
	private EScrollPane getSystemFunctionListScrollPane() {
		if (systemFunctionListScrollPane == null) {
			systemFunctionListScrollPane = new EScrollPane();
			systemFunctionListScrollPane.setPreferredSize(new Dimension(240, 60));
			systemFunctionListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			systemFunctionListScrollPane.setViewportView(getSystemFunctionList());
		}
		return systemFunctionListScrollPane;
	}

	/**
	 * VXe֐Xg擾܂B<br>
	 * @return VXe֐Xg
	 */
	private EList getSystemFunctionList() {
		if (systemFunctionList == null) {
			systemFunctionList = new EList();
		}
		return systemFunctionList;
	}

	/**
	 * ֐Xgx擾܂B<br>
	 * @return ֐Xgx
	 */
	private ELabel getTimeDateFunctionListLabel() {
		if (timeDateFunctionListLabel == null) {
			timeDateFunctionListLabel = new ELabel();
			timeDateFunctionListLabel.setPreferredSize(new Dimension(150, 22));
			timeDateFunctionListLabel.setText("Time Date Function List :");
		}
		return timeDateFunctionListLabel;
	}

	/**
	 * ֐XgXN[yC擾܂B<br>
	 * @return ֐XgXN[yC
	 */
	private EScrollPane getTimeDateFunctionListScrollPane() {
		if (timeDateFunctionListScrollPane == null) {
			timeDateFunctionListScrollPane = new EScrollPane();
			timeDateFunctionListScrollPane.setPreferredSize(new Dimension(240, 60));
			timeDateFunctionListScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			timeDateFunctionListScrollPane.setViewportView(getTimeDateFunctionList());
		}
		return timeDateFunctionListScrollPane;
	}

	/**
	 * ֐Xg擾܂B<br>
	 * @return ֐Xg
	 */
	private EList getTimeDateFunctionList() {
		if (timeDateFunctionList == null) {
			timeDateFunctionList = new EList();
		}
		return timeDateFunctionList;
	}
}
