/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.phosphoresce.commons.database.accessor.ResultAccessorAbstract;
import org.phosphoresce.commons.database.accessor.ResultAccessorState;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public final class ResultRowDefinition
extends ResultAccessorAbstract {
    private List columnDefinitions = new LinkedList();
    private Map columnIndexMap = new LinkedHashMap();

    ResultRowDefinition(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet, ResultAccessorState.STATIC, null);
        this.refreshResult();
    }

    protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        int currentRow = this.getResultSetRowIndex();
        try {
            int i;
            int columnCount = this.resultSet.getMetaData().getColumnCount();
            this.columnIndexMap.clear();
            for (i = 0; i <= columnCount - 1; ++i) {
                ResultColumnDefinition definition = null;
                if (i <= this.columnDefinitions.size() - 1) {
                    definition = (ResultColumnDefinition)this.columnDefinitions.get(i);
                    definition.setIndex(i);
                    definition.refreshResult();
                } else {
                    definition = new ResultColumnDefinition(this.resultSet, i);
                    this.columnDefinitions.add(definition);
                }
                this.columnIndexMap.put(definition.getName(), new Integer(i));
            }
            if (this.columnDefinitions.size() > columnCount) {
                for (i = 0; i <= this.columnDefinitions.size() - columnCount - 1; ++i) {
                    this.columnDefinitions.remove(this.columnDefinitions.size() - 1);
                }
            }
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to refresh result.", e);
        }
        finally {
            this.moveCurser(currentRow);
        }
    }

    protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
    }

    public Iterator getColumnNameIterator() {
        return this.columnIndexMap.keySet().iterator();
    }

    public String[] getColumnNames() {
        LinkedList list = new LinkedList();
        Iterator iterator = this.getColumnNameIterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray(new String[list.size()]);
    }

    public int getColumnCount() {
        return this.columnDefinitions.size();
    }

    public int getColumnIndex(String name) throws IllegalResultSetLocationIndexException {
        if (!this.columnIndexMap.containsKey(name)) {
            throw new IllegalResultSetLocationIndexException("'" + name + "' column not exist.");
        }
        return (Integer)this.columnIndexMap.get(name);
    }

    public String getColumnName(int resultColumnsIndex) throws IllegalResultSetLocationIndexException {
        return this.getColumnDefinition(resultColumnsIndex).getName();
    }

    public ResultColumnDefinition getColumnDefinition(int columnIndex) throws IllegalResultSetLocationIndexException {
        if (this.columnDefinitions.size() - 1 < columnIndex || columnIndex < 0) {
            throw new IllegalResultSetLocationIndexException("illegal column index. [" + columnIndex + "]");
        }
        return (ResultColumnDefinition)this.columnDefinitions.get(columnIndex);
    }

    public ResultColumnDefinition getColumnDefinition(String name) throws IllegalResultSetLocationIndexException {
        return this.getColumnDefinition(this.getColumnIndex(name));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Iterator iterator = this.columnDefinitions.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

