/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.accessor.RecordAccessor;
import org.phosphoresce.commons.database.accessor.ResultAccessorListener;
import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.accessor.ResultRowDefinition;
import org.phosphoresce.commons.database.accessor.ResultTemplateRow;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseConnectionException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public abstract class RecordAccessorAbstract
implements RecordAccessor {
    protected Log log = LogFactory.getLog(this.getClass());
    private DatabaseSession session = null;
    protected ResultSet resultSet = null;
    protected ResultRowDefinition rowDefinition;
    protected ResultAccessorListener listener = null;

    protected RecordAccessorAbstract(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetAdjustmentException, IllegalResultSetLocationIndexException {
        if (resultSet == null) {
            throw new ResultSetAccessException("null 'resultSet' argument.");
        }
        this.resultSet = resultSet;
        this.rowDefinition = new ResultRowDefinition(resultSet);
        this.listener = null;
        if (this.getResultSetRowIndex() != 0) {
            throw new IllegalResultSetAdjustmentException("'resultSet' cursor is not before first row.");
        }
    }

    private RecordAccessorAbstract() throws ResultSetAccessException, IllegalResultSetAdjustmentException, IllegalResultSetLocationIndexException {
        this(null);
    }

    public final void refreshResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        this.refreshResult(false);
    }

    public final ResultTemplateRow createTemplateRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        return new ResultTemplateRow(this.resultSet, this.rowDefinition);
    }

    public final int getResultRowCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
        try {
            int currentRow = this.resultSet.getRow();
            this.resultSet.last();
            int lastRow = this.resultSet.getRow();
            this.moveCurser(currentRow);
            return lastRow;
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get ResultSet row count.", e);
        }
    }

    public final int getResultColumnCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
        return this.rowDefinition.getColumnCount();
    }

    public final ResultRowDefinition getResultRowDefinition() throws ResultSetAccessException, IllegalResultSetAdjustmentException {
        return this.rowDefinition;
    }

    public final ResultColumnDefinition getResultColumnDefinition(int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
        return this.rowDefinition.getColumnDefinition(columnIndex);
    }

    public final ResultColumnDefinition getResultColumnDefinition(String columnName) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
        return this.rowDefinition.getColumnDefinition(columnName);
    }

    public final boolean isReadOnly() throws DatabaseConnectionException {
        try {
            return this.resultSet.getStatement().getConnection().isReadOnly();
        }
        catch (SQLException e) {
            throw new DatabaseConnectionException("failed to analyze read only statement.", e);
        }
    }

    protected final int getResultSetRowIndex() throws ResultSetAccessException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get ResultRow index.", e);
        }
    }

    protected final void moveCurser(int rowIndex) throws ResultSetAccessException {
        try {
            if (rowIndex == 0) {
                this.resultSet.beforeFirst();
            } else {
                this.resultSet.absolute(rowIndex);
            }
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to move cursor.", e);
        }
    }

    protected final boolean validateStateListener() {
        return this.listener != null;
    }
}

