/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.phosphoresce.commons.database.accessor.RecordBufferedAccessor;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessorStateListener;
import org.phosphoresce.commons.database.accessor.ResultColumn;
import org.phosphoresce.commons.database.exception.IllegalOperateRuntimeException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

public class RecordTableModelAccessor
extends RecordBufferedAccessor
implements TableModel {
    protected EventListenerList listenerList = new EventListenerList();

    public RecordTableModelAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        super(resultSet);
        this.listener = new RecordTableModelAccessorStateListener(this);
    }

    public int getRowCount() {
        return this.fetchBuffer.size();
    }

    public int getColumnCount() {
        try {
            return this.getResultColumnCount();
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to get column count", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to get column count", e);
        }
    }

    public String getColumnName(int columnIndex) {
        try {
            return this.getResultRowDefinition().getColumnName(columnIndex);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to get column name", e);
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to get column name", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to get column name", e);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return ResultColumn.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return this.getResultColumn(rowIndex, columnIndex);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to get column value", e);
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to get column value", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to get column value", e);
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        try {
            if (value == null || !(value instanceof ResultColumn)) {
                throw new IllegalArgumentException("is not instancedof column object");
            }
            this.setResultColumn(rowIndex, columnIndex, (ResultColumn)value);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (IllegalResultSetLocationIndexException e) {
            throw new IllegalOperateRuntimeException("failed to set column value", e);
        }
        catch (ResultSetAccessException e) {
            throw new IllegalOperateRuntimeException("failed to set column value", e);
        }
        catch (IllegalResultSetAdjustmentException e) {
            throw new IllegalOperateRuntimeException("failed to set column value", e);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listenerList.add(TableModelListener.class, listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listenerList.remove(TableModelListener.class, listener);
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }

    public void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$TableModelListener == null ? RecordTableModelAccessor.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }
}

