/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;
import org.phosphoresce.commons.database.util.ResultSetUtil;

public class DatabaseInformation {
    private DatabaseSession session;

    public DatabaseInformation(DatabaseSession session) {
        this.session = session;
    }

    private DatabaseInformation() {
        this(null);
    }

    private DatabaseMetaData getDatabaseMetaData() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get database meta data.", e);
        }
    }

    public String getProductName() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getDatabaseProductName();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get product name.", e);
        }
    }

    public String getProductVersion() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getDatabaseProductVersion();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get product version.", e);
        }
    }

    public String getDriverName() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getDriverName();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get driver name.", e);
        }
    }

    public String getDriverVersion() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getDriverVersion();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get driver version.", e);
        }
    }

    public String getUserName() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getUserName();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get user name.", e);
        }
    }

    public String getURL() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getURL();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get url.", e);
        }
    }

    public String getCatalogTerm() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getCatalogTerm();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get catalog term.", e);
        }
    }

    public String getProcedureTerm() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getProcedureTerm();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("faied to get procedure term.", e);
        }
    }

    public String getSchemaTerm() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getSchemaTerm();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get schema term.", e);
        }
    }

    public String getCatalogSeparator() throws DatabaseSessionException, ResultSetAccessException {
        try {
            return this.session.getConnection().getMetaData().getCatalogSeparator();
        }
        catch (AbstractMethodError e) {
            return "";
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get catalog separator.", e);
        }
    }

    public List getCatalogNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getCatalogs();
            while (resultSet.next()) {
                list.add(resultSet.getObject("TABLE_CAT"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get catalog list.", e);
        }
    }

    public List getSchemaNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getSchemas();
            while (resultSet.next()) {
                list.add(resultSet.getObject("TABLE_SCHEM"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get schema list.", e);
        }
    }

    public List getSchemaNameList(String catalog) throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getSchemas();
            while (resultSet.next()) {
                if (ResultSetUtil.containsColumn(resultSet, "TABLE_CATALOG")) {
                    String tableCat;
                    String string = tableCat = resultSet.getObject("TABLE_CATALOG") == null ? "" : resultSet.getObject("TABLE_CATALOG").toString();
                    if (catalog != null && !catalog.equals(tableCat)) continue;
                    list.add(resultSet.getObject("TABLE_SCHEM"));
                    continue;
                }
                list.add(resultSet.getObject("TABLE_SCHEM"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get schema list of '" + catalog + "'.", e);
        }
    }

    public List getTableTypeNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getTableTypes();
            while (resultSet.next()) {
                list.add(resultSet.getObject("TABLE_TYPE"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get table type list.", e);
        }
    }

    public List getTypeInfoNameList() throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getTypeInfo();
            while (resultSet.next()) {
                list.add(resultSet.getObject("TYPE_NAME"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get type name list.", e);
        }
    }

    public List getTableList(String catalog, String schema) throws DatabaseSessionException, ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            ResultSet resultSet = this.getDatabaseMetaData().getTables(catalog == null ? "%" : catalog, schema == null ? "%" : schema, "%", new String[]{"TABLE"});
            while (resultSet.next()) {
                list.add(resultSet.getObject("TABLE_NAME"));
            }
            return list;
        }
        catch (AbstractMethodError e) {
            return new LinkedList();
        }
        catch (SQLException e) {
            throw new ResultSetAccessException("failed to get table list.", e);
        }
    }
}

