package org.phosphoresce.commons.eswing;

import java.awt.Dimension;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

import org.phosphoresce.commons.eswing.core.ESwingComponent;
import org.phosphoresce.commons.eswing.core.ESwingConfig;
import org.phosphoresce.commons.eswing.event.EComboBoxMouseWheelSelectionListener;

/**
 * JComboBoxgNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/01	Kitagawa		VK쐬
 *-->
 */
public class EComboBox extends JComboBox implements ESwingComponent {

	/**
	 * SwinggComponentNX̊gݒs܂B<br>
	 * @see org.phosphoresce.commons.eswing.core.ESwingComponent#dressup()
	 */
	public void dressup() {
		getToolkit().setDynamicLayout(true);
		setDoubleBuffered(true);
		setSize(new Dimension(100, 20));

		addMouseWheelListener(new EComboBoxMouseWheelSelectionListener());
	}

	/**
	 * RXgN^<br>
	 * @see JComboBox#JComboBox()
	 */
	public EComboBox() {
		super();
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param model ComboBoxModelIuWFNg
	 * @see JComboBox#JComboBox(ComboBoxModel)
	 */
	public EComboBox(ComboBoxModel model) {
		super(model);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param items ACeIuWFNgz
	 * @see JComboBox#JComboBox(Object[])
	 */
	public EComboBox(Object[] items) {
		super(items);
		dressup();
	}

	/**
	 * RXgN^<br>
	 * @param items ACeIuWFNgVector
	 * @see JComboBox#JComboBox(Vector)
	 */
	public EComboBox(Vector items) {
		super(items);
		dressup();
	}
}
