package org.phosphoresce.commons.database.test;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

import org.phosphoresce.commons.database.accessor.RecordTableModelAccessor;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessorEditor;
import org.phosphoresce.commons.database.accessor.RecordTableModelAccessorRenderer;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.core.DatabaseQueryManager;

/**
 * eXgNX<br>
 * R[he[ufANZXNXeXgt[NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/10	Kitagawa		VK쐬
 *-->
 */
public class TestRecordTableModelAccessorFrame extends JFrame {

	/** f[^x[XZbVIuWFNg */
	private DatabaseSession session;

	/** RecyCIuWFNg */
	private JPanel jContentPane = null;

	/** ʃXN[yC */
	private JScrollPane resultScrollPane = null;

	/** ʃe[u */
	private JTable resultTable = null;

	/** NGXN[yC */
	private JScrollPane queryScrollPane = null;

	/** NGeLXgGA */
	private JTextArea queryTextArea = null;

	/** {^pl */
	private JPanel buttonPanel = null;

	/** Execute{^ */
	private JButton executeButton = null;

	/** Close{^ */
	private JButton closeButton = null;

	/** Insert{^ */
	private JButton insertButton = null;

	/** Delete{^ */
	private JButton deleteButton = null;

	/** Commit{^ */
	private JButton commitButton = null;

	/** Rollback{^ */
	private JButton rollbackButton = null;

	/** G[XN[yC */
	private JScrollPane errorScrollPane = null;

	/** G[Xg */
	private JList errorList = null;

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbVIuWFNg
	 */
	public TestRecordTableModelAccessorFrame(DatabaseSession session) {
		super();
		this.session = session;
		initialize();
	}

	/**
	 * RXgN^<br>
	 */
	public TestRecordTableModelAccessorFrame() {
		super();
		initialize();
	}

	/**
	 * t[s܂B<br>
	 */
	private void initialize() {
		this.setSize(800, 512);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setContentPane(getJContentPane());
		this.setTitle("TestRecordTableModelAccessor");
	}

	/**
	 * t[RecyC擾܂B<br>
	 * @return JPanelIuWFNg
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.weighty = 0.0;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.gridy = 1;
			gridBagConstraints2.weightx = 0.0;
			gridBagConstraints2.weighty = 0.0;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 3;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.weighty = 1.0;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.insets = new Insets(3, 3, 3, 3);
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.gridy = 4;
			gridBagConstraints4.weightx = 0.0;
			gridBagConstraints4.weighty = 0.0;
			jContentPane = new JPanel();
			jContentPane.setLayout(new GridBagLayout());
			jContentPane.add(getQueryScrollPane(), gridBagConstraints1);
			jContentPane.add(getButtonPanel(), gridBagConstraints2);
			jContentPane.add(getResultScrollPane(), gridBagConstraints3);
			jContentPane.add(getErrorScrollPane(), gridBagConstraints4);
		}
		return jContentPane;
	}

	/**
	 * ʃXN[yC擾܂B<br>
	 * @return JScrollPaneIuWFNg
	 */
	private JScrollPane getResultScrollPane() {
		if (resultScrollPane == null) {
			resultScrollPane = new JScrollPane();
			resultScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
			resultScrollPane.setViewportView(getResultTable());
			resultScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		}
		return resultScrollPane;
	}

	/**
	 * ʃe[u擾܂B<br>
	 * @return JTableIuWFNg
	 */
	public JTable getResultTable() {
		if (resultTable == null) {
			resultTable = new JTable();
			resultTable.setDefaultRenderer(Object.class, new RecordTableModelAccessorRenderer(resultTable));
			resultTable.setDefaultEditor(Object.class, new RecordTableModelAccessorEditor(resultTable));
			resultTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		}
		return resultTable;
	}

	/**
	 * {^pl擾܂B<br>
	 * @return JPanelIuWFNg
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints1.gridx = 0;
			gridBagConstraints1.gridy = 0;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.BOTH;
			gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints2.gridx = 1;
			gridBagConstraints2.gridy = 0;
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints3.gridx = 2;
			gridBagConstraints3.gridy = 0;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.fill = GridBagConstraints.BOTH;
			gridBagConstraints4.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints4.gridx = 3;
			gridBagConstraints4.gridy = 0;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints5.gridx = 4;
			gridBagConstraints5.gridy = 0;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.fill = GridBagConstraints.BOTH;
			gridBagConstraints6.insets = new Insets(1, 1, 1, 1);
			gridBagConstraints6.gridx = 5;
			gridBagConstraints6.gridy = 0;
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new GridBagLayout());
			buttonPanel.setSize(new Dimension(507, 78));
			buttonPanel.add(getExecuteButton(), gridBagConstraints1);
			buttonPanel.add(getInsertButton(), gridBagConstraints2);
			buttonPanel.add(getDeleteButton(), gridBagConstraints3);
			buttonPanel.add(getCommitButton(), gridBagConstraints4);
			buttonPanel.add(getRollbackButton(), gridBagConstraints5);
			buttonPanel.add(getCloseButton(), gridBagConstraints6);
		}
		return buttonPanel;
	}

	/**
	 * Execute{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getExecuteButton() {
		if (executeButton == null) {
			executeButton = new JButton();
			executeButton.setText("Execute");
			executeButton.setPreferredSize(new Dimension(86, 24));
			executeButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						getExecuteButton().setEnabled(false);

						if (getResultTable().getModel() != null && getResultTable().getModel() instanceof RecordTableModelAccessor) {
							RecordTableModelAccessor accessor = (RecordTableModelAccessor) getResultTable().getModel();
							session.rollback();
							session.close();
						}

						DatabaseQueryManager manager = new DatabaseQueryManager(session);
						manager.setQuery(getQueryTextArea().getText());
						manager.execute();

						if (!manager.isSelectQuery()) {
							session.commit();
						}

						if (manager.isSelectQuery()) {
							RecordTableModelAccessor accessor = new RecordTableModelAccessor(manager.getResultSet());
							getResultTable().setModel(accessor);
							getResultTable().setEnabled(true);

							for (int i = 0; i <= accessor.getResultRowDefinition().getColumnCount() - 1; i++) {
								TableColumnModel columnModel = getResultTable().getColumnModel();
								String headerString = (String) getResultTable().getTableHeader().getColumnModel().getColumn(i).getHeaderValue();
								int size = accessor.getResultColumnDefinition(i).getDisplaySize();
								size = size < headerString.length() ? headerString.length() : size;
								size = size > 25 ? 25 : size;
								columnModel.getColumn(i).setPreferredWidth(size * 8);
							}
						} else {
							getResultTable().setModel(new DefaultTableModel(new String[][] { { String.valueOf(manager.getUpdateCount()) } }, new String[] { "update_count" }));
							getResultTable().setEnabled(false);
						}

						getExecuteButton().setEnabled(true);
					} catch (Exception ex) {
						getExecuteButton().setEnabled(true);
						DefaultListModel model = (DefaultListModel) getErrorList().getModel();
						model.removeAllElements();
						model.addElement(ex.getMessage());
						ex.printStackTrace();
					}
				}
			});
		}
		return executeButton;
	}

	/**
	 * Close{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getCloseButton() {
		if (closeButton == null) {
			closeButton = new JButton();
			closeButton.setText("Close");
			closeButton.setPreferredSize(new Dimension(86, 24));
			closeButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						session.rollback();
						session.close();
					} catch (Exception ex) {
						DefaultListModel model = (DefaultListModel) getErrorList().getModel();
						model.removeAllElements();
						model.addElement(ex.getMessage());
						ex.printStackTrace();
					}
					System.exit(0);
				}
			});
		}
		return closeButton;
	}

	/**
	 * Insert{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getInsertButton() {
		if (insertButton == null) {
			insertButton = new JButton();
			insertButton.setText("Insert");
			insertButton.setPreferredSize(new Dimension(86, 24));
			insertButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (getResultTable().getModel() instanceof RecordTableModelAccessor) {
						try {
							RecordTableModelAccessor accessor = (RecordTableModelAccessor) getResultTable().getModel();
							accessor.insertRow();
						} catch (Exception ex) {
							DefaultListModel model = (DefaultListModel) getErrorList().getModel();
							model.removeAllElements();
							model.addElement(ex.getMessage());
							ex.printStackTrace();
						}
					}
				}
			});
		}
		return insertButton;
	}

	/**
	 * Delete{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getDeleteButton() {
		if (deleteButton == null) {
			deleteButton = new JButton();
			deleteButton.setText("Delete");
			deleteButton.setPreferredSize(new Dimension(86, 24));
			deleteButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (getResultTable().getModel() instanceof RecordTableModelAccessor) {
						try {
							RecordTableModelAccessor accessor = (RecordTableModelAccessor) getResultTable().getModel();
							int[] rows = getResultTable().getSelectedRows();
							for (int i = 0; i <= rows.length - 1; i++) {
								accessor.deleteRow(rows[i]);
							}
						} catch (Exception ex) {
							DefaultListModel model = (DefaultListModel) getErrorList().getModel();
							model.removeAllElements();
							model.addElement(ex.getMessage());
							ex.printStackTrace();
						}
					}
				}
			});
		}
		return deleteButton;
	}

	/**
	 * Commit{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getCommitButton() {
		if (commitButton == null) {
			commitButton = new JButton();
			commitButton.setText("Commit");
			commitButton.setPreferredSize(new Dimension(86, 24));
			commitButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					try {
						if (getResultTable().getModel() instanceof RecordTableModelAccessor) {
							RecordTableModelAccessor accessor = (RecordTableModelAccessor) getResultTable().getModel();
							accessor.updateResult();
							session.commit();
							accessor.refreshResult();
							DefaultListModel model = (DefaultListModel) getErrorList().getModel();
							model.removeAllElements();
							if (accessor.hasError()) {
								DatabaseError[] errors = accessor.getErrors();
								for (int i = 0; i <= errors.length - 1; i++) {
									if (errors[i].isSQLException()) {
										model.addElement(errors[i].getErrorMessage() + " (errorCode=" + errors[i].getErrorCode() + ")");
									} else {
										model.addElement(errors[i].getErrorMessage());
									}
								}
							}
						}
					} catch (Exception ex) {
						DefaultListModel model = (DefaultListModel) getErrorList().getModel();
						model.removeAllElements();
						model.addElement(ex.getMessage());
						ex.printStackTrace();
					}
				}
			});
		}
		return commitButton;
	}

	/**
	 * Rollback{^擾܂B<br>
	 * @return JButtonIuWFNg
	 */
	private JButton getRollbackButton() {
		if (rollbackButton == null) {
			rollbackButton = new JButton();
			rollbackButton.setText("Rollback");
			rollbackButton.setPreferredSize(new Dimension(86, 24));
			rollbackButton.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					if (getResultTable().getModel() instanceof RecordTableModelAccessor) {
						try {
							RecordTableModelAccessor accessor = (RecordTableModelAccessor) getResultTable().getModel();
							accessor.refreshResult();
							session.rollback();
						} catch (Exception ex) {
							DefaultListModel model = (DefaultListModel) getErrorList().getModel();
							model.removeAllElements();
							model.addElement(ex.getMessage());
							ex.printStackTrace();
						}
					}
				}
			});
		}
		return rollbackButton;
	}

	/**
	 * NGXN[yC擾܂B<br>
	 * @return JScrollPaneIuWFNg
	 */
	private JScrollPane getQueryScrollPane() {
		if (queryScrollPane == null) {
			queryScrollPane = new JScrollPane();
			queryScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			queryScrollPane.setMaximumSize(new Dimension(80, 80));
			queryScrollPane.setMinimumSize(new Dimension(80, 80));
			queryScrollPane.setViewportView(getQueryTextArea());
			queryScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		}
		return queryScrollPane;
	}

	/**
	 * NGeLXgGA擾܂B<br>
	 * @return JTextAreaIuWFNg
	 */
	private JTextArea getQueryTextArea() {
		if (queryTextArea == null) {
			queryTextArea = new JTextArea();
			queryTextArea.setText("select * from test");
		}
		return queryTextArea;
	}

	/**
	 * G[XN[yC擾܂B<br>
	 * @return JScrollPaneIuWFNg
	 */
	private JScrollPane getErrorScrollPane() {
		if (errorScrollPane == null) {
			errorScrollPane = new JScrollPane();
			errorScrollPane.setSize(new Dimension(245, 47));
			errorScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			errorScrollPane.setMinimumSize(new Dimension(0, 80));
			errorScrollPane.setMaximumSize(new Dimension(0, 80));
			errorScrollPane.setViewportView(getErrorList());
		}
		return errorScrollPane;
	}

	/**
	 * G[Xg擾܂B<br>
	 * @return JListIuWFNg
	 */
	private JList getErrorList() {
		if (errorList == null) {
			errorList = new JList(new DefaultListModel());
		}
		return errorList;
	}
}
