package org.phosphoresce.commons.database.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.phosphoresce.commons.database.exception.DatabaseSessionException;
import org.phosphoresce.commons.database.exception.QueryOperateException;

/**
 * f[^x[XNGs}l[WNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/15	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseQueryManager {

	/** K[IuWFNg */
	private Log log = LogFactory.getLog(this.getClass());

	/** f[^x[XZbV */
	private DatabaseSession session = null;

	/** f[^x[XNG */
	private String query = null;

	/** sς݃tO */
	private boolean executed = false;

	/** XVJEg */
	private int updateCount = 0;

	/** ResultSetIuWFNg */
	private ResultSet resultSet = null;

	/** sG[ێIuWFNg */
	private DatabaseError error = null;

	/**
	 * RXgN^<br>
	 */
	private DatabaseQueryManager() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbV
	 * @param query f[^x[XNG
	 * @throws QueryOperateException ɃNXłȂꍇɔ
	 */
	public DatabaseQueryManager(DatabaseSession session, String query) throws QueryOperateException {
		super();
		if (session == null) {
			throw new QueryOperateException("null 'session' argument.");
		}
		this.session = session;
		this.query = query;
		this.executed = false;
		this.updateCount = 0;
		this.resultSet = null;
		this.error = null;
	}

	/**
	 * RXgN^<br>
	 * @param session f[^x[XZbV
	 * @throws QueryOperateException ɃNXłȂꍇɔ
	 */
	public DatabaseQueryManager(DatabaseSession session) throws QueryOperateException {
		this(session, "");
	}

	/**
	 * sς݃tO擾܂B<br>
	 * @return sς݃tO
	 */
	public boolean isExecuted() {
		return executed;
	}

	/**
	 * ResultSetIuWFNg擾܂B<br>
	 * @return ResultSetIuWFNg
	 * @throws QueryOperateException SQLExceptionOĂɂւ炸ʂ擾悤Ƃꍇɔ
	 */
	public ResultSet getResultSet() throws QueryOperateException {
		if (hasError()) {
			throw new QueryOperateException("query manager has Exception.", error.getException());
		}
		return resultSet;
	}

	/**
	 * XV擾܂B<br>
	 * @return XV
	 * @throws QueryOperateException SQLExceptionOĂɂւ炸ʂ擾悤Ƃꍇɔ
	 */
	public int getUpdateCount() throws QueryOperateException {
		if (hasError()) {
			throw new QueryOperateException("query manager has Exception.", error.getException());
		}
		return updateCount;
	}

	/**
	 * f[^x[XNG擾܂B<br>
	 * @return f[^x[XNG
	 */
	public String getQuery() {
		return query;
	}

	/**
	 * f[^x[XNGݒ肵܂B<br>
	 * VNGݒ肳ꂽ^C~OŕێĂO̎sʂׂ͂Ĕj܂B<br>
	 * AAZbVɑ΂gUNVǗ͍sꂸAȎɈϏ܂B<br>
	 * @param query f[^x[XNG
	 */
	public void setQuery(String query) {
		this.query = query;
		this.executed = false;
		this.updateCount = 0;
		this.resultSet = null;
		this.error = null;
	}

	/**
	 * w肳Ăf[^x[XNGINGł邩肵܂B<br>
	 * @return w肳Ăf[^x[XNGINGłtrueԋp
	 */
	public boolean isSelectQuery() {
		return query.trim().toLowerCase().startsWith("select");
	}

	/**
	 * sG[ێIuWFNg擾܂B<br>
	 * @return sG[ێIuWFNg
	 */
	public DatabaseError getError() {
		return error;
	}

	/**
	 * OIuWFNgێ邩肵܂B<br>
	 * @return OIuWFNgێꍇtrueԋp
	 */
	public boolean hasError() {
		return error != null;
	}

	/**
	 * w肳Ăf[^x[XNGs܂B<br>
	 * NGšʂ̓NXtB[hɕێANZbT\bh擾܂B<br>
	 * @throws DatabaseSessionException Ƀf[^x[XRlNVmłȂꍇɔ
	 * @throws QueryOperateException SQLExceptionȊO̗vŐɃNGsłȂꍇɔ
	 */
	public void execute() throws DatabaseSessionException, QueryOperateException {
		executed = false;
		updateCount = 0;
		resultSet = null;
		error = null;

		log.trace("execute query : \n" + query);
		if (isSelectQuery()) {
			executeSelectQuery();
		} else {
			executeUpdateQuery();
		}

		executed = true;
	}

	/**
	 * w肳Ăf[^x[XNGINGƂĎs܂B<br>
	 * NGsResultSet̓NXtB[hɕێANZbT\bh擾܂B<br>
	 * @throws DatabaseSessionException Ƀf[^x[XRlNVmłȂꍇɔ
	 * @throws QueryOperateException ɃNGsłȂꍇɔ
	 * @throws DatabaseSessionException 
	 */
	private void executeSelectQuery() throws DatabaseSessionException, QueryOperateException {
		try {
			Connection connection = session.getConnection();
			PreparedStatement statement = null;
			try {
				statement = connection.prepareStatement(query, ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_UPDATABLE);
			} catch (SQLException e1) {
				try {
					statement = connection.prepareStatement(query, ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE);
				} catch (SQLException e2) {
					try {
						statement = connection.prepareStatement(query, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_UPDATABLE);
					} catch (SQLException e3) {
						try {
							statement = connection.prepareStatement(query, ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
						} catch (SQLException e4) {
							try {
								statement = connection.prepareStatement(query);
							} catch (SQLException e5) {
								error = new DatabaseError(e5);
								log.error("failed to create PreparedStatement object.", e5);
							}
						}
					}
				}
			}
			if (statement == null) {
				throw new QueryOperateException("failed to create PreparedStatement object.");
			}
			resultSet = statement.executeQuery();
		} catch (SQLException e) {
			error = new DatabaseError(e);
			log.error("failed to execute select query.", e);
			session.rollback();
			session.close();
		}
	}

	/**
	 * w肳Ăf[^x[XNGINGƂĎs܂B<br>
	 * NGs̍XV̓NXtB[hɕێANZbT\bh擾܂B<br>
	 * @throws DatabaseSessionException Ƀf[^x[XRlNVmłȂꍇɔ
	 * @throws QueryOperateException ɃNGsłȂꍇɔ
	 */
	private void executeUpdateQuery() throws DatabaseSessionException, QueryOperateException {
		try {
			Connection connection = session.getConnection();
			PreparedStatement statement = null;
			statement = connection.prepareStatement(query);
			if (statement == null) {
				throw new QueryOperateException("failed to create PreparedStatement object.");
			}
			updateCount = statement.executeUpdate();
		} catch (SQLException e) {
			error = new DatabaseError(e);
			log.error("failed to execute update query.", e);
			session.rollback();
			session.close();
		}
	}
}
