package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;
import org.phosphoresce.commons.database.util.DatabaseStringUtil;
import org.phosphoresce.commons.database.util.ResultSetUtil;

/**
 * f[^x[XێReiNX<br>
 * f[^x[XReiێe[u̓JgXL[}̃e[uƂȂ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/18	Kitagawa		VK쐬
 *-->
 */
public final class DatabaseContainer implements Serializable, DatabaseCatalogHolder, DatabaseSchemaHolder, DatabaseTableHolder {

	/** J^OXg */
	private List catalogList = null;

	/** XL[}Xg */
	private List schemaList = null;

	/** e[uXg */
	private List tableList = null;

	/**
	 * RXgN^<br>
	 */
	protected DatabaseContainer() {
		this.catalogList = new LinkedList();
		this.schemaList = new LinkedList();
		this.tableList = new LinkedList();
	}

	/**
	 * ReiIuWFNĝ͖ێ܂B<br>
	 * Ȃ킿Anullԋp܂B<br>
	 * @return null
	 * @see org.phosphoresce.commons.database.container.DatabaseHoldingContainer#getName()
	 */
	public String getName() {
		return null;
	}

	/**
	 * J^OXgCe[^擾܂B<br>
	 * @return J^OXgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseCatalogHolder#getCatalogListIterator()
	 */
	public Iterator getCatalogListIterator() {
		return catalogList.iterator();
	}

	/**
	 * J^OXg擾܂B<br>
	 * @return J^OXg
	 * @see org.phosphoresce.commons.database.container.DatabaseCatalogHolder#getCatalogListCount()
	 */
	public int getCatalogListCount() {
		return catalogList.size();
	}

	/**
	 * J^O擾܂B<br>
	 * @param name J^O
	 * @return J^O
	 * @see org.phosphoresce.commons.database.container.DatabaseCatalogHolder#getCatalog(java.lang.String)
	 */
	public DatabaseCatalog getCatalog(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = catalogList.iterator(); iterator.hasNext();) {
			DatabaseCatalog catalog = (DatabaseCatalog) iterator.next();
			if (key.equals(catalog.getName())) {
				return catalog;
			}
		}
		return null;
	}

	/**
	 * XL[}XgCe[^擾܂B<br>
	 * @return XL[}XgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchemaListIterator()
	 */
	public Iterator getSchemaListIterator() {
		return schemaList.iterator();
	}

	/**
	 * XL[}Xg擾܂B<br>
	 * @return XL[}Xg
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchemaListCount()
	 */
	public int getSchemaListCount() {
		return schemaList.size();
	}

	/**
	 * XL[}擾܂B<br>
	 * @param name XL[}
	 * @return XL[}
	 * @see org.phosphoresce.commons.database.container.DatabaseSchemaHolder#getSchema(java.lang.String)
	 */
	public DatabaseSchema getSchema(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = schemaList.iterator(); iterator.hasNext();) {
			DatabaseSchema schema = (DatabaseSchema) iterator.next();
			if (key.equals(schema.getName())) {
				return schema;
			}
		}
		return null;
	}

	/**
	 * e[uXgCe[^擾܂B<br>
	 * @return e[uXgCe[^
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListIterator()
	 */
	public Iterator getTableListIterator() {
		return tableList.iterator();
	}

	/**
	 * e[uXg擾܂B<br>
	 * @return e[uXg
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTableListCount()
	 */
	public int getTableListCount() {
		return tableList.size();
	}

	/**
	 * e[u擾܂B<br>
	 * @param name e[u
	 * @return e[u
	 * @see org.phosphoresce.commons.database.container.DatabaseTableHolder#getTable(java.lang.String)
	 */
	public DatabaseTable getTable(String name) {
		String key = name == null ? "" : name;
		for (Iterator iterator = tableList.iterator(); iterator.hasNext();) {
			DatabaseTable table = (DatabaseTable) iterator.next();
			if (key.equals(table.getName())) {
				return table;
			}
		}
		return null;
	}

	/**
	 * w肳ꂽJ^OIuWFNgǉ܂B<br>
	 * @param catalog J^OIuWFNg
	 */
	protected void addCatalog(DatabaseCatalog catalog) {
		catalogList.add(catalog);
	}

	/**
	 * w肳ꂽXL[}IuWFNgǉ܂B<br>
	 * @param schema XL[}IuWFNg
	 */
	protected void addSchema(DatabaseSchema schema) {
		schemaList.add(schema);
	}

	/**
	 * w肳ꂽe[uIuWFNgǉ܂B<br>
	 * @param table e[uIuWFNg
	 */
	protected void addTable(DatabaseTable table) {
		tableList.add(table);
	}

	/**
	 * w肳ꂽf[^x[XZbVf[^x[Xe[uReiIuWFNg𐶐܂B<br>
	 * @param session f[^x[XZbV
	 * @return f[^x[Xe[uReiIuWFNg
	 * @throws ResultSetAccessException ResultSet͂łȂꍇɔ
	 */
	public static DatabaseContainer createDatabaseContainer(DatabaseSession session) throws ResultSetAccessException {
		DatabaseContainer container = new DatabaseContainer();
		try {
			DatabaseMetaData databaseMetaData = session.getConnection().getMetaData();
			ResultSet resultSet = databaseMetaData.getTables(null, null, null, new String[] { "TABLE" });
			while (resultSet.next()) {
				String catalogName = null;
				String schemaName = null;
				String tableName = null;
				if (ResultSetUtil.containsColumn(resultSet, "TABLE_CAT")) {
					catalogName = resultSet.getString("TABLE_CAT");
				}
				if (ResultSetUtil.containsColumn(resultSet, "TABLE_SCHEM")) {
					schemaName = resultSet.getString("TABLE_SCHEM");
				}
				if (ResultSetUtil.containsColumn(resultSet, "TABLE_NAME")) {
					tableName = resultSet.getString("TABLE_NAME");
				}
				if (!DatabaseStringUtil.isEmpty(catalogName)) {
					if (container.getCatalog(catalogName) == null) {
						container.addCatalog(new DatabaseCatalog(catalogName));
						container.getCatalog(catalogName).setCatalogHolder(container);
					}
					DatabaseCatalog catalog = container.getCatalog(catalogName);
					if (!DatabaseStringUtil.isEmpty(schemaName)) {
						if (catalog.getSchema(schemaName) == null) {
							catalog.addSchema(new DatabaseSchema(schemaName));
							catalog.getSchema(schemaName).setSchemaHolder(catalog);
						}
						DatabaseSchema schema = catalog.getSchema(schemaName);
						if (!DatabaseStringUtil.isEmpty(tableName)) {
							if (schema.getTable(tableName) == null) {
								schema.addTable(new DatabaseTable(tableName));
								schema.getTable(tableName).setTableHolder(schema);
							}
						}
					} else {
						if (!DatabaseStringUtil.isEmpty(tableName)) {
							if (catalog.getTable(tableName) == null) {
								catalog.addTable(new DatabaseTable(tableName));
								catalog.getTable(tableName).setTableHolder(catalog);
							}
						}
					}
				} else if (!DatabaseStringUtil.isEmpty(schemaName)) {
					if (container.getSchema(schemaName) == null) {
						container.addSchema(new DatabaseSchema(schemaName));
						container.getSchema(schemaName).setSchemaHolder(container);
					}
					DatabaseSchema schema = container.getSchema(schemaName);
					if (!DatabaseStringUtil.isEmpty(tableName)) {
						if (schema.getTable(tableName) == null) {
							schema.addTable(new DatabaseTable(tableName));
							schema.getTable(tableName).setTableHolder(schema);
						}
					}
				} else if (!DatabaseStringUtil.isEmpty(tableName)) {
					if (container.getTable(tableName) == null) {
						container.addTable(new DatabaseTable(tableName));
						container.getTable(tableName).setTableHolder(container);
					}
				}
			}
			return container;
		} catch (Throwable e) {
			throw new ResultSetAccessException("failed to analyze database meta data.", e);
		}
	}
}
