package org.phosphoresce.commons.database.accessor.util;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.phosphoresce.commons.database.accessor.ResultColumnDefinition;
import org.phosphoresce.commons.database.exception.IllegalColumnValueException;

/**
 * R[hJANZXɂ郆[eBeBNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/15	Kitagawa		VK쐬
 *-->
 */
public final class AccessorColumnUtil {

	/**
	 * RXgN^<br>
	 */
	private AccessorColumnUtil() {
		super();
	}

	/**
	 * IuWFNgw肳ꂽJ^CvNXɍ킹IuWFNgƂĒ񋟂܂B<br>
	 * @param value ݒΏۃIuWFNg
	 * @return J^Cvɍ킹IuWFNg
	 * @throws IllegalColumnValueException ɃJ^CṽIuWFNgɕϊłȂꍇɔ
	 */
	public static Object renderColumnObject(ResultColumnDefinition definition, Object value) throws IllegalColumnValueException {
		try {
			Object render = null;
			if (value == null) {
				render = null;
			} else {
				if (value instanceof String) {
					String string = value.toString();
					if (definition.getColumnClass().equals(Byte.class)) {
						render = new Byte(Byte.parseByte(string));
					} else if (definition.getColumnClass().equals(String.class)) {
						render = string;
					} else if (definition.getColumnClass().equals(BigDecimal.class)) {
						render = new BigDecimal(string);
					} else if (definition.getColumnClass().equals(Short.class)) {
						render = new Short(Short.parseShort(string));
					} else if (definition.getColumnClass().equals(Integer.class)) {
						render = new Integer(Integer.parseInt(string));
					} else if (definition.getColumnClass().equals(Long.class)) {
						render = new Long(Long.parseLong(string));
					} else if (definition.getColumnClass().equals(Float.class)) {
						render = new Float(Float.parseFloat(string));
					} else if (definition.getColumnClass().equals(Double.class)) {
						render = new Double(Double.parseDouble(string));
					} else if (definition.getColumnClass().equals(byte[].class)) {
						render = string.getBytes();
					} else if (definition.getColumnClass().equals(Date.class)) {
						render = parseDate(string);
					} else if (definition.getColumnClass().equals(Time.class)) {
						render = Time.valueOf(new SimpleDateFormat("HH:mm:ss").format(parseDate(string)));
					} else if (definition.getColumnClass().equals(Timestamp.class)) {
						render = Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").format(parseDate(string)));
					} else if (definition.getColumnClass().equals(Boolean.class)) {
						render = new Boolean("true".equals(string.toLowerCase()) || "1".equals(string));
					} else if (definition.getColumnClass().equals(InputStream.class)) {
						//
					} else if (definition.getColumnClass().equals(Blob.class)) {
					} else if (definition.getColumnClass().equals(Clob.class)) {
					} else if (definition.getColumnClass().equals(java.sql.Date.class)) {
						render = java.sql.Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(parseDate(string)));
					} else {
						//
					}
				} else {
					if (!definition.getColumnClass().equals(value.getClass())) {
						throw new IllegalColumnValueException("failed to convert column value. column type is '" + definition.getColumnClass().getName() + "', but parameter is '"
								+ value.getClass().getName() + "'.");
					}
				}
			}
			return render;
		} catch (Throwable throwable) {
			throw new IllegalColumnValueException("failed to convert column value. column type is '" + definition.getColumnClass().getName() + "'.", throwable);
		}
	}

	/**
	 * w肳ꂽ񂩂DateIuWFNgɃp[X܂B<br>
	 * @param value DateIuWFNgɃp[X\ȕ
	 * @return DateIuWFNg
	 * @throws ParseException p[XɎsꍇɔ
	 */
	public static Date parseDate(String value) throws ParseException {
		ParseException throwable = null;
		Date date = null;
		if (value == null || "".equals(value)) {
			return date;
		}
		try {
			date = new SimpleDateFormat("y/M/d H:m:s.S").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("y/M/d H:m").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("yyyy/MM/dd").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("y-M-d H:m:s.S").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("y-M-d H:m").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("y-M-d").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("H:m:s.S").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("H:m:s").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("H:m").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("yyyyMMddHHmmss").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("yyyyMMddHHmm").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("yyyyMMdd").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("HHmmssSSS").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("HHmmss").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		try {
			date = new SimpleDateFormat("HHmm").parse(value);
			if (date != null) {
				return date;
			}
		} catch (ParseException e) {
			throwable = e;
		}
		if (throwable != null) {
			throw throwable;
		}
		return date;
	}
}
