package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * sێNX<br>
 * <br>
 * NX͍sɕꂽNXłȀXVŗLrefreshResultC^tF[X
 * RXgN^ɂČĂ΂邽߁ÃNXp邱Ƃ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultRow extends ResultAccessorAbstract {

	/** s`IuWFNg */
	private ResultRowDefinition definition;

	/** sCfbNX */
	private int index = -1;

	/** JIuWFNgXg */
	private List columns = new LinkedList();

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param state ԊǗXi[IuWFNg
	 * @param listener R[hANZXXi[IuWFNg
	 * @param definition `IuWFNg
	 * @param index sʒu
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultRow(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener, ResultRowDefinition definition, int index) throws ResultSetAccessException,
			IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet, state, listener);
		this.definition = definition;
		this.index = index;
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force 󋵂Ɋւ炸IɍXVꍇtruewAG[̏ꍇɓ̏󋵂ɂĂ͍XVsȂꍇfalsew
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		definition.refreshResult(force);
		int currentRow = getResultSetRowIndex();
		try {
			int columnCount = resultSet.getMetaData().getColumnCount();
			if (state == ResultAccessorState.INSERT_ERROR) {
				if (force) {
					for (int i = 0; i <= columnCount - 1; i++) {
						ResultColumn column = null;
						if (i <= columns.size() - 1) {
							column = (ResultColumn) columns.get(i);
							column.setRow(this);
							column.setIndex(i);
							column.refreshResult(force);
						} else {
							column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
							columns.add(column);
						}
					}
					if (columns.size() > columnCount) {
						for (int i = 0; i <= columns.size() - columnCount - 1; i++) {
							columns.remove(columns.size() - 1);
						}
					}
				}
			} else if (state == ResultAccessorState.UPDATE_ERROR) {
				if (force) {
					for (int i = 0; i <= columnCount - 1; i++) {
						ResultColumn column = null;
						if (i <= columns.size() - 1) {
							column = (ResultColumn) columns.get(i);
							column.setRow(this);
							column.setIndex(i);
							column.refreshResult(force);
						} else {
							column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
							columns.add(column);
						}
					}
					if (columns.size() > columnCount) {
						for (int i = 0; i <= columns.size() - columnCount - 1; i++) {
							columns.remove(columns.size() - 1);
						}
					}
				}
			} else if (state == ResultAccessorState.REMOVED) {
				//
			} else if (state == ResultAccessorState.DELETE) {
				//
			} else if (state == ResultAccessorState.INSERT_DELETE) {
				//
			} else if (state == ResultAccessorState.INSERT) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = null;
					if (i <= columns.size() - 1) {
						column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
						columns.add(column);
						column = (ResultColumn) columns.get(i);
						column.setRow(this);
						column.setIndex(i);
						column.refreshResult(force);
					} else {
						column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
						columns.add(column);
					}
				}
			} else if (state == ResultAccessorState.UPDATE) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = null;
					if (i <= columns.size() - 1) {
						column = (ResultColumn) columns.get(i);
						column.setRow(this);
						column.setIndex(i);
						column.refreshResult(force);
					} else {
						column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
						columns.add(column);
					}
				}
				if (columns.size() > columnCount) {
					for (int i = 0; i <= columns.size() - columnCount - 1; i++) {
						columns.remove(columns.size() - 1);
					}
				}
			} else if (state == ResultAccessorState.STATIC) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = null;
					if (i <= columns.size() - 1) {
						column = (ResultColumn) columns.get(i);
						column.setRow(this);
						column.setIndex(i);
						column.refreshResult(force);
					} else {
						column = new ResultColumn(resultSet, state, listener, this, definition.getColumnDefinition(i), i);
						columns.add(column);
					}
				}
				if (columns.size() > columnCount) {
					for (int i = 0; i <= columns.size() - columnCount - 1; i++) {
						columns.remove(columns.size() - 1);
					}
				}
			}
		} catch (SQLException e) {
			//throw new ResultSetAccessException(ExceptionMessage.get("ResultSetAccessException.0002", index), e);
			if (state == ResultAccessorState.INSERT) {
				state = ResultAccessorState.INSERT_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.INSERT_ERROR;
				}
			} else if (state == ResultAccessorState.INSERT_ERROR) {
				state = ResultAccessorState.INSERT_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.INSERT_ERROR;
				}
			} else {
				state = ResultAccessorState.UPDATE_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.UPDATE_ERROR;
				}
			}
			error = new DatabaseError(index, e);
		} finally {
			moveCurser(currentRow);
			if (validateStateListener()) {
				listener.rowUpdated(index, index);
			}
		}
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		int currentRow = getResultSetRowIndex();
		try {
			error = null;
			int columnCount = resultSet.getMetaData().getColumnCount();
			if (state == ResultAccessorState.INSERT_ERROR) {
				resultSet.moveToInsertRow();
				boolean hasError = false;
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = (ResultColumn) columns.get(i);
					column.updateResult();
					if (column.hasError()) {
						hasError = true;
					}
				}
				if (!hasError) {
					resultSet.insertRow();
					state = ResultAccessorState.STATIC;
					resultSet.last();
					index = resultSet.getRow() - 1;
				} else {
					state = ResultAccessorState.INSERT_ERROR;
					for (int i = 0; i <= columnCount - 1; i++) {
						ResultColumn column = (ResultColumn) columns.get(i);
						if (column.state != ResultAccessorState.INSERT_ERROR) {
							column.state = ResultAccessorState.INSERT;
						}
					}
				}
			} else if (state == ResultAccessorState.UPDATE_ERROR) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = (ResultColumn) columns.get(i);
					column.updateResult();
				}
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.REMOVED) {
				//
			} else if (state == ResultAccessorState.DELETE) {
				if (index >= 0) {
					resultSet.absolute(index + 1);
					resultSet.deleteRow();
				}
				state = ResultAccessorState.REMOVED;
			} else if (state == ResultAccessorState.INSERT_DELETE) {
				//
			} else if (state == ResultAccessorState.INSERT) {
				resultSet.moveToInsertRow();
				boolean hasError = false;
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = (ResultColumn) columns.get(i);
					column.updateResult();
					if (column.hasError()) {
						hasError = true;
					}
				}
				if (!hasError) {
					resultSet.insertRow();
					state = ResultAccessorState.STATIC;
					resultSet.last();
					index = resultSet.getRow() - 1;
				} else {
					state = ResultAccessorState.INSERT_ERROR;
					for (int i = 0; i <= columnCount - 1; i++) {
						ResultColumn column = (ResultColumn) columns.get(i);
						if (column.state != ResultAccessorState.INSERT_ERROR) {
							column.state = ResultAccessorState.INSERT;
						}
					}
				}
			} else if (state == ResultAccessorState.UPDATE) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = (ResultColumn) columns.get(i);
					column.updateResult();
				}
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.STATIC) {
				for (int i = 0; i <= columnCount - 1; i++) {
					ResultColumn column = (ResultColumn) columns.get(i);
					column.updateResult();
				}
				state = ResultAccessorState.STATIC;
			}
		} catch (SQLException e) {
			if (state == ResultAccessorState.INSERT) {
				state = ResultAccessorState.INSERT_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.INSERT_ERROR;
				}
			} else if (state == ResultAccessorState.INSERT_ERROR) {
				state = ResultAccessorState.INSERT_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.INSERT_ERROR;
				}
			} else {
				state = ResultAccessorState.UPDATE_ERROR;
				for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
					ResultColumn column = (ResultColumn) iterator.next();
					column.state = ResultAccessorState.UPDATE_ERROR;
				}
			}
			error = new DatabaseError(index, e);
		} finally {
			moveCurser(currentRow);
			if (validateStateListener()) {
				listener.rowUpdated(index, index);
			}
		}
	}

	// Public Method

	/**
	 * s`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 */
	public ResultRowDefinition getDefinition() {
		return definition;
	}

	/**
	 * sCfbNX擾܂B<br>
	 * @return sCfbNX
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * w肳ꂽJCfbNX̃JIuWFNg擾܂B<br>
	 * @param index JCfbNX(0`)
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	public ResultColumn getColumn(int index) throws IllegalResultSetLocationIndexException {
		if (columns.size() - 1 < index || index < 0) {
			throw new IllegalResultSetLocationIndexException("illegal column index. [" + index + "]");
		}
		return (ResultColumn) columns.get(index);
	}

	/**
	 * w肳ꂽJ̃JIuWFNg擾܂B<br>
	 * @param name J
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException w肳ꂽJsɑ݂Ȃꍇɔ
	 */
	public ResultColumn getColumn(String name) throws IllegalResultSetLocationIndexException {
		return getColumn(definition.getColumnIndex(name));
	}

	// Default Method

	/**
	 * w肳ꂽJCfbNXʒuɎw肳ꂽJIuWFNgݒ肵܂B<br>
	 * ͎wʒũJIuWFNgSɒu鏈ƂȂ܂B<br>
	 * R[hANZX݌vɖ𔭐\ׁApublicȑ͎܂B<br>
	 * @param index JCfbNX(0`)
	 * @param column JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃJCfbNXw肳ꂽꍇɔ
	 */
	final void setColumn(int index, ResultColumn column) throws IllegalResultSetLocationIndexException {
		if (columns.size() - 1 < index || index < 0) {
			throw new IllegalResultSetLocationIndexException("illegal column index. [" + index + "]");
		}
		columns.set(index, column);
	}

	/**
	 * w肳ꂽsCfbNXɎg̃CfbNXtB[hύX܂B<br>
	 * ͈ꎞIɕsȍsƂȂ邱Ƃz肳ׁApublicȑ͎܂B<br>
	 * @param index sCfbNX
	 */
	final void setIndex(int index) {
		this.index = index;
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("[");
		for (Iterator iterator = columns.iterator(); iterator.hasNext();) {
			buffer.append(iterator.next());
			if (iterator.hasNext()) {
				buffer.append(", ");
			}
		}
		buffer.append("]");
		return buffer.toString();
	}
}
