package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * J`ێNX<br>
 * <br>
 * NX̓J`ɕꂽNXłȀXVŗLrefreshResultC^tF[X
 * RXgN^ɂČĂ΂邽߁ÃNXp邱Ƃ܂B<br>
 * ܂ANX͊ƂȂResultSetɂāAsʒȕ͕svł邽߁Asʒu͕ێA񋟂܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultColumnDefinition extends ResultAccessorAbstract {

	/** JCfbNX */
	private int index;

	/** J^O */
	private String catalog;

	/** XL[} */
	private String schema;

	/** e[u */
	private String table;

	/** JNX */
	private Class clazz;

	/** J^Cv */
	private String typeName;

	/** Jx */
	private String label;

	/** J */
	private String name;

	/** Jʏő啝 */
	private int displaySize;

	/** J^Cv */
	private int type;

	/** 10i */
	private int precision;

	/** _ȉ */
	private int scale;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param index JCfbNX(0`)
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultColumnDefinition(ResultSet resultSet, int index) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet, ResultAccessorState.STATIC, null);
		this.index = index;
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force `݂̂̌gł邽߁AtOɊ֌WȂKXVs܂
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		int currentRow = getResultSetRowIndex();
		try {
			ResultSetMetaData metadata = resultSet.getMetaData();
			catalog = metadata.getCatalogName(index + 1);
			clazz = Class.forName(metadata.getColumnClassName(index + 1));
			label = metadata.getColumnLabel(index + 1);
			name = metadata.getColumnName(index + 1);
			typeName = metadata.getColumnTypeName(index + 1);
			schema = metadata.getSchemaName(index + 1);
			table = metadata.getTableName(index + 1);
			displaySize = metadata.getColumnDisplaySize(index + 1);
			type = metadata.getColumnType(index + 1);
			precision = metadata.getPrecision(index + 1);
			scale = metadata.getScale(index + 1);
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to refresh result.", e);
		} catch (ClassNotFoundException e) {
			throw new ResultSetAccessException("failed to refresh result.", e);
		} finally {
			moveCurser(currentRow);
		}
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * IuWFNg͒`݂̂{pƂĒ񋟂ׁA͉s܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
	}

	// Public Method

	/**
	 * JCfbNX擾܂B<br>
	 * @return JCfbNX
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * J^O擾܂B<br>
	 * @return J^O
	 */
	public String getCatalog() {
		return catalog;
	}

	/**
	 * JNX擾܂B<br>
	 * @return JNX
	 */
	public Class getColumnClass() {
		return clazz;
	}

	/**
	 * Jʏő啝擾܂B<br>
	 * @return Jʏő啝
	 */
	public int getDisplaySize() {
		return displaySize;
	}

	/**
	 * Jx擾܂B<br>
	 * @return Jx
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * J擾܂B<br>
	 * @return J
	 */
	public String getName() {
		return name;
	}

	/**
	 * J^Cv擾܂B<br>
	 * @return J^Cv
	 */
	public int getType() {
		return type;
	}

	/**
	 * J^Cv擾܂B<br>
	 * @return J^Cv
	 */
	public String getTypeName() {
		return typeName;
	}

	/**
	 * 10i擾܂B<br>
	 * @return 10i
	 */
	public int getPrecision() {
		return precision;
	}

	/**
	 * _ȉ擾܂B<br>
	 * @return _ȉ
	 */
	public int getScale() {
		return scale;
	}

	/**
	 * XL[}擾܂B<br>
	 * @return XL[}
	 */
	public String getSchema() {
		return schema;
	}

	/**
	 * e[u擾܂B<br>
	 * @return tableName
	 */
	public String getTable() {
		return table;
	}

	// Default Method

	/**
	 * JCfbNXݒ肵܂B<br>
	 * @param index JCfbNX
	 */
	void setIndex(int index) {
		this.index = index;
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("catalog=").append(catalog);
		buffer.append(", ");
		buffer.append("schema=").append(schema);
		buffer.append(", ");
		buffer.append("table=").append(table);
		buffer.append(", ");
		buffer.append("class=").append(clazz.getName());
		buffer.append(", ");
		buffer.append("typeName=").append(typeName);
		buffer.append(", ");
		buffer.append("label=").append(label);
		buffer.append(", ");
		buffer.append("name=").append(name);
		buffer.append(", ");
		buffer.append("displaySize=").append(displaySize);
		buffer.append(", ");
		buffer.append("type=").append(type);
		buffer.append(", ");
		buffer.append("precision=").append(precision);
		buffer.append(", ");
		buffer.append("scale=").append(scale);
		buffer.append("}");
		return buffer.toString();
	}
}
