package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.phosphoresce.commons.database.accessor.util.AccessorColumnUtil;
import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * JێNX<br>
 * <br>
 * NX̓JɕꂽNXłȀXVŗLrefreshResultC^tF[X
 * RXgN^ɂČĂ΂邽߁ÃNXp邱Ƃ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public final class ResultColumn extends ResultAccessorAbstract {

	/** J`IuWFNg */
	private ResultColumnDefinition definition;

	/** ʍsIuWFNg */
	private ResultRow row;

	/** JCfbNX */
	private int index = -1;

	/** JێIuWFNg */
	private Object value;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @param state R[h^Cv
	 * @param listener ԊǗXi[IuWFNg
	 * @param row ʍsIuWFNg
	 * @param definition J`IuWFNg
	 * @param index Jʒu(0`)
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	ResultColumn(ResultSet resultSet, ResultAccessorState state, ResultAccessorListener listener, ResultRow row, ResultColumnDefinition definition, int index)
			throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet, state, listener);
		this.definition = definition;
		this.row = row;
		this.index = index;
		refreshResult();
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force 󋵂Ɋւ炸IɍXVꍇtruewAG[̏ꍇɓ̏󋵂ɂĂ͍XVsȂꍇfalsew
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#refreshResult(boolean)
	 */
	protected void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		definition.refreshResult(force);
		int currentRow = getResultSetRowIndex();
		try {
			int columnCount = resultSet.getMetaData().getColumnCount();
			moveCurser(getRowIndex() + 1);
			if (state == ResultAccessorState.INSERT_ERROR) {
				//
			} else if (state == ResultAccessorState.UPDATE_ERROR) {
				if (force) {
					value = resultSet.getObject(index + 1);
					state = ResultAccessorState.STATIC;
				}
			} else if (state == ResultAccessorState.REMOVED) {
				//
			} else if (state == ResultAccessorState.DELETE) {
				value = resultSet.getObject(index + 1);
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.INSERT_DELETE) {
				//
			} else if (state == ResultAccessorState.INSERT) {
				//
			} else if (state == ResultAccessorState.UPDATE) {
				resultSet.absolute(row.getIndex() + 1);
				value = resultSet.getObject(index + 1);
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.STATIC) {
				resultSet.absolute(row.getIndex() + 1);
				value = resultSet.getObject(index + 1);
				state = ResultAccessorState.STATIC;
			}
		} catch (SQLException e) {
			//throw new ResultSetAccessException(ExceptionMessage.get("ResultSetAccessException.0004", row.getIndex(), index), e);
			if (state == ResultAccessorState.INSERT) {
				state = ResultAccessorState.INSERT_ERROR;
			} else if (state == ResultAccessorState.INSERT_ERROR) {
				state = ResultAccessorState.INSERT_ERROR;
			} else {
				state = ResultAccessorState.UPDATE_ERROR;
			}
			error = new DatabaseError(row.getIndex(), index, e);
		} finally {
			moveCurser(currentRow);
			if (validateStateListener()) {
				listener.columnChanged(row.getIndex(), index);
			}
		}
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.ResultAccessorAbstract#updateResult()
	 */
	protected void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		int currentRow = getResultSetRowIndex();
		try {
			error = null;
			int columnCount = resultSet.getMetaData().getColumnCount();
			if (state == ResultAccessorState.INSERT_ERROR) {
				// }͂̃^C~Oł͍s}͍̂s킸Aʂ̍sIuWFNgɏϏ
				// J[\ړɂĂʂōsĂ邱ƂO
				resultSet.updateObject(index + 1, AccessorColumnUtil.renderColumnObject(definition, value));
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.UPDATE_ERROR) {
				// XV͂̃^C~OōsړResultSetɔf
				resultSet.absolute(row.getIndex() + 1);
				resultSet.updateObject(index + 1, AccessorColumnUtil.renderColumnObject(definition, value));
				resultSet.updateRow();
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.REMOVED) {
				//
			} else if (state == ResultAccessorState.DELETE) {
				// 폜͏̍sIuWFNgɏϏ
				state = ResultAccessorState.REMOVED;
			} else if (state == ResultAccessorState.INSERT_DELETE) {
				//
			} else if (state == ResultAccessorState.INSERT) {
				// }͂̃^C~Oł͍s}͍̂s킸Aʂ̍sIuWFNgɏϏ
				// J[\ړɂĂʂōsĂ邱ƂO
				resultSet.updateObject(index + 1, AccessorColumnUtil.renderColumnObject(definition, value));
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.UPDATE) {
				// XV͂̃^C~OōsړResultSetɔf
				resultSet.absolute(row.getIndex() + 1);
				resultSet.updateObject(index + 1, AccessorColumnUtil.renderColumnObject(definition, value));
				resultSet.updateRow();
				state = ResultAccessorState.STATIC;
			} else if (state == ResultAccessorState.STATIC) {
				//
			}
		} catch (Exception e) {
			if (state == ResultAccessorState.INSERT) {
				state = ResultAccessorState.INSERT_ERROR;
			} else if (state == ResultAccessorState.INSERT_ERROR) {
				state = ResultAccessorState.INSERT_ERROR;
			} else {
				state = ResultAccessorState.UPDATE_ERROR;
			}
			error = new DatabaseError(row.getIndex(), index, e);
		} finally {
			//moveCurser(currentRow);
			if (validateStateListener()) {
				listener.columnChanged(row.getIndex(), index);
			}
		}
	}

	// Public Method

	/**
	 * J`IuWFNg擾܂B<br>
	 * @return J`IuWFNg
	 */
	public ResultColumnDefinition getDefinition() {
		return definition;
	}

	/**
	 * JCfbNX擾܂B<br>
	 * @return JCfbNX
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * sCfbNX擾܂B<br>
	 * @return sCfbNX
	 */
	public int getRowIndex() {
		return row.getIndex();
	}

	/**
	 * JێIuWFNg擾܂B<br>
	 * @return JێIuWFNg
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * JێIuWFNgݒ肵܂B<br>
	 * @param value JێIuWFNg
	 */
	public void setValue(Object value) {
		if (this.value == null && value == null || (this.value != null && this.value.equals(value))) {
			return;
		}
		if (state == ResultAccessorState.REMOVED) {
			//
		} else if (state == ResultAccessorState.DELETE) {
			//
		} else if (state == ResultAccessorState.INSERT) {
			//
		} else if (state == ResultAccessorState.UPDATE) {
			state = ResultAccessorState.UPDATE;
			row.state = ResultAccessorState.UPDATE;
		} else if (state == ResultAccessorState.INSERT) {
			state = ResultAccessorState.UPDATE;
			row.state = ResultAccessorState.UPDATE;
		} else if (state == ResultAccessorState.STATIC) {
			state = ResultAccessorState.UPDATE;
			row.state = ResultAccessorState.UPDATE;
		}
		this.value = value;
		if (validateStateListener()) {
			listener.columnChanged(row.getIndex(), index);
		}
	}

	// Default Method

	/**
	 * ʍsIuWFNgݒ肵܂B<br>
	 * @param row ʍsIuWFNg
	 */
	void setRow(ResultRow row) {
		this.row = row;
	}

	/**
	 * JCfbNXݒ肵܂B<br>
	 * @param resultColumnIndex JCfbNX
	 */
	void setIndex(int resultColumnIndex) {
		this.index = resultColumnIndex;
	}

	// Override Method

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return value == null ? null : value.toString();
	}
}
