package org.phosphoresce.commons.database.accessor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

/**
 * R[hf[^e[ufobt@ANZXpe[uZGfB^NX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/02	Kitagawa		VK쐬
 *-->
 */
public class RecordTableModelAccessorEditor extends AbstractCellEditor implements TableCellEditor {

	/** ee[uIuWFNg */
	private JTable parentTable;

	/** ҏWΏۃGfB^R|[lgIuWFNg */
	private JTextComponent editComponent;

	/** ҏWΏResultColumnIuWFNg */
	private ResultColumn editColumn;

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 */
	public RecordTableModelAccessorEditor(JTable table, JTextComponent editComponent) {
		this.parentTable = table;
		this.editComponent = editComponent == null ? new JTextField() : editComponent;
	}

	/**
	 * RXgN^<br>
	 * @param table JTableIuWFNg
	 */
	public RecordTableModelAccessorEditor(JTable table) {
		this(table, new JTextField());
	}

	/**
	 * JTabelIuWFNg̎w肳ꂽsʒũJIuWFNg擾A
	 * ҏWp̃R|[lgIuWFNg񋟂܂B<br>
	 * @param table JTableIuWFNg
	 * @param value JIuWFNg
	 * @param isSelected Iς݃tO
	 * @param row sʒu
	 * @param column Jʒu
	 * @return ҏWp̃R|[lgIuWFNg
	 * @see javax.swing.table.TableCellEditor#getTableCellEditorComponent(javax.swing.JTable, java.lang.Object, boolean, int, int)
	 */
	public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
		String render = "";
		if (value != null && value instanceof ResultColumn) {
			editColumn = (ResultColumn) value;
			Object object = editColumn.getValue();
			render = object == null ? "" : object.toString();
		}
		editComponent.setText(render);
		return editComponent;
	}

	/**
	 * ҏW̃ZIuWFNg擾܂B<br>
	 * NXԋpIuWFNgׂ͂{@link ResultColumn}IuWFNgƂȂ܂B<br>
	 * @return ҏW̃ZIuWFNg
	 * @see javax.swing.CellEditor#getCellEditorValue()
	 */
	public Object getCellEditorValue() {
		String value = editComponent.getText();
		if (editColumn != null) {
			editColumn.setValue(value);
		}
		return editColumn;
	}

	/**
	 * ҏWe܂B<br>
	 * ҏWefireEditingCanceledɈϏA
	 * ʒm̔zMΏۂAw肳ꂽCxg^œo^ׂẴXi[ɒʒm܂B<br>
	 * @see javax.swing.AbstractCellEditor#cancelCellEditing()
	 */
	public void cancelCellEditing() {
		fireEditingCanceled();
	}

	/**
	 * ҏW܂B<br>
	 * ҏWfireEditingStoppedɈϏA
	 * ʒm̔zMΏۂAw肳ꂽCxg^œo^ׂẴXi[ɒʒm܂B<br>
	 * @return ҏWƂtrueɕԋp
	 * @see javax.swing.AbstractCellEditor#stopCellEditing()
	 */
	public boolean stopCellEditing() {
		fireEditingStopped();
		return true;
	}

	/**
	 * eventMouseEventłȂꍇ́AtrueԂ܂B<br>
	 * MouseEvent̏ꍇ́A_uNbNsꂽۂtrueԋp܂B<br>
	 * @param event CxgIuWFNg
	 * @return ZҏW\ȏꍇtrueԋp
	 */
	public boolean isCellEditable(EventObject event) {
		if (event instanceof MouseEvent) {
			return ((MouseEvent) event).getClickCount() >= 2;
		}
		return true;
	}
}
