package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.util.EventListener;

import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

import org.phosphoresce.commons.database.exception.IllegalOperateRuntimeException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hf[^e[ufobt@ANZXIuWFNg<br>
 * <br>
 * {@link TableModel}C^tF[X郌R[hANZX@\񋟂܂B<br>
 * obt@Odl{@link RecordBufferedAccessor}ɂׂĈϏ܂B<br>
 * 
 * @see RecordAccessorAbstract
 * @see RecordBufferedAccessor
 *
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class RecordTableModelAccessor extends RecordBufferedAccessor implements TableModel {

	/** CxgXiXg */
	protected EventListenerList listenerList = new EventListenerList();

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException w肳ꂽReusltSetIuWFNg̃J[\ʒu擪OɂȂĂȂꍇɔ 
	 */
	public RecordTableModelAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet);
		this.listener = new RecordTableModelAccessorStateListener(this);
	}

	/**
	 * fsԂ܂B<br>
	 * Ȃ킿tFb`ς݂̃JEgԋp܂B<br>
	 * @return fs
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	public int getRowCount() {
		return fetchBuffer.size();
	}

	/**
	 * f񐔂Ԃ܂B<br>
	 * Ȃ킿ResultSet̃Jԋp܂B<br>
	 * @return f
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	public int getColumnCount() {
		try {
			return getResultColumnCount();
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to get column count", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to get column count", e);
		}
	}

	/**
	 * w肳ꂽJCfbNX̃J擾܂B<br>
	 * NX񋟂J̓e[uJƂȂ܂B<br>
	 * @param columnIndex JCfbNX
	 * @return J
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	public String getColumnName(int columnIndex) {
		try {
			return getResultRowDefinition().getColumnName(columnIndex);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to get column name", e);
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to get column name", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to get column name", e);
		}
	}

	/**
	 * w肳ꂽJCfbNX̃NX擾܂B<br>
	 * @param columnIndex JCfbNX
	 * @return NX
	 * @see javax.swing.table.TableModel#getColumnClass(int)
	 */
	public Class getColumnClass(int columnIndex) {
		return ResultColumn.class;
	}

	/**
	 * w肳ꂽsʒũIuWFNg擾܂B<br>
	 * @param rowIndex sʒu
	 * @param columnIndex ʒu
	 * @return w肳ꂽsʒũIuWFNg
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	public Object getValueAt(int rowIndex, int columnIndex) {
		try {
			return getResultColumn(rowIndex, columnIndex);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to get column value", e);
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to get column value", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to get column value", e);
		}
	}

	/**
	 * w肳ꂽsʒũIuWFNg̒lݒ肵܂B<br>
	 * @param value Vl
	 * @param rowIndex sʒu
	 * @param columnIndex ʒu
	 * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
	 */
	public void setValueAt(Object value, int rowIndex, int columnIndex) {
		try {
			if (value == null || !(value instanceof ResultColumn)) {
				throw new IllegalArgumentException("is not instancedof column object");
			}
			setResultColumn(rowIndex, columnIndex, (ResultColumn) value);
			fireTableCellUpdated(rowIndex, columnIndex);
		} catch (IllegalResultSetLocationIndexException e) {
			throw new IllegalOperateRuntimeException("failed to set column value", e);
		} catch (ResultSetAccessException e) {
			throw new IllegalOperateRuntimeException("failed to set column value", e);
		} catch (IllegalResultSetAdjustmentException e) {
			throw new IllegalOperateRuntimeException("failed to set column value", e);
		}
	}

	/**
	 * w肳ꂽsʒũZҏW\肵܂B<br>
	 * @param rowIndex sʒu
	 * @param columnIndex ʒu
	 * @return w肳ꂽsʒũZҏW\ȏꍇtrueԋp
	 * @see javax.swing.table.TableModel#isCellEditable(int, int)
	 */
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return true;
	}

	/**
	 * f[^fύX邽тɒʒm郊XgɃXi[ǉ܂B<br>
	 * @param listener TableModelListenerIuWFNg
	 * @see javax.swing.table.TableModel#addTableModelListener(javax.swing.event.TableModelListener)
	 */
	public void addTableModelListener(TableModelListener listener) {
		listenerList.add(TableModelListener.class, listener);
	}

	/**
	 * f[^fύX邽тɒʒm郊Xg烊Xi[폜܂B<br>
	 * @param listener TableModelListenerIuWFNg
	 * @see javax.swing.table.TableModel#removeTableModelListener(javax.swing.event.TableModelListener)
	 */
	public void removeTableModelListener(TableModelListener listener) {
		listenerList.remove(TableModelListener.class, listener);
	}

	/**
	 * ̃fɓo^ꂽAׂẴe[ufXi[ȂzԂ܂B<br>
	 * @return ̃fɓo^ꂽAׂẴe[ufXi[Ȃz
	 * @see #addTableModelListener(javax.swing.event.TableModelListener)
	 * @see #removeTableModelListener(javax.swing.event.TableModelListener)
	 */
	public TableModelListener[] getTableModelListeners() {
		return (TableModelListener[]) listenerList.getListeners(TableModelListener.class);
	}

	/**
	 * ̃fŎw肳ꂽNX^CvListenerƂČݓo^ĂAׂẴIuWFNgȂzԂ܂B<br>
	 * @param listenerType v郊Xi[̃^Cv
	 * @return ̃fŎw肳ꂽNX^CvListenerƂČݓo^ĂAׂẴIuWFNgȂz
	 * @see #getTableModelListeners()
	 */
	public EventListener[] getListeners(Class listenerType) {
		return listenerList.getListeners(listenerType);
	}

	/**
	 * e[u̍ŝׂẴZlύXĂ\邱ƂAׂẴXi[ɒʒm܂B<br>
	 * sύXĂꍇAJTable̓e[u̕`ŏ蒼Kv܂B<br>
	 * ̏ƂẴe[u̍\͓ƌȂ܂B<br>
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 * @see javax.swing.JTable#tableChanged(javax.swing.event.TableModelEvent)
	 */
	public void fireTableDataChanged() {
		fireTableChanged(new TableModelEvent(this));
	}

	/**
	 * e[u̍\ύXꂽƂׂẴXi[ɒʒm܂B<br>
	 * e[u̗񐔁AѐV̖Oƌ^AȑȌԂƈقȂĂ\܂B<br>
	 * JTablẽCxg󂯎AautoCreateColumnsFromModeltOݒ肳ĂꍇA
	 * JTable͂܂ŕێĂe[uׂ̗ĔjAfł̏ɏ]ăftHg̗Ăъ蓖Ă܂B<br>
	 * ́AJTablesetModel(TableModel)ĂяôƓłB<br>
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableStructureChanged() {
		fireTableChanged(new TableModelEvent(this, TableModelEvent.HEADER_ROW));
	}

	/**
	 * w肳ꂽJnsAIs͈̔(ǂ̒l܂)ōs}ꂽƂAׂẴXi[ɒʒm܂B<br>
	 * @param firstRow ŏ̍s
	 * @param lastRow  Ō̍s
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableRowsInserted(int firstRow, int lastRow) {
		fireTableChanged(new TableModelEvent(this, firstRow, lastRow, TableModelEvent.ALL_COLUMNS, TableModelEvent.INSERT));
	}

	/**
	 * w肳ꂽJnsAIs͈̔(ǂ̒l܂)ōsXVꂽƂAׂẴXi[ɒʒm܂B<br>
	 * @param firstRow ŏ̍s
	 * @param lastRow  Ō̍s
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableRowsUpdated(int firstRow, int lastRow) {
		fireTableChanged(new TableModelEvent(this, firstRow, lastRow, TableModelEvent.ALL_COLUMNS, TableModelEvent.UPDATE));
	}

	/**
	 * w肳ꂽJnsAIs͈̔(ǂ̒l܂)ōs폜ꂽƂAׂẴXi[ɒʒm܂B<br>
	 * @param firstRow ŏ̍s
	 * @param lastRow  Ō̍s
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableRowsDeleted(int firstRow, int lastRow) {
		fireTableChanged(new TableModelEvent(this, firstRow, lastRow, TableModelEvent.ALL_COLUMNS, TableModelEvent.DELETE));
	}

	/**
	 * w肳ꂽsʒuɂZ̒lXVꂽƂAׂẴXi[ɒʒm܂B<br>
	 * @param row XVꂽZ̍s
	 * @param column XVꂽZ̗
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableCellUpdated(int row, int column) {
		fireTableChanged(new TableModelEvent(this, row, row, column));
	}

	/**
	 * ̃e[uf̃Xi[Ƃēo^Ă邷ׂĂTableModelListenersɁAw肳ꂽʒmCxg]܂B<br>
	 * @param e ]Cxg
	 * @see #addTableModelListener(javax.swing.event.TableModelListener)
	 * @see javax.swing.event.TableModelEvent
	 * @see javax.swing.event.EventListenerList
	 */
	public void fireTableChanged(TableModelEvent e) {
		Object[] listeners = listenerList.getListenerList();
		for (int i = listeners.length - 2; i >= 0; i -= 2) {
			if (listeners[i] == TableModelListener.class) {
				((TableModelListener) listeners[i + 1]).tableChanged(e);
			}
		}
	}
}
