package org.phosphoresce.commons.database.accessor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.phosphoresce.commons.database.core.DatabaseError;
import org.phosphoresce.commons.database.exception.IllegalColumnValueException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.IllegalTemplateException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hf[^obt@OANZXNX<br>
 * <br>
 * NX{@link RecordAccessor}C^tF[X{IȃNXƂȂ܂B<br>
 * [U[̎wɂAɃtFb`ꂽR[hAႵ́Aws̃R[h
 * ΂ătFb`ꂽIuWFNgNXj܂ŕێ܂B<br>
 * <br>
 * ܂A{@link RecordAccessor}C^tF[XɂĒ񋟂ĂResultSetւ̍XVA
 * yсAQƏ́AtFb`ꂽobt@IuWFNg݂郌R[ĥ݂ΏۂƂȂA
 * tFb`̃R[hɑ΂Ă͏s܂B<br>
 * ́AׂĂ̍sɑ΂ĖɍXVAQƏsƂɂāAX|X̒ቺ
 * hƂl݌vƂȂĂ܂B<br>
 * [U[ׂẴR[hAႵ͓͈͂̃R[hꊇĎ擾ꍇ́A
 * tFb`[U[sKv܂B
 * ÃtFb`jɂẮANXł͌肹A[U[Ɉˑ܂B<br>
 * <br>
 * ȂAobt@Os߂̂قƂǂ̏finalŒ`AeTuNXł́A
 * ̃C^tF[XI[o[Ch邱Ƃ͋܂B<br>
 * ̓obt@Ô͓̏NXłׂĊǗAeTuNXł͂̏ɂ
 * OIȏ̍lsKvȂ߂̐݌vƂĂ邽߂łB<br>
 * ATuNXɂāȀɘACӂ̏sKv邱Ƃz肵A
 * sĂC^tF[X̏̃^C~OŃXi[ւ̒ʒms񋟂܂B<br>
 * eTuNXɂāȀɘACӂ̏ꍇ́AXi[ʒmꂽ
 * CxgɊÂāATuNXɓ邱ƂɂȂ܂B<br>
 * 
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/08/31	Kitagawa		VK쐬
 *-->
 */
public class RecordBufferedAccessor extends RecordAccessorAbstract {

	/** tFb`R[hobt@ */
	protected List fetchBuffer = null;

	/** tFb`ς݃JE^(TuNX񋟏) */
	private int fetchedCount = 0;

	// Constructor

	/**
	 * RXgN^<br>
	 * @param resultSet ResultSetIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 */
	public RecordBufferedAccessor(ResultSet resultSet) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		super(resultSet);
		this.fetchBuffer = new LinkedList();
		this.fetchedCount = 0;

		// ResultSetێs̃obt@TCY\ߊm
		for (int i = 0; i <= getResultRowCount() - 1; i++) {
			this.fetchBuffer.add(null);
		}
	}

	// Accessor Interface Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * ݁AύXsĂeׂ͂ĔjAResultSet̏ōXV܂B<br>
	 * @param force 󋵂Ɋւ炸IɍXVꍇtruewAG[̏ꍇɓ̏󋵂ɂĂ͍XVsȂꍇfalsewB
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessorAbstract#RecordAccessorAbstract(ResultSet)
	 */
	public final void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		rowDefinition.refreshResult(force);
		int currentRow = getResultSetRowIndex();
		List removeList = new LinkedList();
		int count = 0;
		for (Iterator iterator = fetchBuffer.iterator(); iterator.hasNext();) {
			ResultRow row = (ResultRow) iterator.next();
			if (row != null) {
				row.refreshResult(force);
				if (row.state == ResultAccessorState.INSERT || row.state == ResultAccessorState.INSERT_DELETE || (force && row.state == ResultAccessorState.INSERT_ERROR)) {
					removeList.add(row);
				}
				if (row.state != ResultAccessorState.REMOVED && row.state != ResultAccessorState.INSERT_ERROR) {
					row.state = ResultAccessorState.STATIC;
					for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; i++) {
						if (force) {
							row.getColumn(i).state = ResultAccessorState.STATIC;
						} else {
							if (row.getColumn(i).state != ResultAccessorState.UPDATE_ERROR && row.getColumn(i).state != ResultAccessorState.INSERT_ERROR) {
								row.getColumn(i).state = ResultAccessorState.STATIC;
							}
						}
					}
				}
			}
			count++;
		}
		fetchBuffer.removeAll(removeList);
		moveCurser(currentRow);
		if (validateStateListener()) {
			listener.bufferChanged();
		}
	}

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * ύXf邾ł͂ȂA폜A}ʃR[hɊւĂSĂResultSetɔf܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessorAbstract#updateResult
	 */
	public final void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		int currentRow = getResultSetRowIndex();
		List removeList = new LinkedList();
		int count = 0;
		for (Iterator iterator = fetchBuffer.iterator(); iterator.hasNext();) {
			ResultRow row = (ResultRow) iterator.next();
			if (row != null) {
				row.updateResult();
				if (row.state == ResultAccessorState.REMOVED || row.state == ResultAccessorState.INSERT_DELETE) {
					removeList.add(row);
					for (int i = count; i <= fetchBuffer.size() - 1; i++) {
						ResultRow suppliment = (ResultRow) fetchBuffer.get(i);
						if (suppliment != null) {
							if (suppliment.state != ResultAccessorState.REMOVED //
									&& suppliment.state != ResultAccessorState.INSERT //
									&& suppliment.state != ResultAccessorState.INSERT_DELETE) {
								suppliment.setIndex(suppliment.getIndex() - 1);
							}
						}
					}
				}
			}
			count++;
		}
		fetchBuffer.removeAll(removeList);
		if (validateStateListener()) {
			listener.bufferChanged();
		}
		moveCurser(currentRow);
	}

	// Public Final Method

	/**
	 * w肳ꂽsʒu̍sIuWFNgResultSet璼ڎ擾܂B<br>
	 * AAłɃtFb`ς݂̃IuWFNg݂ꍇ͂̃IuWFNgԋp܂B<br>
	 * @param rowIndex sʒu
	 * @return sIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃtFb`ςݍsw肵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultRow(int)
	 */
	public final ResultRow getResultRow(int rowIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException {
		try {
			if (rowIndex > fetchBuffer.size() - 1) {
				throw new IllegalResultSetLocationIndexException(rowIndex + " row is over result set row index range");
			} else if (rowIndex < 0) {
				throw new IllegalResultSetLocationIndexException(rowIndex + " row is negative index number");
			}
			if (fetchBuffer.get(rowIndex) == null) {
				int currentRow = resultSet.getRow();
				resultSet.absolute(rowIndex + 1);
				fetchBuffer.set(rowIndex, new ResultRow(resultSet, ResultAccessorState.STATIC, listener, rowDefinition, rowIndex));
				moveCurser(currentRow);
			}
			return (ResultRow) fetchBuffer.get(rowIndex);
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to analyze record data", e);
		}
	}

	/**
	 * w肳ꂽsJʒũJIuWFNgResultSet璼ڂ擾܂B<br>
	 * AAłɃtFb`ς݂̃IuWFNg݂ꍇ͂̃IuWFNgԋp܂B<br>
	 * @param rowIndex sʒu
	 * @param columnIndex Jʒu
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultColumn(int, int)
	 */
	public final ResultColumn getResultColumn(int rowIndex, int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException {
		try {
			int currentRow = resultSet.getRow();
			if (columnIndex > getResultColumnCount() - 1) {
				throw new IllegalResultSetLocationIndexException(columnIndex + " column is over result set column index range");
			} else if (columnIndex < 0) {
				throw new IllegalResultSetLocationIndexException(columnIndex + " column is negative index number");
			}
			return getResultRow(rowIndex).getColumn(columnIndex);
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to analyze record data", e);
		}
	}

	/**
	 * w肳ꂽev[gsɐVK̍stFb`obt@ɒǉ܂B<br>
	 * @param templateRow ev[gs
	 * @return VKǉs
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @throws IllegalResultTypeException sȃR[h^CṽR[hɑ΂ĕύXsꍇɔ
	 * @throws IllegalTemplateException ev[g񂪕ێ`񂪎g񋟂`ƈقȂsȒ`̏ꍇɔ
	 * @throws IllegalColumnValueException 
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#insertRow(org.phosphoresce.commons.database.accessor.ResultTemplateRow)
	 */
	public final ResultRow insertRow(ResultTemplateRow templateRow) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException,
			IllegalResultTypeException, IllegalTemplateException {
		ResultRow row = new ResultRow(resultSet, ResultAccessorState.INSERT, listener, rowDefinition, fetchBuffer.size());
		if (!row.getDefinition().equals(templateRow.getDefinition())) {
			throw new IllegalTemplateException("illegal different template information was specified");
		}
		for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; i++) {
			ResultTemplateColumn templateColumn = templateRow.getColumn(i);
			ResultColumn column = row.getColumn(i);
			if (!column.getDefinition().equals(templateColumn.getDefinition())) {
				throw new IllegalTemplateException("illegal different template information was specified");
			}
			column.setValue(templateColumn.getValue());
		}
		fetchBuffer.add(row);
		if (validateStateListener()) {
			listener.rowInserted(fetchBuffer.size() - 1, fetchBuffer.size() - 1);
		}
		return row;
	}

	/**
	 * VK̍s𐶐āAtFb`obt@ɒǉ܂B<br>
	 * ̏łResultSetւ̍s}͍sꂸA[U[updateResultsƂҋ@܂B<br>
	 * @return VKǉs
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#insertRow()
	 */
	public final ResultRow insertRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		ResultRow row = new ResultRow(resultSet, ResultAccessorState.INSERT, listener, rowDefinition, fetchBuffer.size());
		fetchBuffer.add(row);
		if (validateStateListener()) {
			listener.rowInserted(fetchBuffer.size() - 1, fetchBuffer.size() - 1);
		}
		return row;
	}

	/**
	 * w肳ꂽsɑ΂č폜ws܂B<br>
	 * ̏łResultSetւ̍s폜͍sꂸA[U[updateResultsƂҋ@܂B<br>
	 * @param rowIndex sʒu(0`)
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#deleteRow(int)
	 */
	public final void deleteRow(int rowIndex) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		ResultRow row = getResultRow(rowIndex);
		if (row.state == ResultAccessorState.DELETE || row.state == ResultAccessorState.INSERT_DELETE) {
			return;
		}
		if (row.state == ResultAccessorState.INSERT || row.state == ResultAccessorState.INSERT_ERROR) {
			row.state = ResultAccessorState.INSERT_DELETE;
		} else {
			row.state = ResultAccessorState.DELETE;
		}
		for (int i = 0; i <= row.getDefinition().getColumnCount() - 1; i++) {
			ResultColumn column = row.getColumn(i);
			if (column.state == ResultAccessorState.INSERT) {
				column.state = ResultAccessorState.INSERT_DELETE;
			} else {
				column.state = ResultAccessorState.DELETE;
			}
		}
		if (validateStateListener()) {
			listener.rowUpdated(rowIndex, rowIndex);
		}
	}

	// Public Final Method (Fetching)

	/**
	 * w肳ꂽTCỸR[htFb`s܂B<br>
	 * ResultSetIuWFNg݂̃J[\ʒuȏ̏Ȃꍇ͏͒f܂B<br>
	 * @param size tFb`TCY
	 * @return ̏ŃtFb`R[h̃Xg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public final List fetch(int size) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		try {
			int currentRow = resultSet.getRow();
			if (fetchedCount <= 0) {
				resultSet.beforeFirst();
			} else {
				resultSet.absolute(fetchedCount);
			}
			int bufferedCount = fetchBuffer.size();
			int count = 0;
			List buffer = new LinkedList();
			while (resultSet.next()) {
				if (fetchBuffer.get(fetchedCount + count) == null) {
					fetchBuffer.add(new ResultRow(resultSet, ResultAccessorState.STATIC, listener, rowDefinition, fetchedCount++));
				}
				buffer.add(fetchBuffer.get(fetchedCount + count));
				count++;
				if (count >= size) {
					break;
				}
			}
			if (validateStateListener()) {
				listener.rowUpdated(bufferedCount - 1, bufferedCount - 1 + count);
			}
			moveCurser(currentRow);
			return buffer;
		} catch (SQLException e) {
			throw new ResultSetAccessException("failed to analyze record data", e);
		}
	}

	/**
	 * ݂̃J[\ʒuŌ܂ł̃R[hׂătFb`܂B<br>
	 * @return ̏ŃtFb`R[h̃Xg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public final List fetchRemainAll() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		return fetch(getResultRowCount() - fetchedCount);
	}

	/**
	 * ResultSetێ邷ׂẴR[h擾܂B<br>
	 * tFb`̂fetchRemainAllƓl̓s܂Aԋp郊Xg͐擪ׂ̂ẴR[hƂȂ܂B<br>
	 * A݁Agێ郌R[hXgɑ΂āA}̎wsĂꍇ͂̍s͊܂܂ꂸA
	 * g̕ێ郌R[hXgeƂ͈قȂ郊Xgԋp邱ƂɂȂ܂B<br>O
	 * @return ̏ŃtFb`R[h̃Xg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public final List fetchAll() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException {
		fetchedCount = 0;
		return fetchRemainAll();
	}

	// Public Final Method (Error Manage)

	/**
	 * ANZbTIuWFNgێsŃG[ĂsIuWFNg擾܂B<br>
	 * @return ANZbTIuWFNgێsŃG[ĂsIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 */
	public final DatabaseError[] getErrors() throws IllegalResultSetLocationIndexException {
		List errors = new LinkedList();
		List rowErrors = new LinkedList();
		List columnErrors = new LinkedList();
		for (Iterator iterator = fetchBuffer.iterator(); iterator.hasNext();) {
			ResultRow row = (ResultRow) iterator.next();
			if (row != null) {
				if (row.hasError()) {
					rowErrors.add(row.getError());
				}
				for (int i = 0; i <= rowDefinition.getColumnCount() - 1; i++) {
					if (row.getColumn(i).hasError()) {
						columnErrors.add(row.getColumn(i).getError());
					}
				}
			}
		}
		errors.addAll(rowErrors);
		errors.addAll(columnErrors);
		return (DatabaseError[]) errors.toArray(new DatabaseError[errors.size()]);
	}

	/**
	 * ANZbTIuWFNgێsŃG[Ă邩肵܂B<br>
	 * @return ANZbTIuWFNgێsŃG[Ăꍇtrueԋp
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 */
	public final boolean hasError() throws IllegalResultSetLocationIndexException {
		for (Iterator iterator = fetchBuffer.iterator(); iterator.hasNext();) {
			ResultRow row = (ResultRow) iterator.next();
			if (row != null) {
				if (row.hasError()) {
					return true;
				}
				for (int i = 0; i <= rowDefinition.getColumnCount() - 1; i++) {
					if (row.getColumn(i).hasError()) {
						return true;
					}
				}
			}
		}
		return false;
	}

	// Protected Method

	/**
	 * w肳ꂽsJʒũJIuWFNgResultSet璼ڂ擾܂B<br>
	 * AAłɃtFb`ς݂̃IuWFNg݂ꍇ͂̃IuWFNgԋp܂B<br>
	 * R[hANZX݌vɖ𔭐\ׁApublicȑ͎܂B<br>
	 * NXpNXɂĂgp邱Ƃ͋܂AwJւ
	 * QƃIuWFNgSɒuƂƂɒӂĉB<br>
	 * @param rowIndex sʒu
	 * @param columnIndex Jʒu
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @see org.phosphoresce.commons.database.accessor.RecordAccessor#getResultColumn(int, int)
	 */
	protected final void setResultColumn(int rowIndex, int columnIndex, ResultColumn column) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException {
		getResultRow(rowIndex).setColumn(columnIndex, column);
	}

	// Override Method

	/**
	 * IuWFNg̎QƂȂAKx[WRN^ɂăIuWFNgsvƂĔjۂɌĂяo܂B<br>
	 * @throws Throwable \ʗOꍇɃX[܂
	 * @see java.lang.Object#finalize()
	 */
	protected final void finalize() throws Throwable {
		super.finalize();
		if (resultSet.getStatement().getConnection() != null && !resultSet.getStatement().getConnection().isClosed()) {
			resultSet.getStatement().getConnection().rollback();
			resultSet.getStatement().getConnection().close();
		}
	}

	/**
	 * NX𕶎ƂĒ񋟂܂B<br>
	 * @return NX񕶎
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("{");
		buffer.append("fetchedCount=");
		buffer.append(fetchedCount);
		buffer.append(",");
		buffer.append("rowDefinition=");
		buffer.append(rowDefinition);
		buffer.append("}");
		return buffer.toString();
	}
}
