package org.phosphoresce.commons.database.accessor;

import org.phosphoresce.commons.database.exception.DatabaseConnectionException;
import org.phosphoresce.commons.database.exception.IllegalResultSetAdjustmentException;
import org.phosphoresce.commons.database.exception.IllegalResultSetLocationIndexException;
import org.phosphoresce.commons.database.exception.IllegalResultTypeException;
import org.phosphoresce.commons.database.exception.IllegalTemplateException;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;

/**
 * R[hANZXNXC^tF[X<br>
 * <br>
 * e탌R[hANZXNX͒ړIResultSetւ̎QƁAXVs܂B<br>
 * ̓R[ḧꊇIȃR~bgA[obN邽߂̐݌vŁAeTuNX
 * ̃R[hXV^C~OOƂsKv܂B<br>
 * ResultSetւ̍XVA܂͎QƂs^C~O͏ʃ[U[NX̎wɈˑ܂B<br>
 * <br>
 * 
 * @see RecordAccessorAbstract
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/09/05	Kitagawa		VK쐬
 *-->
 */
public interface RecordAccessor {

	// ResultSet Syncronize Method

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * @param force 󋵂Ɋւ炸IɍXVꍇtruewAG[̏ꍇɓ̏󋵂ɂĂ͍XVsȂꍇfalsewB̓͋ۃNX݌vɂĈقȂ܂B
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public void refreshResult(boolean force) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	/**
	 * ResultSetݒ񋟂eŎg̃IuWFNgtB[h̍XVs܂B<br>
	 * \bhōsXV{@link #refreshResult(boolean)}falsew肵ɈϏ܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public void refreshResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	/**
	 * gێeResultSetɑ΂Ĕf܂B<br>
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public void updateResult() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	// Result Access Method

	/**
	 * ResultSet̏ɂ`ێev[gsIuWFNg𐶐܂B<br>
	 * @return ev[gsIuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultTemplateRow createTemplateRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	/**
	 * ResultSetێ郌R[h擾܂B<br>
	 * @return ResultSetێ郌R[h
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public int getResultRowCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException;

	/**
	 * R[hJ擾܂B<br>
	 * @return R[hJ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public int getResultColumnCount() throws ResultSetAccessException, IllegalResultSetAdjustmentException;

	/**
	 * s`IuWFNg擾܂B<br>
	 * @return s`IuWFNg
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultRowDefinition getResultRowDefinition() throws ResultSetAccessException, IllegalResultSetAdjustmentException;

	/**
	 * w肳ꂽJCfbNX̃J`擾܂B<br>
	 * @param columnIndex JCfbNX
	 * @return J`
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultColumnDefinition getResultColumnDefinition(int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException;

	/**
	 * w肳ꂽJ̃J`擾܂B<br>
	 * @param columnName J
	 * @return J`
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultColumnDefinition getResultColumnDefinition(String columnName) throws IllegalResultSetLocationIndexException, ResultSetAccessException,
			IllegalResultSetAdjustmentException;

	// Buffering Peculiar Method

	/**
	 * w肳ꂽsʒu̍sIuWFNgResultSet璼ڎ擾܂B<br>
	 * ͊eTuNXɂ铮ɈˑC^tF[XƂȂ܂B<br>
	 * obt@OsNXł͂̓obt@ꂽIuWFNgԋp\܂B<br>
	 * @param rowIndex sʒu
	 * @return sIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȃtFb`ςݍsw肵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultRow getResultRow(int rowIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException;

	/**
	 * w肳ꂽsJʒũJIuWFNgResultSet璼ڂ擾܂B<br>
	 * ͊eTuNXɂ铮ɈˑC^tF[XƂȂ܂B<br>
	 * obt@OsNXł͂̓obt@ꂽIuWFNgԋp\܂B<br>
	 * @param rowIndex sʒu
	 * @param columnIndex Jʒu
	 * @return JIuWFNg
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultColumn getResultColumn(int rowIndex, int columnIndex) throws IllegalResultSetLocationIndexException, ResultSetAccessException, IllegalResultSetAdjustmentException;

	/**
	 * w肳ꂽev[gsɐVK̍sǉ܂B<br>
	 * ͊eTuNXɂ铮ɈˑC^tF[XƂȂ܂B<br>
	 * @param templateRow ev[gs
	 * @return VKǉs
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 * @throws IllegalResultTypeException sȃR[h^CṽR[hɑ΂ĕύXsꍇɔ
	 * @throws IllegalTemplateException ev[g񂪕ێ`񂪎g񋟂`ƈقȂsȒ`̏ꍇɔ
	 */
	public ResultRow insertRow(ResultTemplateRow templateRow) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException,
			IllegalResultTypeException, IllegalTemplateException;

	/**
	 * VK̍s𐶐Ēǉ܂B<br>
	 * ͊eTuNXɂ铮ɈˑC^tF[XƂȂ܂B<br>
	 * @return VKǉs
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public ResultRow insertRow() throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	/**
	 * w肳ꂽsɑ΂č폜ws܂B<br>
	 * ͊eTuNXɂ铮ɈˑC^tF[XƂȂ܂B<br>
	 * @param rowIndex sʒu(0`)
	 * @throws ResultSetAccessException ResultSetւ̑삪sȂꍇɔ
	 * @throws IllegalResultSetLocationIndexException sȈʒu𑀍삵ꍇɔ
	 * @throws IllegalResultSetAdjustmentException ResultSetƂ̐ĂȂꍇɔ
	 */
	public void deleteRow(int rowIndex) throws ResultSetAccessException, IllegalResultSetLocationIndexException, IllegalResultSetAdjustmentException;

	// Transaction Method

	/**
	 * R[hANZXIuWFNgێ񂪓ǂݎpł邩肵܂B<br>
	 * @return R[hANZXIuWFNgێ񂪓ǂݎpłꍇtrueԋp
	 * @throws DatabaseConnectionException Ƀf[^x[XRlNVɃANZXłȂꍇɔ
	 */
	public boolean isReadOnly() throws DatabaseConnectionException;
}
