/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.database.container;

import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.database.container.DatabaseCatalog;
import org.phosphoresce.commons.database.container.DatabaseCatalogHolder;
import org.phosphoresce.commons.database.container.DatabaseSchema;
import org.phosphoresce.commons.database.container.DatabaseSchemaHolder;
import org.phosphoresce.commons.database.container.DatabaseTable;
import org.phosphoresce.commons.database.container.DatabaseTableHolder;
import org.phosphoresce.commons.database.core.DatabaseSession;
import org.phosphoresce.commons.database.exception.ResultSetAccessException;
import org.phosphoresce.commons.database.util.DatabaseStringUtil;
import org.phosphoresce.commons.database.util.ResultSetUtil;

public final class DatabaseContainer
implements Serializable,
DatabaseCatalogHolder,
DatabaseSchemaHolder,
DatabaseTableHolder {
    private List catalogList = new LinkedList();
    private List schemaList = new LinkedList();
    private List tableList = new LinkedList();

    protected DatabaseContainer() {
    }

    public String getName() {
        return null;
    }

    public Iterator getCatalogListIterator() {
        return this.catalogList.iterator();
    }

    public int getCatalogListCount() {
        return this.catalogList.size();
    }

    public DatabaseCatalog getCatalog(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.catalogList.iterator();
        while (iterator.hasNext()) {
            DatabaseCatalog catalog = (DatabaseCatalog)iterator.next();
            if (!key.equals(catalog.getName())) continue;
            return catalog;
        }
        return null;
    }

    public Iterator getSchemaListIterator() {
        return this.schemaList.iterator();
    }

    public int getSchemaListCount() {
        return this.schemaList.size();
    }

    public DatabaseSchema getSchema(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.schemaList.iterator();
        while (iterator.hasNext()) {
            DatabaseSchema schema = (DatabaseSchema)iterator.next();
            if (!key.equals(schema.getName())) continue;
            return schema;
        }
        return null;
    }

    public Iterator getTableListIterator() {
        return this.tableList.iterator();
    }

    public int getTableListCount() {
        return this.tableList.size();
    }

    public DatabaseTable getTable(String name) {
        String key = name == null ? "" : name;
        Iterator iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            DatabaseTable table = (DatabaseTable)iterator.next();
            if (!key.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    protected void addCatalog(DatabaseCatalog catalog) {
        this.catalogList.add(catalog);
    }

    protected void addSchema(DatabaseSchema schema) {
        this.schemaList.add(schema);
    }

    protected void addTable(DatabaseTable table) {
        this.tableList.add(table);
    }

    public static DatabaseContainer createDatabaseContainer(DatabaseSession session) throws ResultSetAccessException {
        DatabaseContainer container = new DatabaseContainer();
        try {
            DatabaseMetaData databaseMetaData = session.getConnection().getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String catalogName = null;
                String schemaName = null;
                String tableName = null;
                if (ResultSetUtil.containsColumn(resultSet, "TABLE_CAT")) {
                    catalogName = resultSet.getString("TABLE_CAT");
                }
                if (ResultSetUtil.containsColumn(resultSet, "TABLE_SCHEM")) {
                    schemaName = resultSet.getString("TABLE_SCHEM");
                }
                if (ResultSetUtil.containsColumn(resultSet, "TABLE_NAME")) {
                    tableName = resultSet.getString("TABLE_NAME");
                }
                if (!DatabaseStringUtil.isEmpty(catalogName)) {
                    if (container.getCatalog(catalogName) == null) {
                        container.addCatalog(new DatabaseCatalog(catalogName));
                        container.getCatalog(catalogName).setCatalogHolder(container);
                    }
                    DatabaseCatalog catalog = container.getCatalog(catalogName);
                    if (!DatabaseStringUtil.isEmpty(schemaName)) {
                        if (catalog.getSchema(schemaName) == null) {
                            catalog.addSchema(new DatabaseSchema(schemaName));
                            catalog.getSchema(schemaName).setSchemaHolder(catalog);
                        }
                        DatabaseSchema schema = catalog.getSchema(schemaName);
                        if (DatabaseStringUtil.isEmpty(tableName) || schema.getTable(tableName) != null) continue;
                        schema.addTable(new DatabaseTable(tableName));
                        schema.getTable(tableName).setTableHolder(schema);
                        continue;
                    }
                    if (DatabaseStringUtil.isEmpty(tableName) || catalog.getTable(tableName) != null) continue;
                    catalog.addTable(new DatabaseTable(tableName));
                    catalog.getTable(tableName).setTableHolder(catalog);
                    continue;
                }
                if (!DatabaseStringUtil.isEmpty(schemaName)) {
                    if (container.getSchema(schemaName) == null) {
                        container.addSchema(new DatabaseSchema(schemaName));
                        container.getSchema(schemaName).setSchemaHolder(container);
                    }
                    DatabaseSchema schema = container.getSchema(schemaName);
                    if (DatabaseStringUtil.isEmpty(tableName) || schema.getTable(tableName) != null) continue;
                    schema.addTable(new DatabaseTable(tableName));
                    schema.getTable(tableName).setTableHolder(schema);
                    continue;
                }
                if (DatabaseStringUtil.isEmpty(tableName) || container.getTable(tableName) != null) continue;
                container.addTable(new DatabaseTable(tableName));
                container.getTable(tableName).setTableHolder(container);
            }
            return container;
        }
        catch (Throwable e) {
            throw new ResultSetAccessException("failed to analyze database meta data.", e);
        }
    }
}

