package org.phosphoresce.commons.mail.mail;

import java.io.IOException;
import java.io.Serializable;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Message.RecipientType;

/**
 * sȊe탁[ANZXC^tF[XbsO
 * e탁\bh񋟂郆[eBeBNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/03/01	Kitagawa		VK쐬
 *-->
 */
public final class MailSafeAccesserUtil implements Serializable {

	/**
	 * RXgN^<br>
	 */
	private MailSafeAccesserUtil() {
		super();
	}

	/**
	 * w肳ꂽPartIuWFNgContent-Type擾܂B<br>
	 * PartIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param part PartIuWFNg
	 * @return PartIuWFNgContent-Type
	 */
	public static String getContentType(Part part) {
		try {
			return part == null ? "" : part.getContentType();
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * w肳ꂽMessageIuWFNǧ擾܂B<br>
	 * MessageIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param message MessageIuWFNg
	 * @return MessageIuWFNǧ
	 */
	public static String getSubject(Message message) {
		try {
			return message == null ? "" : message.getSubject();
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * w肳ꂽMessageIuWFNg̑M擾܂B<br>
	 * MessageIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param message MessageIuWFNg
	 * @return MessageIuWFNg̑M
	 */
	public static Address[] getForm(Message message) {
		try {
			return message == null ? new Address[] {} : message.getFrom();
		} catch (MessagingException e) {
			return new Address[] {};
		}
	}

	/**
	 * w肳ꂽMessageIuWFNg̕ԐM擾܂B<br>
	 * MessageIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param message MessageIuWFNg
	 * @return MessageIuWFNg̕ԐM
	 */
	public static Address[] getReplyTo(Message message) {
		try {
			return message == null ? new Address[] {} : message.getReplyTo();
		} catch (MessagingException e) {
			return new Address[] {};
		}
	}

	/**
	 * w肳ꂽMessageIuWFNg̑M擾܂B<br>
	 * MessageIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param message MessageIuWFNg
	 * @return MessageIuWFNg̑M
	 */
	public static Address[] getRecipients(Message message, RecipientType type) {
		try {
			return message == null ? new Address[] {} : message.getRecipients(type);
		} catch (MessagingException e) {
			return new Address[] {};
		}
	}

	/**
	 * w肳ꂽPartIuWFNg̃Rec擾܂B<br>
	 * PartIuWFNg̃ANZbTOX[ꂽꍇ͋IuWFNgԋp܂B<br>
	 * @param part PartIuWFNg
	 * @return PartIuWFNg̃Rec
	 */
	public static String getContent(Part part) {
		try {
			return part.getContent().toString();
		} catch (IOException e) {
			return "";
		} catch (MessagingException e) {
			return "";
		}
	}
}
