package org.phosphoresce.commons.mail;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

import org.phosphoresce.commons.mail.exception.MailException;
import org.phosphoresce.commons.mail.exception.MailIOException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.mail.exception.MailResourceException;
import org.phosphoresce.commons.mail.mail.MailSafeAccesserUtil;
import org.phosphoresce.commons.mail.mail.MailUtil;
import org.phosphoresce.commons.util.StringUtil;

/**
 * [RecێNX<br>
 * NX͑MAM͕ێ܂B<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/02/24	Kitagawa		VK쐬
 *-->
 */
public final class MailContent implements MailDeclareInterface {

	/** [\ */
	private String subject = "";

	/** [\LN^[Zbg */
	private String subjectCharset = DEFAULT_MIME_CHARSET;

	/** [e */
	private String content = "";

	/** [eLN^[Zbg */
	private String contentCharset = DEFAULT_MIME_CHARSET;

	/** HTML[tO */
	private boolean isHTML;

	/** [Ytt@CXg */
	private List attachList = new LinkedList();

	/** [Ytt@CLN^[Zbg */
	private String attachNameCharset = DEFAULT_MIME_CHARSET;

	/**
	 * RXgN^<br>
	 */
	public MailContent() {
		super();
	}

	/**
	 * w肳ꂽMessageIuWFNgMailContentIuWFNg𐶐܂B<br>
	 * @param message MessageIuWFNg
	 * @return MailContentIuWFNg
	 * @throws MailMessageException w肳ꂽMessageIuWFNg琳ɃRec擾邱ƂoȂꍇɔ
	 */
	static MailContent createMailContent(Message message) throws MailMessageException {
		try {
			MailContent content = new MailContent();
			content.subject = MailSafeAccesserUtil.getSubject(message);
			content.subjectCharset = MailUtil.getCharset(message);
			content.render(message);
			return content;
		} catch (Exception e) {
			throw new MailMessageException("MessageIuWFNg琳ɃRec擾邱Ƃo܂ł", e);
		}
	}

	/**
	 * w肳ꂽPartIuWFNgg̃RecIuWFNgɑ΂Ĕf܂B<br>
	 * @param part PartIuWFNg
	 * @throws MailMessageException PartIuWFNg̓e͂sȂꍇɔ
	 */
	private void render(Part part) throws MailMessageException {
		try {
			if (part.isMimeType("multipart/*")) {
				// }`p[gRec
				Multipart multi = (Multipart) part.getContent();
				for (int i = 0; i <= multi.getCount() - 1; i++) {
					render(multi.getBodyPart(i));
				}
			} else if (part.isMimeType("message/rfc822")) {
				// bZ[WRec
				render((Part) part.getContent());
			} else if (part.isMimeType("text/plain")) {
				// v[eLXgRec
				if (MailUtil.hasContentType(part, "name")) {
					attachList.add(new MailAttachResource(part));
				} else {
					content = MailSafeAccesserUtil.getContent(part);
					contentCharset = MailUtil.getCharset(part);
				}
			} else if (part.isMimeType("text/html")) {
				// HTMLeLXgRec
				if (MailUtil.hasContentType(part, "name")) {
					attachList.add(new MailAttachResource(part));
				} else {
					content = MailSafeAccesserUtil.getContent(part);
					contentCharset = MailUtil.getCharset(part);
					isHTML = true;
				}
			} else {
				// ̑̃Rec͑SēYtƂď
				attachList.add(new MailAttachResource(part));
			}
		} catch (Exception e) {
			throw new MailMessageException("[Rec͎̉ɗ\ʗO܂", e);
		}
	}

	/**
	 * NXێ񂩂}`p[g[RecIuWFNg𐶐܂B<br>
	 * @return }`p[g[RecIuWFNg
	 * @throws MailMessageException Ƀ}`p[gIuWFNg̐sȂꍇɔ
	 */
	Multipart createMultipart() throws MailMessageException {
		try {
			// }`p[gIuWFNg
			MimeMultipart multipart = new MimeMultipart();

			/*
			 * v[Recǉ
			 */
			if (!StringUtil.isEmpty(content) && !isHTML) {
				MimeBodyPart part = new MimeBodyPart();
				part.setText(content, contentCharset);
				multipart.addBodyPart(part);
			}

			/*
			 * HTMLRecǉ
			 */
			if (!StringUtil.isEmpty(content) && isHTML) {
				MimeBodyPart part = new MimeBodyPart();
				part.setContent(content, "text/html; charset=" + contentCharset);
				multipart.addBodyPart(part);
			}

			/*
			 * Ytt@Cǉ
			 */
			if (attachList != null) {
				for (Iterator iterator = attachList.iterator(); iterator.hasNext();) {
					MailAttachResource resource = (MailAttachResource) iterator.next();
					if (resource.isIncome()) {
						throw new MailException("MpYt\[XIuWFNg𑗐MpƂēYt悤Ƃ܂");
					}
					DataHandler handler = new DataHandler(new FileDataSource(resource.getFile()));
					MimeBodyPart part = new MimeBodyPart();
					part.setDataHandler(handler);
					part.setFileName(MimeUtility.encodeText(resource.getName(), attachNameCharset, null));
					multipart.addBodyPart(part);
				}
			}

			return multipart;
		} catch (Exception e) {
			throw new MailMessageException("[Recɗ\ʗO܂", e);
		}
	}

	/**
	 * Ytt@C\[Xǉ܂B<br>
	 * @param file Ytt@C 
	 * @throws MailResourceException ɓYtt@C̒ǉsȂꍇɔ
	 */
	public void addAttachResource(File file) throws MailResourceException {
		attachList.add(new MailAttachResource(file));
	}

	/**
	 * Ytt@C\[XIuWFNg擾܂B<br>
	 * @return Ytt@C\[XIuWFNg
	 */
	public MailAttachResource[] getAttachResources() {
		return (MailAttachResource[]) attachList.toArray(new MailAttachResource[attachList.size()]);
	}

	/**
	 * w肳ꂽ\[X̓Ytt@C擾܂B<br>
	 * @param name \[X
	 * @return Ytt@C\[XIuWFNg
	 */
	public MailAttachResource getAttachResource(String name) {
		for (Iterator iterator = attachList.iterator(); iterator.hasNext();) {
			MailAttachResource resource = (MailAttachResource) iterator.next();
			if (name.equals(resource.getName())) {
				return resource;
			}
		}
		return null;
	}

	/**
	 * Ytt@CJ}؂Ŏ擾܂B<br>
	 * @return J}؂̓Ytt@C
	 */
	public String getAttachResourceNames() {
		StringBuffer buffer = new StringBuffer();
		MailAttachResource[] resources = getAttachResources();
		for (int i = 0; i <= resources.length - 1; i++) {
			MailAttachResource resource = resources[i];
			buffer.append(resource.getName());
			if (i < resources.length - 1) {
				buffer.append(", ");
			}
		}
		return buffer.toString();
	}

	/**
	 * w肳ꂽfBNgFileIuWFNgɑ΂ēYtt@CSĕۑ܂B<br>
	 * @param file ۑfBNgFileIuWFNg
	 * @throws MailResourceException fBNgł͂ȂFileIuWFNgw肵ꍇɔ
	 * @throws MailIOException Ytt@C̏o͎ɓo͗OX[ꂽꍇɔ
	 */
	public void saveAttachResources(File file) throws MailResourceException, MailIOException {
		if (!file.isDirectory()) {
			throw new MailResourceException("fBNgł͂ȂFileIuWFNgɓYtt@Co͂悤Ƃ܂");
		}
		MailAttachResource[] resources = getAttachResources();
		for (int i = 0; i <= resources.length - 1; i++) {
			resources[i].save(file);
		}
	}

	/**
	 * HTML[tO擾܂B<br>
	 * @return HTML[tO
	 */
	public boolean isHTML() {
		return this.isHTML;
	}

	/**
	 * HTML[tOݒ肵܂B<br>
	 * @param isHTML HTML[tO
	 */
	public void setHTML(boolean isHTML) {
		this.isHTML = isHTML;
	}

	/**
	 * [\擾܂B<br>
	 * @return [\
	 */
	public String getSubject() {
		return this.subject;
	}

	/**
	 * [\ݒ肵܂B<br>
	 * @param subject [\
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

	/**
	 * [\LN^[Zbg擾܂B<br>
	 * @return [\LN^[Zbg
	 */
	public String getSubjectCharset() {
		return this.subjectCharset;
	}

	/**
	 * [\LN^[Zbgݒ肵܂B<br>
	 * @param subjectCharset [\LN^[Zbg
	 */
	public void setSubjectCharset(String subjectCharset) {
		this.subjectCharset = subjectCharset;
	}

	/**
	 * [e擾܂B<br>
	 * @return [e
	 */
	public String getContent() {
		return this.content;
	}

	/**
	 * [eݒ肵܂B<br>
	 * @param content [e
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * [eLN^[Zbg擾܂B<br>
	 * @return [eLN^[Zbg
	 */
	public String getContentCharset() {
		return this.contentCharset;
	}

	/**
	 * [eLN^[Zbgݒ肵܂B<br>
	 * @param contentCharset [eLN^[Zbg
	 */
	public void setContentCharset(String contentCharset) {
		this.contentCharset = contentCharset;
	}

	/**
	 * [Ytt@CLN^[Zbg擾܂B<br>
	 * @return [Ytt@CLN^[Zbg
	 */
	public String getAttachNameCharset() {
		return this.attachNameCharset;
	}

	/**
	 * [Ytt@CLN^[Zbgݒ肵܂B<br>
	 * @param attachNameCharset [Ytt@CLN^[Zbg
	 */
	public void setAttachNameCharset(String attachNameCharset) {
		this.attachNameCharset = attachNameCharset;
	}
}
