/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.mail.mail;

import java.io.Serializable;
import javax.mail.Address;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.phosphoresce.commons.mail.MailDeclareInterface;
import org.phosphoresce.commons.mail.exception.MailAddressException;
import org.phosphoresce.commons.mail.exception.MailMessageException;
import org.phosphoresce.commons.mail.mail.MailSafeAccesserUtil;
import org.phosphoresce.commons.util.StringUtil;

public final class MailUtil
implements Serializable,
MailDeclareInterface {
    private MailUtil() {
    }

    public static String createMailAddressValue(Address[] addresses) throws MailAddressException {
        try {
            String value = InternetAddress.toString((Address[])addresses);
            value = StringUtil.replace((String)value, (String)"\"", (String)"");
            value = value == null ? "" : MimeUtility.decodeText((String)value);
            value = StringUtil.replace((String)value, (String)"\r", (String)"");
            value = StringUtil.replace((String)value, (String)"\t", (String)"");
            value = StringUtil.replace((String)value, (String)"\n", (String)"");
            return value;
        }
        catch (Exception e) {
            throw new MailAddressException("\u30a2\u30c9\u30ec\u30b9\u306e\u53d6\u5f97\u51e6\u7406\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public static String createMailAddressValue(Address addresse) throws MailAddressException {
        try {
            return MailUtil.createMailAddressValue(new Address[]{addresse});
        }
        catch (Exception e) {
            throw new MailAddressException("\u30a2\u30c9\u30ec\u30b9\u306e\u53d6\u5f97\u51e6\u7406\u6642\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }

    public static String createMailAddressValue(String mailaddress, String name) throws MailAddressException {
        return MailUtil.createMailAddressValue(MailUtil.createMailAddress(mailaddress, name));
    }

    public static String createMailAddressValue(String mailaddress, String name, String charset) throws MailAddressException {
        return MailUtil.createMailAddressValue(MailUtil.createMailAddress(mailaddress, name, charset));
    }

    public static String createMailAddressValue(String mailaddress) throws MailAddressException {
        return MailUtil.createMailAddressValue(MailUtil.createMailAddress(mailaddress));
    }

    public static Address createMailAddress(String mailaddress, String name, String charset) throws MailAddressException {
        try {
            return new InternetAddress(mailaddress, name, charset);
        }
        catch (Exception e) {
            throw new MailAddressException("\u6b63\u5e38\u306b\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u751f\u6210\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    public static Address createMailAddress(String mailaddress, String name) throws MailAddressException {
        return MailUtil.createMailAddress(mailaddress, name, "iso-2022-jp");
    }

    public static Address createMailAddress(String mailaddress) throws MailAddressException {
        return MailUtil.createMailAddress(mailaddress, null, "iso-2022-jp");
    }

    public static String getContentType(Part part, String parameter) throws MailMessageException {
        try {
            String name;
            ContentType contentType = new ContentType(MailSafeAccesserUtil.getContentType(part));
            StringBuffer buffer = new StringBuffer();
            if (contentType.getParameter(parameter) != null) {
                buffer.append(StringUtil.replace((String)contentType.getParameter(parameter), (String)"\"", (String)""));
            }
            if (contentType.getParameter(parameter + "*") != null) {
                buffer.append(StringUtil.replace((String)contentType.getParameter(parameter + "*"), (String)"\"", (String)""));
            }
            if (contentType.getParameter(parameter + "**") != null) {
                buffer.append(StringUtil.replace((String)contentType.getParameter(parameter + "**"), (String)"\"", (String)""));
            }
            for (int i = 0; i <= Integer.MAX_VALUE && (name = contentType.getParameter(parameter + "*" + i + "*")) != null; ++i) {
                buffer.append(name);
            }
            return MimeUtility.decodeText((String)buffer.toString());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean hasContentType(Part part, String parameter) throws MailMessageException {
        return !StringUtil.isEmpty((String)MailUtil.getContentType(part, parameter));
    }

    public static String getCharset(Part part) throws MailMessageException {
        return MailUtil.getContentType(part, "charset");
    }
}

