package org.phosphoresce.commons.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/**
 * Zipt@C샆[eBeBNXB<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2007/01/16	Kitagawa		VK쐬
 * 2007/05/24	Kitagawa		Zipt@C𓀃C^tF[X̒ǉ
 *-->
 */
public final class ZipUtil {

	/** o̓oCg */
	public static int BYTE_LENGTH = 1024;

	/** fBtHgLN^Zbg */
	public static final String DEFAULT_CHARSET = "MS932";

	/** ReiGg}bvL[ */
	private static final String KEY_ENTRY_NAME = ZipContainer.class.getName() + ".KEY_ENTRY_NAME";

	/** Reit@C}bvL[ */
	private static final String KEY_ENTRY_FILE = ZipContainer.class.getName() + ".KEY_ENTRY_FILE";

	/**
	 * Zipt@C쐬̃\[XێNX<br>
	 * 
	 * @author Kitagawa<br>
	 * 
	 *<!--
	 * XV		XV			XVe
	 * 2007/01/16	Kitagawa		VK쐬
	 *-->
	 */
	public static final class ZipContainer {

		/** Zipt@CGgXg */
		private List list = new LinkedList();

		/**
		 * RXgN^<br>
		 */
		public ZipContainer() {
			//
		}

		/**
		 * w肳ꂽGgt@CŃt@Cǉ܂B<br>
		 * @param name Ggt@C
		 * @param file t@C
		 */
		public void add(String name, File file) {
			Map map = new HashMap();
			map.put(KEY_ENTRY_NAME, name);
			map.put(KEY_ENTRY_FILE, file);
			list.add(map);
		}

		/**
		 * ێĂ񃊃XgIteratorIuWFNg擾܂B<br>
		 * @return ێĂ񃊃XgIteratorIuWFNg
		 */
		private Iterator iterator() {
			return list.iterator();
		}
	}

	/**
	 * RXgN^<br>
	 */
	private ZipUtil() {
		super();
	}

	/**
	 * w肳ꂽt@Cɑ΂ZipContainerIuWFNg̓eGgZipt@C𐶐B<br>
	 * @param file 쐬ΏZipt@CIuWFNg
	 * @param container GgeێIuWFNg
	 * @throws IOException Zipt@C쐬sȂꍇɔ
	 */
	public static void create(File file, ZipContainer container) throws IOException {
		create(file, container, DEFAULT_CHARSET);
	}

	/**
	 * w肳ꂽt@Cɑ΂ZipContainerIuWFNg̓eGgZipt@C𐶐B<br>
	 * @param file 쐬ΏZipt@CIuWFNg
	 * @param container GgeێIuWFNg
	 * @param charset Ggt@C̃LN^Zbg(ZipApacheUtil.javaƂ̌݊APIŎۂ͓Ɋ֌W܂)
	 * @throws IOException Zipt@C쐬sȂꍇɔ
	 */
	public static void create(File file, ZipContainer container, String charset) throws IOException {
		ZipOutputStream os = new ZipOutputStream(new FileOutputStream(file));

		for (Iterator iterator = container.iterator(); iterator.hasNext();) {
			Map map = (Map) iterator.next();
			String name = (String) map.get(KEY_ENTRY_NAME);
			File resource = (File) map.get(KEY_ENTRY_FILE);

			ZipEntry entry = new ZipEntry(name);
			os.putNextEntry(entry);

			int count;
			byte[] bytes = new byte[BYTE_LENGTH];

			BufferedInputStream is = new BufferedInputStream(new FileInputStream(resource));
			while ((count = is.read(bytes, 0, BYTE_LENGTH)) != -1) {
				os.write(bytes, 0, count);
			}
			is.close();
			os.closeEntry();
		}

		os.close();
	}

	/**
	 * w肳ꂽZipt@Cw肳ꂽfBNgɑ΂ĉ𓀂܂B<br>
	 * @param file Zipt@C
	 * @param directory 𓀐fBNg
	 * @throws IOException Zipt@C̉𓀂sȂꍇɔ
	 */
	public static void unzip(File file, File directory) throws IOException {
		String target = directory == null ? "" : //
				directory.getAbsolutePath().endsWith(File.separator) ? directory.getAbsolutePath() : directory.getAbsolutePath() + File.separator;
		ZipFile zipFile = new ZipFile(file);
		Enumeration enumeration = zipFile.entries();
		while (enumeration.hasMoreElements()) {
			ZipEntry entry = (ZipEntry) enumeration.nextElement();
			if (entry.isDirectory()) {
				new File(target + entry.getName()).mkdirs();
			} else {
				File parent = new File(target + entry.getName()).getParentFile();
				parent.mkdirs();
				FileOutputStream out = new FileOutputStream(target + entry.getName());
				InputStream in = zipFile.getInputStream(entry);
				byte[] buf = new byte[1024];
				int size = 0;
				while ((size = in.read(buf)) != -1) {
					out.write(buf, 0, size);
				}
				out.close();
			}
		}
	}

	/**
	 * w肳ꂽZipt@CJgfBNgɑ΂ĉ𓀂܂B<br>
	 * @param file Zipt@C
	 * @throws IOException Zipt@C̉𓀂sȂꍇɔ
	 */
	public static void unzip(File file) throws IOException {
		unzip(file, null);
	}
}
