/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.utils.RolloverMenuItemListener;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceRadioButtonMenuItemUI
extends BasicRadioButtonMenuItemUI
implements SubstanceMenu,
Trackable {
    protected RolloverMenuItemListener substanceRolloverListener;
    protected FadeStateListener substanceFadeStateListener;
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(0.4f);
    protected PropertyChangeListener substancePropertyListener;
    protected static Graphics graphics;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;

    public static ComponentUI createUI(JComponent b) {
        JRadioButtonMenuItem item = (JRadioButtonMenuItem)b;
        item.setRolloverEnabled(true);
        return new SubstanceRadioButtonMenuItemUI();
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceRolloverListener = new RolloverMenuItemListener(this.menuItem);
        this.menuItem.addMouseListener(this.substanceRolloverListener);
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceRadioButtonMenuItemUI.this.substanceFadeStateListener != null) {
                        SubstanceRadioButtonMenuItemUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceRadioButtonMenuItemUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceRadioButtonMenuItemUI.this.menuItem, SubstanceRadioButtonMenuItemUI.this.menuItem.getModel(), null);
                    SubstanceRadioButtonMenuItemUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        backgroundDelegate.paintBackground(g, menuItem, bgColor, true, textOffset);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        MenuUtilities.lineupTextRectangle(g, menuItem, textRect, this.defaultTextIconGap);
        super.paintText(g, menuItem, textRect, text);
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return this.checkIcon;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        SubstanceRadioButtonMenuItemUI ui = (SubstanceRadioButtonMenuItemUI)this.menuItem.getUI();
        int textOffset = MenuUtilities.getTextOffset(graphics, this.menuItem) - MenuUtilities.getTextOffset(graphics, this.menuItem, ui.getAcceleratorFont(), checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(superDim.width + textOffset, superDim.height);
    }

    public boolean isInside(MouseEvent me) {
        return this.menuItem.getBounds().contains(me.getX(), me.getY());
    }

    static {
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        graphics = dummy.getGraphics();
    }
}

