/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener substanceLabelMouseInputListener;
    private int width;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceCoreUtilities.getActiveScheme(this.desktopIcon.getInternalFrame()).getExtraLightColor());
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.frame.setOpaque(false);
        this.iconPane = new SubstanceInternalFrameTitlePane(this.frame, false);
        this.iconPane.setOpaque(false);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstall();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceLabelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.addMouseListener(this.substanceLabelMouseInputListener);
    }

    protected void uninstallListeners() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstallListeners();
        this.iconPane.removeMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.removeMouseListener(this.substanceLabelMouseInputListener);
        this.substanceLabelMouseInputListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        SubstanceInternalFrameTitlePane thePane = (SubstanceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(c);
        thePane.uninstallListeners();
    }

    public JComponent getComponentForHover() {
        return this.iconPane;
    }
}

