// 
// Hiero
// Copyright (c) 2015  Barry Block 
// 
// This program is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version. 
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License for more details. 
// 
// You should have received a copy of the GNU General Public License along with
// this program.  If not, see <http://www.gnu.org/licenses/>. 
//

using System;
using Gtk;

namespace Hiero
{
   // Type denoting whether a cut or copy operation is being performed.
   public enum CutCopyType { CUT, COPY, NONE, };

   // Implements a rudimentary, internal-use clipboard.
   public class Clipboard
   {
      internal CutCopyType operation { get; set; }
         // Denotes the type of operation being performed.
      internal Document srcDoc { get; set; }
         // The source outline document.
      internal TreeIter srcNode { get; set; }
         // The source node.
      internal string contents { get; set; }
         // The contents of the clipboard.
      
      public Clipboard()
      {
         operation = CutCopyType.NONE;
         contents = string.Empty;
      }
   }
}

