// 
// Hiero
// Copyright (c) 2015  Barry Block 
// 
// This program is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version. 
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License for more details. 
// 
// You should have received a copy of the GNU General Public License along with
// this program.  If not, see <http://www.gnu.org/licenses/>. 
//

using System;
using Gtk;

namespace Hiero
{
   public class PreferenceDialog : Gtk.Dialog
   {
      private FontButton TextEditorFontButton;
      private ColorButton TextEditorHighlightColorButton;
      private Entry TextEditorDialogWidthEntry;
      private Entry TextEditorDialogHeightEntry;
      private CheckButton HintsEnabledCheckBox;
      private CheckButton LoggingEnabledCheckBox;
      private CheckButton RaiseEditorOnAddNodeCheckBox;

      public PreferenceDialog(Gtk.Window parent) : base("Preferences", parent, DialogFlags.Modal | DialogFlags.DestroyWithParent,
      Gtk.Stock.Cancel, ResponseType.Cancel, Gtk.Stock.Ok, ResponseType.Ok)
      {
         this.Resizable = false;
         VBox vBox1 = new Gtk.VBox();

         HBox hBox3 = new Gtk.HBox();
         Label label1 = new Gtk.Label();
         label1.LabelProp = "General";
         hBox3.PackStart(label1, false, false, 0);
         vBox1.Add(hBox3);


         HBox hBox2 = new Gtk.HBox();
         Label label4 = new Gtk.Label();
         label4.LabelProp = "\tEnable user interface hints:";
         hBox2.PackStart(label4, false, false, 0);

         HintsEnabledCheckBox = new Gtk.CheckButton();
         hBox2.PackStart(HintsEnabledCheckBox, false, false, 0);

         hBox2.Spacing = 6;
         vBox1.Add(hBox2);


         HBox hBox7 = new Gtk.HBox();
         Label label5 = new Gtk.Label();
         label5.LabelProp = "\tEnable logging:";
         hBox7.PackStart(label5, false, false, 0); 

         LoggingEnabledCheckBox = new Gtk.CheckButton();
         hBox7.PackStart(LoggingEnabledCheckBox, false, false, 0); 

         hBox7.Spacing = 6; 
         vBox1.Add(hBox7); 


         HBox hBox8 = new Gtk.HBox();
         Label label2 = new Gtk.Label();
         label2.LabelProp = "Text Editor";
         hBox8.PackStart(label2, false, false, 0);
         vBox1.Add(hBox8);


         HBox hBox1 = new Gtk.HBox();
         Label label3 = new Gtk.Label();
         label3.LabelProp = "\tRaise editor on add node:";
         hBox1.PackStart(label3, false, false, 0);

         RaiseEditorOnAddNodeCheckBox = new Gtk.CheckButton();
         hBox1.PackStart(RaiseEditorOnAddNodeCheckBox, false, false, 0);

         hBox1.Spacing = 6;
         vBox1.Add(hBox1);


         HBox hBox4 = new Gtk.HBox();
         Label label6 = new Gtk.Label();
         label6.LabelProp = "\tFont:";
         hBox4.PackStart(label6, false, false, 0);

         TextEditorFontButton = new Gtk.FontButton();
         hBox4.PackStart(TextEditorFontButton, false, false, 0);

         hBox4.Spacing = 6;
         vBox1.Add(hBox4);


         HBox hBox9 = new Gtk.HBox(); 
         Label label9 = new Gtk.Label();
         label9.LabelProp = "\tHighlight Color:";
         hBox9.PackStart(label9, false, false, 0);

         TextEditorHighlightColorButton = new Gtk.ColorButton();
         TextEditorHighlightColorButton.Color = new Gdk.Color(255, 255, 0);
         hBox9.PackStart(TextEditorHighlightColorButton, false, false, 0);

         hBox9.Spacing = 6;
         vBox1.Add(hBox9);


         HBox hBox5 = new Gtk.HBox();
         Label label7 = new Gtk.Label();
         label7.LabelProp = "\tDialog Width:";
         hBox5.PackStart(label7, false, false, 0);

         TextEditorDialogWidthEntry = new Gtk.Entry();
         TextEditorDialogWidthEntry.Text = string.Empty;
         hBox5.PackStart(TextEditorDialogWidthEntry, false, false, 0);

         hBox5.Spacing = 6;
         vBox1.Add(hBox5);


         HBox hBox6 = new Gtk.HBox();
         Label label8 = new Gtk.Label();
         label8.LabelProp = "\tDialog Height:";
         hBox6.PackStart(label8, false, false, 0);

         TextEditorDialogHeightEntry = new Gtk.Entry();
         TextEditorDialogHeightEntry.Text = string.Empty;
         hBox6.PackStart(TextEditorDialogHeightEntry, false, false, 0);

         hBox6.Spacing = 6;
         vBox1.Add(hBox6);


         vBox1.Spacing = 6;

         this.VBox.Add(vBox1);
         this.ShowAll();
      }

      public bool HintsEnabled
      {
         get { return HintsEnabledCheckBox.Active; }
         set { HintsEnabledCheckBox.Active = value; }
      }

      public bool LoggingEnabled
      {
         get { return LoggingEnabledCheckBox.Active; }
         set { LoggingEnabledCheckBox.Active = value; }
      }

      public bool RaiseEditorOnAddNode
      {
         get { return RaiseEditorOnAddNodeCheckBox.Active; }
         set { RaiseEditorOnAddNodeCheckBox.Active = value; }
      }

      public string TextEditorFont
      {
         get { return TextEditorFontButton.FontName; }
         set { TextEditorFontButton.FontName = value; }
      }

      public Gdk.Color TextEditorHighlightColor
      {
         get { return TextEditorHighlightColorButton.Color; }
         set { TextEditorHighlightColorButton.Color = value; }
      }

      public int TextEditorDialogWidth
      {
         get { return Convert.ToInt32(TextEditorDialogWidthEntry.Text); }
         set { TextEditorDialogWidthEntry.Text = value.ToString(); }
      }

      public int TextEditorDialogHeight
      {
         get { return Convert.ToInt32(TextEditorDialogHeightEntry.Text); }
         set { TextEditorDialogHeightEntry.Text = value.ToString(); }
      }
   }
}