/**********************************************************************************************************************
 *                                                                                                                    *
 *  T I M E  Z O N E . H                                                                                              *
 *  ====================                                                                                              *
 *                                                                                                                    *
 *  This is free software; you can redistribute it and/or modify it under the terms of the GNU General Public         *
 *  License version 2 as published by the Free Software Foundation.  Note that I am not granting permission to        *
 *  redistribute or modify this under the terms of any later version of the General Public License.                   *
 *                                                                                                                    *
 *  This is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied        *
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more     *
 *  details.                                                                                                          *
 *                                                                                                                    *
 *  You should have received a copy of the GNU General Public License along with this program (in the file            *
 *  "COPYING"); if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111,   *
 *  USA.                                                                                                              *
 *                                                                                                                    *
 **********************************************************************************************************************/
/**
 *  \file
 *  \brief Functions for parsing timezone information.
 */
#ifndef FIRST_CITY
#define FIRST_CITY 28
#define GMT_ZERO 13
#endif

#ifdef TIMEZONE_TABLE

	{ "Local/Time", 0 },
	{ "GMT/GMT - 12", 1 },
	{ "GMT/GMT - 11", 2 },
	{ "GMT/GMT - 10", 3 },
	{ "GMT/GMT - 9", 4 },
	{ "GMT/GMT - 8", 5 },
	{ "GMT/GMT - 7", 6 },
	{ "GMT/GMT - 6", 7 },
	{ "GMT/GMT - 5", 8 },
	{ "GMT/GMT - 4", 9 },
	{ "GMT/GMT - 3", 10 },
	{ "GMT/GMT - 2", 11 },
	{ "GMT/GMT - 1", 12 },
	{ "GMT/GMT", 13 },
	{ "GMT/GMT + 1", 14 },
	{ "GMT/GMT + 2", 15 },
	{ "GMT/GMT + 3", 16 },
	{ "GMT/GMT + 4", 17 },
	{ "GMT/GMT + 5", 18 },
	{ "GMT/GMT + 6", 19 },
	{ "GMT/GMT + 7", 20 },
	{ "GMT/GMT + 8", 21 },
	{ "GMT/GMT + 9", 22 },
	{ "GMT/GMT + 10", 23 },
	{ "GMT/GMT + 11", 24 },
	{ "GMT/GMT + 12", 25 },
	{ "GMT/GMT + 13", 26 },
	{ "GMT/GMT + 14", 27 },
	{ "Africa/Abidjan", 28 },
	{ "Africa/Accra", 29 },
	{ "Africa/Addis_Ababa", 30 },
	{ "Africa/Algiers", 31 },
	{ "Africa/Asmara", 32 },
	{ "Africa/Bamako", 33 },
	{ "Africa/Bangui", 34 },
	{ "Africa/Banjul", 35 },
	{ "Africa/Bissau", 36 },
	{ "Africa/Blantyre", 37 },
	{ "Africa/Brazzaville", 38 },
	{ "Africa/Bujumbura", 39 },
	{ "Africa/Cairo", 40 },
	{ "Africa/Casablanca", 41 },
	{ "Africa/Ceuta", 42 },
	{ "Africa/Conakry", 43 },
	{ "Africa/Dakar", 44 },
	{ "Africa/Dar_es_Salaam", 45 },
	{ "Africa/Djibouti", 46 },
	{ "Africa/Douala", 47 },
	{ "Africa/El_Aaiun", 48 },
	{ "Africa/Freetown", 49 },
	{ "Africa/Gaborone", 50 },
	{ "Africa/Harare", 51 },
	{ "Africa/Johannesburg", 52 },
	{ "Africa/Kampala", 53 },
	{ "Africa/Khartoum", 54 },
	{ "Africa/Kigali", 55 },
	{ "Africa/Kinshasa", 56 },
	{ "Africa/Lagos", 57 },
	{ "Africa/Libreville", 58 },
	{ "Africa/Lome", 59 },
	{ "Africa/Luanda", 60 },
	{ "Africa/Lubumbashi", 61 },
	{ "Africa/Lusaka", 62 },
	{ "Africa/Malabo", 63 },
	{ "Africa/Maputo", 64 },
	{ "Africa/Maseru", 65 },
	{ "Africa/Mbabane", 66 },
	{ "Africa/Mogadishu", 67 },
	{ "Africa/Monrovia", 68 },
	{ "Africa/Nairobi", 69 },
	{ "Africa/Ndjamena", 70 },
	{ "Africa/Niamey", 71 },
	{ "Africa/Nouakchott", 72 },
	{ "Africa/Ouagadougou", 73 },
	{ "Africa/Porto-Novo", 74 },
	{ "Africa/Sao_Tome", 75 },
	{ "Africa/Tripoli", 76 },
	{ "Africa/Tunis", 77 },
	{ "Africa/Windhoek", 78 },
	{ "America/Argentina/Buenos_Aires", 79 },
	{ "America/Argentina/Catamarca", 80 },
	{ "America/Argentina/Cordoba", 81 },
	{ "America/Argentina/Jujuy", 82 },
	{ "America/Argentina/La_Rioja", 83 },
	{ "America/Argentina/Mendoza", 84 },
	{ "America/Argentina/Rio_Gallegos", 85 },
	{ "America/Argentina/San_Juan", 86 },
	{ "America/Argentina/San_Luis", 87 },
	{ "America/Argentina/Tucuman", 88 },
	{ "America/Argentina/Ushuaia", 89 },
	{ "America/Indiana/Indianapolis", 90 },
	{ "America/Indiana/Knox", 91 },
	{ "America/Indiana/Marengo", 92 },
	{ "America/Indiana/Petersburg", 93 },
	{ "America/Indiana/Tell_City", 94 },
	{ "America/Indiana/Vevay", 95 },
	{ "America/Indiana/Vincennes", 96 },
	{ "America/Indiana/Winamac", 97 },
	{ "America/Kentucky/Louisville", 98 },
	{ "America/Kentucky/Monticello", 99 },
	{ "America/North_Dakota/Center", 100 },
	{ "America/North_Dakota/New_Salem", 101 },
	{ "America/Adak", 102 },
	{ "America/Anchorage", 103 },
	{ "America/Anguilla", 104 },
	{ "America/Antigua", 105 },
	{ "America/Araguaina", 106 },
	{ "America/Aruba", 107 },
	{ "America/Asuncion", 108 },
	{ "America/Atikokan", 109 },
	{ "America/Bahia", 110 },
	{ "America/Barbados", 111 },
	{ "America/Belem", 112 },
	{ "America/Belize", 113 },
	{ "America/Blanc-Sablon", 114 },
	{ "America/Boa_Vista", 115 },
	{ "America/Bogota", 116 },
	{ "America/Boise", 117 },
	{ "America/Cambridge_Bay", 118 },
	{ "America/Campo_Grande", 119 },
	{ "America/Cancun", 120 },
	{ "America/Caracas", 121 },
	{ "America/Cayenne", 122 },
	{ "America/Cayman", 123 },
	{ "America/Chicago", 124 },
	{ "America/Chihuahua", 125 },
	{ "America/Costa_Rica", 126 },
	{ "America/Cuiaba", 127 },
	{ "America/Curacao", 128 },
	{ "America/Danmarkshavn", 129 },
	{ "America/Dawson", 130 },
	{ "America/Dawson_Creek", 131 },
	{ "America/Denver", 132 },
	{ "America/Detroit", 133 },
	{ "America/Dominica", 134 },
	{ "America/Edmonton", 135 },
	{ "America/Eirunepe", 136 },
	{ "America/El_Salvador", 137 },
	{ "America/Fortaleza", 138 },
	{ "America/Glace_Bay", 139 },
	{ "America/Godthab", 140 },
	{ "America/Goose_Bay", 141 },
	{ "America/Grand_Turk", 142 },
	{ "America/Grenada", 143 },
	{ "America/Guadeloupe", 144 },
	{ "America/Guatemala", 145 },
	{ "America/Guayaquil", 146 },
	{ "America/Guyana", 147 },
	{ "America/Halifax", 148 },
	{ "America/Havana", 149 },
	{ "America/Hermosillo", 150 },
	{ "America/Inuvik", 151 },
	{ "America/Iqaluit", 152 },
	{ "America/Jamaica", 153 },
	{ "America/Juneau", 154 },
	{ "America/La_Paz", 155 },
	{ "America/Lima", 156 },
	{ "America/Los_Angeles", 157 },
	{ "America/Maceio", 158 },
	{ "America/Managua", 159 },
	{ "America/Manaus", 160 },
	{ "America/Marigot", 161 },
	{ "America/Martinique", 162 },
	{ "America/Mazatlan", 163 },
	{ "America/Menominee", 164 },
	{ "America/Merida", 165 },
	{ "America/Mexico_City", 166 },
	{ "America/Miquelon", 167 },
	{ "America/Moncton", 168 },
	{ "America/Monterrey", 169 },
	{ "America/Montevideo", 170 },
	{ "America/Montreal", 171 },
	{ "America/Montserrat", 172 },
	{ "America/Nassau", 173 },
	{ "America/New_York", 174 },
	{ "America/Nipigon", 175 },
	{ "America/Nome", 176 },
	{ "America/Noronha", 177 },
	{ "America/Panama", 178 },
	{ "America/Pangnirtung", 179 },
	{ "America/Paramaribo", 180 },
	{ "America/Phoenix", 181 },
	{ "America/Port-au-Prince", 182 },
	{ "America/Port_of_Spain", 183 },
	{ "America/Porto_Velho", 184 },
	{ "America/Puerto_Rico", 185 },
	{ "America/Rainy_River", 186 },
	{ "America/Rankin_Inlet", 187 },
	{ "America/Recife", 188 },
	{ "America/Regina", 189 },
	{ "America/Resolute", 190 },
	{ "America/Rio_Branco", 191 },
	{ "America/Santiago", 192 },
	{ "America/Santo_Domingo", 193 },
	{ "America/Sao_Paulo", 194 },
	{ "America/Scoresbysund", 195 },
	{ "America/Shiprock", 196 },
	{ "America/St_Barthelemy", 197 },
	{ "America/St_Johns", 198 },
	{ "America/St_Kitts", 199 },
	{ "America/St_Lucia", 200 },
	{ "America/St_Thomas", 201 },
	{ "America/St_Vincent", 202 },
	{ "America/Swift_Current", 203 },
	{ "America/Tegucigalpa", 204 },
	{ "America/Thule", 205 },
	{ "America/Thunder_Bay", 206 },
	{ "America/Tijuana", 207 },
	{ "America/Toronto", 208 },
	{ "America/Tortola", 209 },
	{ "America/Vancouver", 210 },
	{ "America/Whitehorse", 211 },
	{ "America/Winnipeg", 212 },
	{ "America/Yakutat", 213 },
	{ "America/Yellowknife", 214 },
	{ "Antarctica/Casey", 215 },
	{ "Antarctica/Davis", 216 },
	{ "Antarctica/DumontDUrville", 217 },
	{ "Antarctica/Mawson", 218 },
	{ "Antarctica/McMurdo", 219 },
	{ "Antarctica/Palmer", 220 },
	{ "Antarctica/Rothera", 221 },
	{ "Antarctica/South_Pole", 222 },
	{ "Antarctica/Syowa", 223 },
	{ "Antarctica/Vostok", 224 },
	{ "Arctic/Longyearbyen", 225 },
	{ "Asia/Aden", 226 },
	{ "Asia/Almaty", 227 },
	{ "Asia/Amman", 228 },
	{ "Asia/Anadyr", 229 },
	{ "Asia/Aqtau", 230 },
	{ "Asia/Aqtobe", 231 },
	{ "Asia/Ashgabat", 232 },
	{ "Asia/Baghdad", 233 },
	{ "Asia/Bahrain", 234 },
	{ "Asia/Baku", 235 },
	{ "Asia/Bangkok", 236 },
	{ "Asia/Beirut", 237 },
	{ "Asia/Bishkek", 238 },
	{ "Asia/Brunei", 239 },
	{ "Asia/Choibalsan", 240 },
	{ "Asia/Chongqing", 241 },
	{ "Asia/Colombo", 242 },
	{ "Asia/Damascus", 243 },
	{ "Asia/Dhaka", 244 },
	{ "Asia/Dili", 245 },
	{ "Asia/Dubai", 246 },
	{ "Asia/Dushanbe", 247 },
	{ "Asia/Gaza", 248 },
	{ "Asia/Harbin", 249 },
	{ "Asia/Ho_Chi_Minh", 250 },
	{ "Asia/Hong_Kong", 251 },
	{ "Asia/Hovd", 252 },
	{ "Asia/Irkutsk", 253 },
	{ "Asia/Jakarta", 254 },
	{ "Asia/Jayapura", 255 },
	{ "Asia/Jerusalem", 256 },
	{ "Asia/Kabul", 257 },
	{ "Asia/Kamchatka", 258 },
	{ "Asia/Karachi", 259 },
	{ "Asia/Kashgar", 260 },
	{ "Asia/Katmandu", 261 },
	{ "Asia/Kolkata", 262 },
	{ "Asia/Krasnoyarsk", 263 },
	{ "Asia/Kuala_Lumpur", 264 },
	{ "Asia/Kuching", 265 },
	{ "Asia/Kuwait", 266 },
	{ "Asia/Macau", 267 },
	{ "Asia/Magadan", 268 },
	{ "Asia/Makassar", 269 },
	{ "Asia/Manila", 270 },
	{ "Asia/Muscat", 271 },
	{ "Asia/Nicosia", 272 },
	{ "Asia/Novosibirsk", 273 },
	{ "Asia/Omsk", 274 },
	{ "Asia/Oral", 275 },
	{ "Asia/Phnom_Penh", 276 },
	{ "Asia/Pontianak", 277 },
	{ "Asia/Pyongyang", 278 },
	{ "Asia/Qatar", 279 },
	{ "Asia/Qyzylorda", 280 },
	{ "Asia/Rangoon", 281 },
	{ "Asia/Riyadh", 282 },
	{ "Asia/Sakhalin", 283 },
	{ "Asia/Samarkand", 284 },
	{ "Asia/Seoul", 285 },
	{ "Asia/Shanghai", 286 },
	{ "Asia/Singapore", 287 },
	{ "Asia/Taipei", 288 },
	{ "Asia/Tashkent", 289 },
	{ "Asia/Tbilisi", 290 },
	{ "Asia/Tehran", 291 },
	{ "Asia/Thimphu", 292 },
	{ "Asia/Tokyo", 293 },
	{ "Asia/Ulaanbaatar", 294 },
	{ "Asia/Urumqi", 295 },
	{ "Asia/Vientiane", 296 },
	{ "Asia/Vladivostok", 297 },
	{ "Asia/Yakutsk", 298 },
	{ "Asia/Yekaterinburg", 299 },
	{ "Asia/Yerevan", 300 },
	{ "Atlantic/Azores", 301 },
	{ "Atlantic/Bermuda", 302 },
	{ "Atlantic/Canary", 303 },
	{ "Atlantic/Cape_Verde", 304 },
	{ "Atlantic/Faroe", 305 },
	{ "Atlantic/Madeira", 306 },
	{ "Atlantic/Reykjavik", 307 },
	{ "Atlantic/South_Georgia", 308 },
	{ "Atlantic/St_Helena", 309 },
	{ "Atlantic/Stanley", 310 },
	{ "Australia/Adelaide", 311 },
	{ "Australia/Brisbane", 312 },
	{ "Australia/Broken_Hill", 313 },
	{ "Australia/Currie", 314 },
	{ "Australia/Darwin", 315 },
	{ "Australia/Eucla", 316 },
	{ "Australia/Hobart", 317 },
	{ "Australia/Lindeman", 318 },
	{ "Australia/Lord_Howe", 319 },
	{ "Australia/Melbourne", 320 },
	{ "Australia/Perth", 321 },
	{ "Australia/Sydney", 322 },
	{ "Europe/Amsterdam", 323 },
	{ "Europe/Andorra", 324 },
	{ "Europe/Athens", 325 },
	{ "Europe/Belgrade", 326 },
	{ "Europe/Berlin", 327 },
	{ "Europe/Bratislava", 328 },
	{ "Europe/Brussels", 329 },
	{ "Europe/Bucharest", 330 },
	{ "Europe/Budapest", 331 },
	{ "Europe/Chisinau", 332 },
	{ "Europe/Copenhagen", 333 },
	{ "Europe/Dublin", 334 },
	{ "Europe/Gibraltar", 335 },
	{ "Europe/Guernsey", 336 },
	{ "Europe/Helsinki", 337 },
	{ "Europe/Isle_of_Man", 338 },
	{ "Europe/Istanbul", 339 },
	{ "Europe/Jersey", 340 },
	{ "Europe/Kaliningrad", 341 },
	{ "Europe/Kiev", 342 },
	{ "Europe/Lisbon", 343 },
	{ "Europe/Ljubljana", 344 },
	{ "Europe/London", 345 },
	{ "Europe/Luxembourg", 346 },
	{ "Europe/Madrid", 347 },
	{ "Europe/Malta", 348 },
	{ "Europe/Mariehamn", 349 },
	{ "Europe/Minsk", 350 },
	{ "Europe/Monaco", 351 },
	{ "Europe/Moscow", 352 },
	{ "Europe/Oslo", 353 },
	{ "Europe/Paris", 354 },
	{ "Europe/Podgorica", 355 },
	{ "Europe/Prague", 356 },
	{ "Europe/Riga", 357 },
	{ "Europe/Rome", 358 },
	{ "Europe/Samara", 359 },
	{ "Europe/San_Marino", 360 },
	{ "Europe/Sarajevo", 361 },
	{ "Europe/Simferopol", 362 },
	{ "Europe/Skopje", 363 },
	{ "Europe/Sofia", 364 },
	{ "Europe/Stockholm", 365 },
	{ "Europe/Tallinn", 366 },
	{ "Europe/Tirane", 367 },
	{ "Europe/Uzhgorod", 368 },
	{ "Europe/Vaduz", 369 },
	{ "Europe/Vatican", 370 },
	{ "Europe/Vienna", 371 },
	{ "Europe/Vilnius", 372 },
	{ "Europe/Volgograd", 373 },
	{ "Europe/Warsaw", 374 },
	{ "Europe/Zagreb", 375 },
	{ "Europe/Zaporozhye", 376 },
	{ "Europe/Zurich", 377 },
	{ "Indian/Antananarivo", 378 },
	{ "Indian/Chagos", 379 },
	{ "Indian/Christmas", 380 },
	{ "Indian/Cocos", 381 },
	{ "Indian/Comoro", 382 },
	{ "Indian/Kerguelen", 383 },
	{ "Indian/Mahe", 384 },
	{ "Indian/Maldives", 385 },
	{ "Indian/Mauritius", 386 },
	{ "Indian/Mayotte", 387 },
	{ "Indian/Reunion", 388 },
	{ "Pacific/Apia", 389 },
	{ "Pacific/Auckland", 390 },
	{ "Pacific/Chatham", 391 },
	{ "Pacific/Easter", 392 },
	{ "Pacific/Efate", 393 },
	{ "Pacific/Enderbury", 394 },
	{ "Pacific/Fakaofo", 395 },
	{ "Pacific/Fiji", 396 },
	{ "Pacific/Funafuti", 397 },
	{ "Pacific/Galapagos", 398 },
	{ "Pacific/Gambier", 399 },
	{ "Pacific/Guadalcanal", 400 },
	{ "Pacific/Guam", 401 },
	{ "Pacific/Honolulu", 402 },
	{ "Pacific/Johnston", 403 },
	{ "Pacific/Kiritimati", 404 },
	{ "Pacific/Kosrae", 405 },
	{ "Pacific/Kwajalein", 406 },
	{ "Pacific/Majuro", 407 },
	{ "Pacific/Marquesas", 408 },
	{ "Pacific/Midway", 409 },
	{ "Pacific/Nauru", 410 },
	{ "Pacific/Niue", 411 },
	{ "Pacific/Norfolk", 412 },
	{ "Pacific/Noumea", 413 },
	{ "Pacific/Pago_Pago", 414 },
	{ "Pacific/Palau", 415 },
	{ "Pacific/Pitcairn", 416 },
	{ "Pacific/Ponape", 417 },
	{ "Pacific/Port_Moresby", 418 },
	{ "Pacific/Rarotonga", 419 },
	{ "Pacific/Saipan", 420 },
	{ "Pacific/Tahiti", 421 },
	{ "Pacific/Tarawa", 422 },
	{ "Pacific/Tongatapu", 423 },
	{ "Pacific/Truk", 424 },
	{ "Pacific/Wake", 425 },
	{ "Pacific/Wallis", 426 },

#endif

#ifdef TIMEZONE_MENU

	{ "/Timezone/Local Ti_me", NULL, setTimeZoneCallback, 0, "<Item>" },
	{ "/Timezone/_Greenwich Mean Time", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 12", NULL, setTimeZoneCallback, 1, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 11", NULL, setTimeZoneCallback, 2, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 10", NULL, setTimeZoneCallback, 3, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 9", NULL, setTimeZoneCallback, 4, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 8", NULL, setTimeZoneCallback, 5, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 7", NULL, setTimeZoneCallback, 6, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 6", NULL, setTimeZoneCallback, 7, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 5", NULL, setTimeZoneCallback, 8, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 4", NULL, setTimeZoneCallback, 9, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 3", NULL, setTimeZoneCallback, 10, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 2", NULL, setTimeZoneCallback, 11, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT - 1", NULL, setTimeZoneCallback, 12, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT", NULL, setTimeZoneCallback, 13, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 1", NULL, setTimeZoneCallback, 14, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 2", NULL, setTimeZoneCallback, 15, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 3", NULL, setTimeZoneCallback, 16, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 4", NULL, setTimeZoneCallback, 17, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 5", NULL, setTimeZoneCallback, 18, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 6", NULL, setTimeZoneCallback, 19, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 7", NULL, setTimeZoneCallback, 20, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 8", NULL, setTimeZoneCallback, 21, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 9", NULL, setTimeZoneCallback, 22, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 10", NULL, setTimeZoneCallback, 23, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 11", NULL, setTimeZoneCallback, 24, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 12", NULL, setTimeZoneCallback, 25, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 13", NULL, setTimeZoneCallback, 26, "<Item>" },
	{ "/Timezone/Greenwich Mean Time/GMT + 14", NULL, setTimeZoneCallback, 27, "<Item>" },
	{ "/Timezone/SEP2", NULL, NULL, 0, "<Separator>" },
	{ "/Timezone/Africa", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Africa/Abidjan", NULL, setTimeZoneCallback, 28, "<Item>" },
	{ "/Timezone/Africa/Accra", NULL, setTimeZoneCallback, 29, "<Item>" },
	{ "/Timezone/Africa/Addis Ababa", NULL, setTimeZoneCallback, 30, "<Item>" },
	{ "/Timezone/Africa/Algiers", NULL, setTimeZoneCallback, 31, "<Item>" },
	{ "/Timezone/Africa/Asmara", NULL, setTimeZoneCallback, 32, "<Item>" },
	{ "/Timezone/Africa/Bamako", NULL, setTimeZoneCallback, 33, "<Item>" },
	{ "/Timezone/Africa/Bangui", NULL, setTimeZoneCallback, 34, "<Item>" },
	{ "/Timezone/Africa/Banjul", NULL, setTimeZoneCallback, 35, "<Item>" },
	{ "/Timezone/Africa/Bissau", NULL, setTimeZoneCallback, 36, "<Item>" },
	{ "/Timezone/Africa/Blantyre", NULL, setTimeZoneCallback, 37, "<Item>" },
	{ "/Timezone/Africa/Brazzaville", NULL, setTimeZoneCallback, 38, "<Item>" },
	{ "/Timezone/Africa/Bujumbura", NULL, setTimeZoneCallback, 39, "<Item>" },
	{ "/Timezone/Africa/Cairo", NULL, setTimeZoneCallback, 40, "<Item>" },
	{ "/Timezone/Africa/Casablanca", NULL, setTimeZoneCallback, 41, "<Item>" },
	{ "/Timezone/Africa/Ceuta", NULL, setTimeZoneCallback, 42, "<Item>" },
	{ "/Timezone/Africa/Conakry", NULL, setTimeZoneCallback, 43, "<Item>" },
	{ "/Timezone/Africa/Dakar", NULL, setTimeZoneCallback, 44, "<Item>" },
	{ "/Timezone/Africa/Dar es Salaam", NULL, setTimeZoneCallback, 45, "<Item>" },
	{ "/Timezone/Africa/Djibouti", NULL, setTimeZoneCallback, 46, "<Item>" },
	{ "/Timezone/Africa/Douala", NULL, setTimeZoneCallback, 47, "<Item>" },
	{ "/Timezone/Africa/El Aaiun", NULL, setTimeZoneCallback, 48, "<Item>" },
	{ "/Timezone/Africa/Freetown", NULL, setTimeZoneCallback, 49, "<Item>" },
	{ "/Timezone/Africa/Gaborone", NULL, setTimeZoneCallback, 50, "<Item>" },
	{ "/Timezone/Africa/Harare", NULL, setTimeZoneCallback, 51, "<Item>" },
	{ "/Timezone/Africa/Johannesburg", NULL, setTimeZoneCallback, 52, "<Item>" },
	{ "/Timezone/Africa/Kampala", NULL, setTimeZoneCallback, 53, "<Item>" },
	{ "/Timezone/Africa/Khartoum", NULL, setTimeZoneCallback, 54, "<Item>" },
	{ "/Timezone/Africa/Kigali", NULL, setTimeZoneCallback, 55, "<Item>" },
	{ "/Timezone/Africa/Kinshasa", NULL, setTimeZoneCallback, 56, "<Item>" },
	{ "/Timezone/Africa/Lagos", NULL, setTimeZoneCallback, 57, "<Item>" },
	{ "/Timezone/Africa/Libreville", NULL, setTimeZoneCallback, 58, "<Item>" },
	{ "/Timezone/Africa/Lome", NULL, setTimeZoneCallback, 59, "<Item>" },
	{ "/Timezone/Africa/Luanda", NULL, setTimeZoneCallback, 60, "<Item>" },
	{ "/Timezone/Africa/Lubumbashi", NULL, setTimeZoneCallback, 61, "<Item>" },
	{ "/Timezone/Africa/Lusaka", NULL, setTimeZoneCallback, 62, "<Item>" },
	{ "/Timezone/Africa/Malabo", NULL, setTimeZoneCallback, 63, "<Item>" },
	{ "/Timezone/Africa/Maputo", NULL, setTimeZoneCallback, 64, "<Item>" },
	{ "/Timezone/Africa/Maseru", NULL, setTimeZoneCallback, 65, "<Item>" },
	{ "/Timezone/Africa/Mbabane", NULL, setTimeZoneCallback, 66, "<Item>" },
	{ "/Timezone/Africa/Mogadishu", NULL, setTimeZoneCallback, 67, "<Item>" },
	{ "/Timezone/Africa/Monrovia", NULL, setTimeZoneCallback, 68, "<Item>" },
	{ "/Timezone/Africa/Nairobi", NULL, setTimeZoneCallback, 69, "<Item>" },
	{ "/Timezone/Africa/Ndjamena", NULL, setTimeZoneCallback, 70, "<Item>" },
	{ "/Timezone/Africa/Niamey", NULL, setTimeZoneCallback, 71, "<Item>" },
	{ "/Timezone/Africa/Nouakchott", NULL, setTimeZoneCallback, 72, "<Item>" },
	{ "/Timezone/Africa/Ouagadougou", NULL, setTimeZoneCallback, 73, "<Item>" },
	{ "/Timezone/Africa/Porto-Novo", NULL, setTimeZoneCallback, 74, "<Item>" },
	{ "/Timezone/Africa/Sao Tome", NULL, setTimeZoneCallback, 75, "<Item>" },
	{ "/Timezone/Africa/Tripoli", NULL, setTimeZoneCallback, 76, "<Item>" },
	{ "/Timezone/Africa/Tunis", NULL, setTimeZoneCallback, 77, "<Item>" },
	{ "/Timezone/Africa/Windhoek", NULL, setTimeZoneCallback, 78, "<Item>" },
	{ "/Timezone/America", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/America/Argentina", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/America/Argentina/Buenos Aires", NULL, setTimeZoneCallback, 79, "<Item>" },
	{ "/Timezone/America/Argentina/Catamarca", NULL, setTimeZoneCallback, 80, "<Item>" },
	{ "/Timezone/America/Argentina/Cordoba", NULL, setTimeZoneCallback, 81, "<Item>" },
	{ "/Timezone/America/Argentina/Jujuy", NULL, setTimeZoneCallback, 82, "<Item>" },
	{ "/Timezone/America/Argentina/La Rioja", NULL, setTimeZoneCallback, 83, "<Item>" },
	{ "/Timezone/America/Argentina/Mendoza", NULL, setTimeZoneCallback, 84, "<Item>" },
	{ "/Timezone/America/Argentina/Rio Gallegos", NULL, setTimeZoneCallback, 85, "<Item>" },
	{ "/Timezone/America/Argentina/San Juan", NULL, setTimeZoneCallback, 86, "<Item>" },
	{ "/Timezone/America/Argentina/San Luis", NULL, setTimeZoneCallback, 87, "<Item>" },
	{ "/Timezone/America/Argentina/Tucuman", NULL, setTimeZoneCallback, 88, "<Item>" },
	{ "/Timezone/America/Argentina/Ushuaia", NULL, setTimeZoneCallback, 89, "<Item>" },
	{ "/Timezone/America/Indiana", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/America/Indiana/Indianapolis", NULL, setTimeZoneCallback, 90, "<Item>" },
	{ "/Timezone/America/Indiana/Knox", NULL, setTimeZoneCallback, 91, "<Item>" },
	{ "/Timezone/America/Indiana/Marengo", NULL, setTimeZoneCallback, 92, "<Item>" },
	{ "/Timezone/America/Indiana/Petersburg", NULL, setTimeZoneCallback, 93, "<Item>" },
	{ "/Timezone/America/Indiana/Tell City", NULL, setTimeZoneCallback, 94, "<Item>" },
	{ "/Timezone/America/Indiana/Vevay", NULL, setTimeZoneCallback, 95, "<Item>" },
	{ "/Timezone/America/Indiana/Vincennes", NULL, setTimeZoneCallback, 96, "<Item>" },
	{ "/Timezone/America/Indiana/Winamac", NULL, setTimeZoneCallback, 97, "<Item>" },
	{ "/Timezone/America/Kentucky", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/America/Kentucky/Louisville", NULL, setTimeZoneCallback, 98, "<Item>" },
	{ "/Timezone/America/Kentucky/Monticello", NULL, setTimeZoneCallback, 99, "<Item>" },
	{ "/Timezone/America/North Dakota", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/America/North Dakota/Center", NULL, setTimeZoneCallback, 100, "<Item>" },
	{ "/Timezone/America/North Dakota/New Salem", NULL, setTimeZoneCallback, 101, "<Item>" },
	{ "/Timezone/America/Adak", NULL, setTimeZoneCallback, 102, "<Item>" },
	{ "/Timezone/America/Anchorage", NULL, setTimeZoneCallback, 103, "<Item>" },
	{ "/Timezone/America/Anguilla", NULL, setTimeZoneCallback, 104, "<Item>" },
	{ "/Timezone/America/Antigua", NULL, setTimeZoneCallback, 105, "<Item>" },
	{ "/Timezone/America/Araguaina", NULL, setTimeZoneCallback, 106, "<Item>" },
	{ "/Timezone/America/Aruba", NULL, setTimeZoneCallback, 107, "<Item>" },
	{ "/Timezone/America/Asuncion", NULL, setTimeZoneCallback, 108, "<Item>" },
	{ "/Timezone/America/Atikokan", NULL, setTimeZoneCallback, 109, "<Item>" },
	{ "/Timezone/America/Bahia", NULL, setTimeZoneCallback, 110, "<Item>" },
	{ "/Timezone/America/Barbados", NULL, setTimeZoneCallback, 111, "<Item>" },
	{ "/Timezone/America/Belem", NULL, setTimeZoneCallback, 112, "<Item>" },
	{ "/Timezone/America/Belize", NULL, setTimeZoneCallback, 113, "<Item>" },
	{ "/Timezone/America/Blanc-Sablon", NULL, setTimeZoneCallback, 114, "<Item>" },
	{ "/Timezone/America/Boa Vista", NULL, setTimeZoneCallback, 115, "<Item>" },
	{ "/Timezone/America/Bogota", NULL, setTimeZoneCallback, 116, "<Item>" },
	{ "/Timezone/America/Boise", NULL, setTimeZoneCallback, 117, "<Item>" },
	{ "/Timezone/America/Cambridge Bay", NULL, setTimeZoneCallback, 118, "<Item>" },
	{ "/Timezone/America/Campo Grande", NULL, setTimeZoneCallback, 119, "<Item>" },
	{ "/Timezone/America/Cancun", NULL, setTimeZoneCallback, 120, "<Item>" },
	{ "/Timezone/America/Caracas", NULL, setTimeZoneCallback, 121, "<Item>" },
	{ "/Timezone/America/Cayenne", NULL, setTimeZoneCallback, 122, "<Item>" },
	{ "/Timezone/America/Cayman", NULL, setTimeZoneCallback, 123, "<Item>" },
	{ "/Timezone/America/Chicago", NULL, setTimeZoneCallback, 124, "<Item>" },
	{ "/Timezone/America/Chihuahua", NULL, setTimeZoneCallback, 125, "<Item>" },
	{ "/Timezone/America/Costa Rica", NULL, setTimeZoneCallback, 126, "<Item>" },
	{ "/Timezone/America/Cuiaba", NULL, setTimeZoneCallback, 127, "<Item>" },
	{ "/Timezone/America/Curacao", NULL, setTimeZoneCallback, 128, "<Item>" },
	{ "/Timezone/America/Danmarkshavn", NULL, setTimeZoneCallback, 129, "<Item>" },
	{ "/Timezone/America/Dawson", NULL, setTimeZoneCallback, 130, "<Item>" },
	{ "/Timezone/America/Dawson Creek", NULL, setTimeZoneCallback, 131, "<Item>" },
	{ "/Timezone/America/Denver", NULL, setTimeZoneCallback, 132, "<Item>" },
	{ "/Timezone/America/Detroit", NULL, setTimeZoneCallback, 133, "<Item>" },
	{ "/Timezone/America/Dominica", NULL, setTimeZoneCallback, 134, "<Item>" },
	{ "/Timezone/America/Edmonton", NULL, setTimeZoneCallback, 135, "<Item>" },
	{ "/Timezone/America/Eirunepe", NULL, setTimeZoneCallback, 136, "<Item>" },
	{ "/Timezone/America/El Salvador", NULL, setTimeZoneCallback, 137, "<Item>" },
	{ "/Timezone/America/Fortaleza", NULL, setTimeZoneCallback, 138, "<Item>" },
	{ "/Timezone/America/Glace Bay", NULL, setTimeZoneCallback, 139, "<Item>" },
	{ "/Timezone/America/Godthab", NULL, setTimeZoneCallback, 140, "<Item>" },
	{ "/Timezone/America/Goose Bay", NULL, setTimeZoneCallback, 141, "<Item>" },
	{ "/Timezone/America/Grand Turk", NULL, setTimeZoneCallback, 142, "<Item>" },
	{ "/Timezone/America/Grenada", NULL, setTimeZoneCallback, 143, "<Item>" },
	{ "/Timezone/America/Guadeloupe", NULL, setTimeZoneCallback, 144, "<Item>" },
	{ "/Timezone/America/Guatemala", NULL, setTimeZoneCallback, 145, "<Item>" },
	{ "/Timezone/America/Guayaquil", NULL, setTimeZoneCallback, 146, "<Item>" },
	{ "/Timezone/America/Guyana", NULL, setTimeZoneCallback, 147, "<Item>" },
	{ "/Timezone/America/Halifax", NULL, setTimeZoneCallback, 148, "<Item>" },
	{ "/Timezone/America/Havana", NULL, setTimeZoneCallback, 149, "<Item>" },
	{ "/Timezone/America/Hermosillo", NULL, setTimeZoneCallback, 150, "<Item>" },
	{ "/Timezone/America/Inuvik", NULL, setTimeZoneCallback, 151, "<Item>" },
	{ "/Timezone/America/Iqaluit", NULL, setTimeZoneCallback, 152, "<Item>" },
	{ "/Timezone/America/Jamaica", NULL, setTimeZoneCallback, 153, "<Item>" },
	{ "/Timezone/America/Juneau", NULL, setTimeZoneCallback, 154, "<Item>" },
	{ "/Timezone/America/La Paz", NULL, setTimeZoneCallback, 155, "<Item>" },
	{ "/Timezone/America/Lima", NULL, setTimeZoneCallback, 156, "<Item>" },
	{ "/Timezone/America/Los Angeles", NULL, setTimeZoneCallback, 157, "<Item>" },
	{ "/Timezone/America/Maceio", NULL, setTimeZoneCallback, 158, "<Item>" },
	{ "/Timezone/America/Managua", NULL, setTimeZoneCallback, 159, "<Item>" },
	{ "/Timezone/America/Manaus", NULL, setTimeZoneCallback, 160, "<Item>" },
	{ "/Timezone/America/Marigot", NULL, setTimeZoneCallback, 161, "<Item>" },
	{ "/Timezone/America/Martinique", NULL, setTimeZoneCallback, 162, "<Item>" },
	{ "/Timezone/America/Mazatlan", NULL, setTimeZoneCallback, 163, "<Item>" },
	{ "/Timezone/America/Menominee", NULL, setTimeZoneCallback, 164, "<Item>" },
	{ "/Timezone/America/Merida", NULL, setTimeZoneCallback, 165, "<Item>" },
	{ "/Timezone/America/Mexico City", NULL, setTimeZoneCallback, 166, "<Item>" },
	{ "/Timezone/America/Miquelon", NULL, setTimeZoneCallback, 167, "<Item>" },
	{ "/Timezone/America/Moncton", NULL, setTimeZoneCallback, 168, "<Item>" },
	{ "/Timezone/America/Monterrey", NULL, setTimeZoneCallback, 169, "<Item>" },
	{ "/Timezone/America/Montevideo", NULL, setTimeZoneCallback, 170, "<Item>" },
	{ "/Timezone/America/Montreal", NULL, setTimeZoneCallback, 171, "<Item>" },
	{ "/Timezone/America/Montserrat", NULL, setTimeZoneCallback, 172, "<Item>" },
	{ "/Timezone/America/Nassau", NULL, setTimeZoneCallback, 173, "<Item>" },
	{ "/Timezone/America/New York", NULL, setTimeZoneCallback, 174, "<Item>" },
	{ "/Timezone/America/Nipigon", NULL, setTimeZoneCallback, 175, "<Item>" },
	{ "/Timezone/America/Nome", NULL, setTimeZoneCallback, 176, "<Item>" },
	{ "/Timezone/America/Noronha", NULL, setTimeZoneCallback, 177, "<Item>" },
	{ "/Timezone/America/Panama", NULL, setTimeZoneCallback, 178, "<Item>" },
	{ "/Timezone/America/Pangnirtung", NULL, setTimeZoneCallback, 179, "<Item>" },
	{ "/Timezone/America/Paramaribo", NULL, setTimeZoneCallback, 180, "<Item>" },
	{ "/Timezone/America/Phoenix", NULL, setTimeZoneCallback, 181, "<Item>" },
	{ "/Timezone/America/Port-au-Prince", NULL, setTimeZoneCallback, 182, "<Item>" },
	{ "/Timezone/America/Port of Spain", NULL, setTimeZoneCallback, 183, "<Item>" },
	{ "/Timezone/America/Porto Velho", NULL, setTimeZoneCallback, 184, "<Item>" },
	{ "/Timezone/America/Puerto Rico", NULL, setTimeZoneCallback, 185, "<Item>" },
	{ "/Timezone/America/Rainy River", NULL, setTimeZoneCallback, 186, "<Item>" },
	{ "/Timezone/America/Rankin Inlet", NULL, setTimeZoneCallback, 187, "<Item>" },
	{ "/Timezone/America/Recife", NULL, setTimeZoneCallback, 188, "<Item>" },
	{ "/Timezone/America/Regina", NULL, setTimeZoneCallback, 189, "<Item>" },
	{ "/Timezone/America/Resolute", NULL, setTimeZoneCallback, 190, "<Item>" },
	{ "/Timezone/America/Rio Branco", NULL, setTimeZoneCallback, 191, "<Item>" },
	{ "/Timezone/America/Santiago", NULL, setTimeZoneCallback, 192, "<Item>" },
	{ "/Timezone/America/Santo Domingo", NULL, setTimeZoneCallback, 193, "<Item>" },
	{ "/Timezone/America/Sao Paulo", NULL, setTimeZoneCallback, 194, "<Item>" },
	{ "/Timezone/America/Scoresbysund", NULL, setTimeZoneCallback, 195, "<Item>" },
	{ "/Timezone/America/Shiprock", NULL, setTimeZoneCallback, 196, "<Item>" },
	{ "/Timezone/America/St Barthelemy", NULL, setTimeZoneCallback, 197, "<Item>" },
	{ "/Timezone/America/St Johns", NULL, setTimeZoneCallback, 198, "<Item>" },
	{ "/Timezone/America/St Kitts", NULL, setTimeZoneCallback, 199, "<Item>" },
	{ "/Timezone/America/St Lucia", NULL, setTimeZoneCallback, 200, "<Item>" },
	{ "/Timezone/America/St Thomas", NULL, setTimeZoneCallback, 201, "<Item>" },
	{ "/Timezone/America/St Vincent", NULL, setTimeZoneCallback, 202, "<Item>" },
	{ "/Timezone/America/Swift Current", NULL, setTimeZoneCallback, 203, "<Item>" },
	{ "/Timezone/America/Tegucigalpa", NULL, setTimeZoneCallback, 204, "<Item>" },
	{ "/Timezone/America/Thule", NULL, setTimeZoneCallback, 205, "<Item>" },
	{ "/Timezone/America/Thunder Bay", NULL, setTimeZoneCallback, 206, "<Item>" },
	{ "/Timezone/America/Tijuana", NULL, setTimeZoneCallback, 207, "<Item>" },
	{ "/Timezone/America/Toronto", NULL, setTimeZoneCallback, 208, "<Item>" },
	{ "/Timezone/America/Tortola", NULL, setTimeZoneCallback, 209, "<Item>" },
	{ "/Timezone/America/Vancouver", NULL, setTimeZoneCallback, 210, "<Item>" },
	{ "/Timezone/America/Whitehorse", NULL, setTimeZoneCallback, 211, "<Item>" },
	{ "/Timezone/America/Winnipeg", NULL, setTimeZoneCallback, 212, "<Item>" },
	{ "/Timezone/America/Yakutat", NULL, setTimeZoneCallback, 213, "<Item>" },
	{ "/Timezone/America/Yellowknife", NULL, setTimeZoneCallback, 214, "<Item>" },
	{ "/Timezone/Antarctica", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Antarctica/Casey", NULL, setTimeZoneCallback, 215, "<Item>" },
	{ "/Timezone/Antarctica/Davis", NULL, setTimeZoneCallback, 216, "<Item>" },
	{ "/Timezone/Antarctica/DumontDUrville", NULL, setTimeZoneCallback, 217, "<Item>" },
	{ "/Timezone/Antarctica/Mawson", NULL, setTimeZoneCallback, 218, "<Item>" },
	{ "/Timezone/Antarctica/McMurdo", NULL, setTimeZoneCallback, 219, "<Item>" },
	{ "/Timezone/Antarctica/Palmer", NULL, setTimeZoneCallback, 220, "<Item>" },
	{ "/Timezone/Antarctica/Rothera", NULL, setTimeZoneCallback, 221, "<Item>" },
	{ "/Timezone/Antarctica/South Pole", NULL, setTimeZoneCallback, 222, "<Item>" },
	{ "/Timezone/Antarctica/Syowa", NULL, setTimeZoneCallback, 223, "<Item>" },
	{ "/Timezone/Antarctica/Vostok", NULL, setTimeZoneCallback, 224, "<Item>" },
	{ "/Timezone/Arctic", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Arctic/Longyearbyen", NULL, setTimeZoneCallback, 225, "<Item>" },
	{ "/Timezone/Asia", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Asia/Aden", NULL, setTimeZoneCallback, 226, "<Item>" },
	{ "/Timezone/Asia/Almaty", NULL, setTimeZoneCallback, 227, "<Item>" },
	{ "/Timezone/Asia/Amman", NULL, setTimeZoneCallback, 228, "<Item>" },
	{ "/Timezone/Asia/Anadyr", NULL, setTimeZoneCallback, 229, "<Item>" },
	{ "/Timezone/Asia/Aqtau", NULL, setTimeZoneCallback, 230, "<Item>" },
	{ "/Timezone/Asia/Aqtobe", NULL, setTimeZoneCallback, 231, "<Item>" },
	{ "/Timezone/Asia/Ashgabat", NULL, setTimeZoneCallback, 232, "<Item>" },
	{ "/Timezone/Asia/Baghdad", NULL, setTimeZoneCallback, 233, "<Item>" },
	{ "/Timezone/Asia/Bahrain", NULL, setTimeZoneCallback, 234, "<Item>" },
	{ "/Timezone/Asia/Baku", NULL, setTimeZoneCallback, 235, "<Item>" },
	{ "/Timezone/Asia/Bangkok", NULL, setTimeZoneCallback, 236, "<Item>" },
	{ "/Timezone/Asia/Beirut", NULL, setTimeZoneCallback, 237, "<Item>" },
	{ "/Timezone/Asia/Bishkek", NULL, setTimeZoneCallback, 238, "<Item>" },
	{ "/Timezone/Asia/Brunei", NULL, setTimeZoneCallback, 239, "<Item>" },
	{ "/Timezone/Asia/Choibalsan", NULL, setTimeZoneCallback, 240, "<Item>" },
	{ "/Timezone/Asia/Chongqing", NULL, setTimeZoneCallback, 241, "<Item>" },
	{ "/Timezone/Asia/Colombo", NULL, setTimeZoneCallback, 242, "<Item>" },
	{ "/Timezone/Asia/Damascus", NULL, setTimeZoneCallback, 243, "<Item>" },
	{ "/Timezone/Asia/Dhaka", NULL, setTimeZoneCallback, 244, "<Item>" },
	{ "/Timezone/Asia/Dili", NULL, setTimeZoneCallback, 245, "<Item>" },
	{ "/Timezone/Asia/Dubai", NULL, setTimeZoneCallback, 246, "<Item>" },
	{ "/Timezone/Asia/Dushanbe", NULL, setTimeZoneCallback, 247, "<Item>" },
	{ "/Timezone/Asia/Gaza", NULL, setTimeZoneCallback, 248, "<Item>" },
	{ "/Timezone/Asia/Harbin", NULL, setTimeZoneCallback, 249, "<Item>" },
	{ "/Timezone/Asia/Ho Chi Minh", NULL, setTimeZoneCallback, 250, "<Item>" },
	{ "/Timezone/Asia/Hong Kong", NULL, setTimeZoneCallback, 251, "<Item>" },
	{ "/Timezone/Asia/Hovd", NULL, setTimeZoneCallback, 252, "<Item>" },
	{ "/Timezone/Asia/Irkutsk", NULL, setTimeZoneCallback, 253, "<Item>" },
	{ "/Timezone/Asia/Jakarta", NULL, setTimeZoneCallback, 254, "<Item>" },
	{ "/Timezone/Asia/Jayapura", NULL, setTimeZoneCallback, 255, "<Item>" },
	{ "/Timezone/Asia/Jerusalem", NULL, setTimeZoneCallback, 256, "<Item>" },
	{ "/Timezone/Asia/Kabul", NULL, setTimeZoneCallback, 257, "<Item>" },
	{ "/Timezone/Asia/Kamchatka", NULL, setTimeZoneCallback, 258, "<Item>" },
	{ "/Timezone/Asia/Karachi", NULL, setTimeZoneCallback, 259, "<Item>" },
	{ "/Timezone/Asia/Kashgar", NULL, setTimeZoneCallback, 260, "<Item>" },
	{ "/Timezone/Asia/Katmandu", NULL, setTimeZoneCallback, 261, "<Item>" },
	{ "/Timezone/Asia/Kolkata", NULL, setTimeZoneCallback, 262, "<Item>" },
	{ "/Timezone/Asia/Krasnoyarsk", NULL, setTimeZoneCallback, 263, "<Item>" },
	{ "/Timezone/Asia/Kuala Lumpur", NULL, setTimeZoneCallback, 264, "<Item>" },
	{ "/Timezone/Asia/Kuching", NULL, setTimeZoneCallback, 265, "<Item>" },
	{ "/Timezone/Asia/Kuwait", NULL, setTimeZoneCallback, 266, "<Item>" },
	{ "/Timezone/Asia/Macau", NULL, setTimeZoneCallback, 267, "<Item>" },
	{ "/Timezone/Asia/Magadan", NULL, setTimeZoneCallback, 268, "<Item>" },
	{ "/Timezone/Asia/Makassar", NULL, setTimeZoneCallback, 269, "<Item>" },
	{ "/Timezone/Asia/Manila", NULL, setTimeZoneCallback, 270, "<Item>" },
	{ "/Timezone/Asia/Muscat", NULL, setTimeZoneCallback, 271, "<Item>" },
	{ "/Timezone/Asia/Nicosia", NULL, setTimeZoneCallback, 272, "<Item>" },
	{ "/Timezone/Asia/Novosibirsk", NULL, setTimeZoneCallback, 273, "<Item>" },
	{ "/Timezone/Asia/Omsk", NULL, setTimeZoneCallback, 274, "<Item>" },
	{ "/Timezone/Asia/Oral", NULL, setTimeZoneCallback, 275, "<Item>" },
	{ "/Timezone/Asia/Phnom Penh", NULL, setTimeZoneCallback, 276, "<Item>" },
	{ "/Timezone/Asia/Pontianak", NULL, setTimeZoneCallback, 277, "<Item>" },
	{ "/Timezone/Asia/Pyongyang", NULL, setTimeZoneCallback, 278, "<Item>" },
	{ "/Timezone/Asia/Qatar", NULL, setTimeZoneCallback, 279, "<Item>" },
	{ "/Timezone/Asia/Qyzylorda", NULL, setTimeZoneCallback, 280, "<Item>" },
	{ "/Timezone/Asia/Rangoon", NULL, setTimeZoneCallback, 281, "<Item>" },
	{ "/Timezone/Asia/Riyadh", NULL, setTimeZoneCallback, 282, "<Item>" },
	{ "/Timezone/Asia/Sakhalin", NULL, setTimeZoneCallback, 283, "<Item>" },
	{ "/Timezone/Asia/Samarkand", NULL, setTimeZoneCallback, 284, "<Item>" },
	{ "/Timezone/Asia/Seoul", NULL, setTimeZoneCallback, 285, "<Item>" },
	{ "/Timezone/Asia/Shanghai", NULL, setTimeZoneCallback, 286, "<Item>" },
	{ "/Timezone/Asia/Singapore", NULL, setTimeZoneCallback, 287, "<Item>" },
	{ "/Timezone/Asia/Taipei", NULL, setTimeZoneCallback, 288, "<Item>" },
	{ "/Timezone/Asia/Tashkent", NULL, setTimeZoneCallback, 289, "<Item>" },
	{ "/Timezone/Asia/Tbilisi", NULL, setTimeZoneCallback, 290, "<Item>" },
	{ "/Timezone/Asia/Tehran", NULL, setTimeZoneCallback, 291, "<Item>" },
	{ "/Timezone/Asia/Thimphu", NULL, setTimeZoneCallback, 292, "<Item>" },
	{ "/Timezone/Asia/Tokyo", NULL, setTimeZoneCallback, 293, "<Item>" },
	{ "/Timezone/Asia/Ulaanbaatar", NULL, setTimeZoneCallback, 294, "<Item>" },
	{ "/Timezone/Asia/Urumqi", NULL, setTimeZoneCallback, 295, "<Item>" },
	{ "/Timezone/Asia/Vientiane", NULL, setTimeZoneCallback, 296, "<Item>" },
	{ "/Timezone/Asia/Vladivostok", NULL, setTimeZoneCallback, 297, "<Item>" },
	{ "/Timezone/Asia/Yakutsk", NULL, setTimeZoneCallback, 298, "<Item>" },
	{ "/Timezone/Asia/Yekaterinburg", NULL, setTimeZoneCallback, 299, "<Item>" },
	{ "/Timezone/Asia/Yerevan", NULL, setTimeZoneCallback, 300, "<Item>" },
	{ "/Timezone/Atlantic", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Atlantic/Azores", NULL, setTimeZoneCallback, 301, "<Item>" },
	{ "/Timezone/Atlantic/Bermuda", NULL, setTimeZoneCallback, 302, "<Item>" },
	{ "/Timezone/Atlantic/Canary", NULL, setTimeZoneCallback, 303, "<Item>" },
	{ "/Timezone/Atlantic/Cape Verde", NULL, setTimeZoneCallback, 304, "<Item>" },
	{ "/Timezone/Atlantic/Faroe", NULL, setTimeZoneCallback, 305, "<Item>" },
	{ "/Timezone/Atlantic/Madeira", NULL, setTimeZoneCallback, 306, "<Item>" },
	{ "/Timezone/Atlantic/Reykjavik", NULL, setTimeZoneCallback, 307, "<Item>" },
	{ "/Timezone/Atlantic/South Georgia", NULL, setTimeZoneCallback, 308, "<Item>" },
	{ "/Timezone/Atlantic/St Helena", NULL, setTimeZoneCallback, 309, "<Item>" },
	{ "/Timezone/Atlantic/Stanley", NULL, setTimeZoneCallback, 310, "<Item>" },
	{ "/Timezone/Australia", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Australia/Adelaide", NULL, setTimeZoneCallback, 311, "<Item>" },
	{ "/Timezone/Australia/Brisbane", NULL, setTimeZoneCallback, 312, "<Item>" },
	{ "/Timezone/Australia/Broken Hill", NULL, setTimeZoneCallback, 313, "<Item>" },
	{ "/Timezone/Australia/Currie", NULL, setTimeZoneCallback, 314, "<Item>" },
	{ "/Timezone/Australia/Darwin", NULL, setTimeZoneCallback, 315, "<Item>" },
	{ "/Timezone/Australia/Eucla", NULL, setTimeZoneCallback, 316, "<Item>" },
	{ "/Timezone/Australia/Hobart", NULL, setTimeZoneCallback, 317, "<Item>" },
	{ "/Timezone/Australia/Lindeman", NULL, setTimeZoneCallback, 318, "<Item>" },
	{ "/Timezone/Australia/Lord Howe", NULL, setTimeZoneCallback, 319, "<Item>" },
	{ "/Timezone/Australia/Melbourne", NULL, setTimeZoneCallback, 320, "<Item>" },
	{ "/Timezone/Australia/Perth", NULL, setTimeZoneCallback, 321, "<Item>" },
	{ "/Timezone/Australia/Sydney", NULL, setTimeZoneCallback, 322, "<Item>" },
	{ "/Timezone/Europe", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Europe/Amsterdam", NULL, setTimeZoneCallback, 323, "<Item>" },
	{ "/Timezone/Europe/Andorra", NULL, setTimeZoneCallback, 324, "<Item>" },
	{ "/Timezone/Europe/Athens", NULL, setTimeZoneCallback, 325, "<Item>" },
	{ "/Timezone/Europe/Belgrade", NULL, setTimeZoneCallback, 326, "<Item>" },
	{ "/Timezone/Europe/Berlin", NULL, setTimeZoneCallback, 327, "<Item>" },
	{ "/Timezone/Europe/Bratislava", NULL, setTimeZoneCallback, 328, "<Item>" },
	{ "/Timezone/Europe/Brussels", NULL, setTimeZoneCallback, 329, "<Item>" },
	{ "/Timezone/Europe/Bucharest", NULL, setTimeZoneCallback, 330, "<Item>" },
	{ "/Timezone/Europe/Budapest", NULL, setTimeZoneCallback, 331, "<Item>" },
	{ "/Timezone/Europe/Chisinau", NULL, setTimeZoneCallback, 332, "<Item>" },
	{ "/Timezone/Europe/Copenhagen", NULL, setTimeZoneCallback, 333, "<Item>" },
	{ "/Timezone/Europe/Dublin", NULL, setTimeZoneCallback, 334, "<Item>" },
	{ "/Timezone/Europe/Gibraltar", NULL, setTimeZoneCallback, 335, "<Item>" },
	{ "/Timezone/Europe/Guernsey", NULL, setTimeZoneCallback, 336, "<Item>" },
	{ "/Timezone/Europe/Helsinki", NULL, setTimeZoneCallback, 337, "<Item>" },
	{ "/Timezone/Europe/Isle of Man", NULL, setTimeZoneCallback, 338, "<Item>" },
	{ "/Timezone/Europe/Istanbul", NULL, setTimeZoneCallback, 339, "<Item>" },
	{ "/Timezone/Europe/Jersey", NULL, setTimeZoneCallback, 340, "<Item>" },
	{ "/Timezone/Europe/Kaliningrad", NULL, setTimeZoneCallback, 341, "<Item>" },
	{ "/Timezone/Europe/Kiev", NULL, setTimeZoneCallback, 342, "<Item>" },
	{ "/Timezone/Europe/Lisbon", NULL, setTimeZoneCallback, 343, "<Item>" },
	{ "/Timezone/Europe/Ljubljana", NULL, setTimeZoneCallback, 344, "<Item>" },
	{ "/Timezone/Europe/London", NULL, setTimeZoneCallback, 345, "<Item>" },
	{ "/Timezone/Europe/Luxembourg", NULL, setTimeZoneCallback, 346, "<Item>" },
	{ "/Timezone/Europe/Madrid", NULL, setTimeZoneCallback, 347, "<Item>" },
	{ "/Timezone/Europe/Malta", NULL, setTimeZoneCallback, 348, "<Item>" },
	{ "/Timezone/Europe/Mariehamn", NULL, setTimeZoneCallback, 349, "<Item>" },
	{ "/Timezone/Europe/Minsk", NULL, setTimeZoneCallback, 350, "<Item>" },
	{ "/Timezone/Europe/Monaco", NULL, setTimeZoneCallback, 351, "<Item>" },
	{ "/Timezone/Europe/Moscow", NULL, setTimeZoneCallback, 352, "<Item>" },
	{ "/Timezone/Europe/Oslo", NULL, setTimeZoneCallback, 353, "<Item>" },
	{ "/Timezone/Europe/Paris", NULL, setTimeZoneCallback, 354, "<Item>" },
	{ "/Timezone/Europe/Podgorica", NULL, setTimeZoneCallback, 355, "<Item>" },
	{ "/Timezone/Europe/Prague", NULL, setTimeZoneCallback, 356, "<Item>" },
	{ "/Timezone/Europe/Riga", NULL, setTimeZoneCallback, 357, "<Item>" },
	{ "/Timezone/Europe/Rome", NULL, setTimeZoneCallback, 358, "<Item>" },
	{ "/Timezone/Europe/Samara", NULL, setTimeZoneCallback, 359, "<Item>" },
	{ "/Timezone/Europe/San Marino", NULL, setTimeZoneCallback, 360, "<Item>" },
	{ "/Timezone/Europe/Sarajevo", NULL, setTimeZoneCallback, 361, "<Item>" },
	{ "/Timezone/Europe/Simferopol", NULL, setTimeZoneCallback, 362, "<Item>" },
	{ "/Timezone/Europe/Skopje", NULL, setTimeZoneCallback, 363, "<Item>" },
	{ "/Timezone/Europe/Sofia", NULL, setTimeZoneCallback, 364, "<Item>" },
	{ "/Timezone/Europe/Stockholm", NULL, setTimeZoneCallback, 365, "<Item>" },
	{ "/Timezone/Europe/Tallinn", NULL, setTimeZoneCallback, 366, "<Item>" },
	{ "/Timezone/Europe/Tirane", NULL, setTimeZoneCallback, 367, "<Item>" },
	{ "/Timezone/Europe/Uzhgorod", NULL, setTimeZoneCallback, 368, "<Item>" },
	{ "/Timezone/Europe/Vaduz", NULL, setTimeZoneCallback, 369, "<Item>" },
	{ "/Timezone/Europe/Vatican", NULL, setTimeZoneCallback, 370, "<Item>" },
	{ "/Timezone/Europe/Vienna", NULL, setTimeZoneCallback, 371, "<Item>" },
	{ "/Timezone/Europe/Vilnius", NULL, setTimeZoneCallback, 372, "<Item>" },
	{ "/Timezone/Europe/Volgograd", NULL, setTimeZoneCallback, 373, "<Item>" },
	{ "/Timezone/Europe/Warsaw", NULL, setTimeZoneCallback, 374, "<Item>" },
	{ "/Timezone/Europe/Zagreb", NULL, setTimeZoneCallback, 375, "<Item>" },
	{ "/Timezone/Europe/Zaporozhye", NULL, setTimeZoneCallback, 376, "<Item>" },
	{ "/Timezone/Europe/Zurich", NULL, setTimeZoneCallback, 377, "<Item>" },
	{ "/Timezone/Indian", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Indian/Antananarivo", NULL, setTimeZoneCallback, 378, "<Item>" },
	{ "/Timezone/Indian/Chagos", NULL, setTimeZoneCallback, 379, "<Item>" },
	{ "/Timezone/Indian/Christmas", NULL, setTimeZoneCallback, 380, "<Item>" },
	{ "/Timezone/Indian/Cocos", NULL, setTimeZoneCallback, 381, "<Item>" },
	{ "/Timezone/Indian/Comoro", NULL, setTimeZoneCallback, 382, "<Item>" },
	{ "/Timezone/Indian/Kerguelen", NULL, setTimeZoneCallback, 383, "<Item>" },
	{ "/Timezone/Indian/Mahe", NULL, setTimeZoneCallback, 384, "<Item>" },
	{ "/Timezone/Indian/Maldives", NULL, setTimeZoneCallback, 385, "<Item>" },
	{ "/Timezone/Indian/Mauritius", NULL, setTimeZoneCallback, 386, "<Item>" },
	{ "/Timezone/Indian/Mayotte", NULL, setTimeZoneCallback, 387, "<Item>" },
	{ "/Timezone/Indian/Reunion", NULL, setTimeZoneCallback, 388, "<Item>" },
	{ "/Timezone/Pacific", NULL, NULL, 0, "<Branch>" },
	{ "/Timezone/Pacific/Apia", NULL, setTimeZoneCallback, 389, "<Item>" },
	{ "/Timezone/Pacific/Auckland", NULL, setTimeZoneCallback, 390, "<Item>" },
	{ "/Timezone/Pacific/Chatham", NULL, setTimeZoneCallback, 391, "<Item>" },
	{ "/Timezone/Pacific/Easter", NULL, setTimeZoneCallback, 392, "<Item>" },
	{ "/Timezone/Pacific/Efate", NULL, setTimeZoneCallback, 393, "<Item>" },
	{ "/Timezone/Pacific/Enderbury", NULL, setTimeZoneCallback, 394, "<Item>" },
	{ "/Timezone/Pacific/Fakaofo", NULL, setTimeZoneCallback, 395, "<Item>" },
	{ "/Timezone/Pacific/Fiji", NULL, setTimeZoneCallback, 396, "<Item>" },
	{ "/Timezone/Pacific/Funafuti", NULL, setTimeZoneCallback, 397, "<Item>" },
	{ "/Timezone/Pacific/Galapagos", NULL, setTimeZoneCallback, 398, "<Item>" },
	{ "/Timezone/Pacific/Gambier", NULL, setTimeZoneCallback, 399, "<Item>" },
	{ "/Timezone/Pacific/Guadalcanal", NULL, setTimeZoneCallback, 400, "<Item>" },
	{ "/Timezone/Pacific/Guam", NULL, setTimeZoneCallback, 401, "<Item>" },
	{ "/Timezone/Pacific/Honolulu", NULL, setTimeZoneCallback, 402, "<Item>" },
	{ "/Timezone/Pacific/Johnston", NULL, setTimeZoneCallback, 403, "<Item>" },
	{ "/Timezone/Pacific/Kiritimati", NULL, setTimeZoneCallback, 404, "<Item>" },
	{ "/Timezone/Pacific/Kosrae", NULL, setTimeZoneCallback, 405, "<Item>" },
	{ "/Timezone/Pacific/Kwajalein", NULL, setTimeZoneCallback, 406, "<Item>" },
	{ "/Timezone/Pacific/Majuro", NULL, setTimeZoneCallback, 407, "<Item>" },
	{ "/Timezone/Pacific/Marquesas", NULL, setTimeZoneCallback, 408, "<Item>" },
	{ "/Timezone/Pacific/Midway", NULL, setTimeZoneCallback, 409, "<Item>" },
	{ "/Timezone/Pacific/Nauru", NULL, setTimeZoneCallback, 410, "<Item>" },
	{ "/Timezone/Pacific/Niue", NULL, setTimeZoneCallback, 411, "<Item>" },
	{ "/Timezone/Pacific/Norfolk", NULL, setTimeZoneCallback, 412, "<Item>" },
	{ "/Timezone/Pacific/Noumea", NULL, setTimeZoneCallback, 413, "<Item>" },
	{ "/Timezone/Pacific/Pago Pago", NULL, setTimeZoneCallback, 414, "<Item>" },
	{ "/Timezone/Pacific/Palau", NULL, setTimeZoneCallback, 415, "<Item>" },
	{ "/Timezone/Pacific/Pitcairn", NULL, setTimeZoneCallback, 416, "<Item>" },
	{ "/Timezone/Pacific/Ponape", NULL, setTimeZoneCallback, 417, "<Item>" },
	{ "/Timezone/Pacific/Port Moresby", NULL, setTimeZoneCallback, 418, "<Item>" },
	{ "/Timezone/Pacific/Rarotonga", NULL, setTimeZoneCallback, 419, "<Item>" },
	{ "/Timezone/Pacific/Saipan", NULL, setTimeZoneCallback, 420, "<Item>" },
	{ "/Timezone/Pacific/Tahiti", NULL, setTimeZoneCallback, 421, "<Item>" },
	{ "/Timezone/Pacific/Tarawa", NULL, setTimeZoneCallback, 422, "<Item>" },
	{ "/Timezone/Pacific/Tongatapu", NULL, setTimeZoneCallback, 423, "<Item>" },
	{ "/Timezone/Pacific/Truk", NULL, setTimeZoneCallback, 424, "<Item>" },
	{ "/Timezone/Pacific/Wake", NULL, setTimeZoneCallback, 425, "<Item>" },
	{ "/Timezone/Pacific/Wallis", NULL, setTimeZoneCallback, 426, "<Item>" },

#endif
