 /* WARNING - DO NOT EDIT FILE - FILE IS AUTO GENERATED BY FUNCTIONS2CPP.PL*/
  /***************************************************************************
  *
  * Project:  OpenCPN
  * Purpose:  ROUTE Plugin
  * Author:   SaltyPaws
  *
  ***************************************************************************
  *   Copyright (C) 2012 by Brazil BrokeTail                                *
  *   $EMAIL$                                                               *
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  *   This program is distributed in the hope that it will be useful,       *
  *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
  *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
  *   GNU General Public License for more details.                          *
  *                                                                         *
  *   You should have received a copy of the GNU General Public License     *
  *   along with this program; if not, write to the                         *
  *   Free Software Foundation, Inc.,                                       *
  *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
  ***************************************************************************
  */

#include "functions.h"
CFormula::CFormula(void)
{
 this->Selected_Formula = 1;

this->m_ShortDesc.Add(_("Hull Speed"));
this->m_LongDesc.Add(_("Hull speed, sometimes referred to as displacement speed, can be thought of the speed at which the wavelength of the boats bow wave (in displacement mode) is equal to the boat length. As boat speed increases, the size of the bow wave increases, and therefore so does its wavelength. When hull speed is reached, a boat in pure displacement mode will appear trapped in a trough behind its very large bow wave."));
this->m_Category.Add(_("Design"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("vhull=1.34*sqrt(LWL)"));
this->m_Result_Unit.Add(_T("knots"));
this->m_Input_parameter.Add(_T("LWL"));
this->m_Input_unit.Add(_T("feet"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Draft of vessel when heeled"));
this->m_LongDesc.Add(_("Draft of vessel when heeled"));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("draft_heeled=draft*cos(dtr*angle)"));
this->m_Result_Unit.Add(_T("meter"));
this->m_Input_parameter.Add(_T("angle"));
this->m_Input_unit.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter1.Add(_T("draft"));
this->m_Input_unit1.Add(_T("meter"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Speed of wind-driven current"));
this->m_LongDesc.Add(_("Speed of wind-driven current"));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("Speed_Current = 0.03 * (Speed_Wind)"));
this->m_Result_Unit.Add(_T("knots"));
this->m_Input_parameter.Add(_T("Speed_Wind"));
this->m_Input_unit.Add(_T("knots"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Maximum Wavelength"));
this->m_LongDesc.Add(_("Maximum Wavelength = 1.5 x square root of fetch in nm"));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("Maximum_Wavelength = 1.5 * sqrt(fetch)"));
this->m_Result_Unit.Add(_T("meter"));
this->m_Input_parameter.Add(_T("fetch"));
this->m_Input_unit.Add(_T("Nautical Miles"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Wave speed =f(period)"));
this->m_LongDesc.Add(_("Wave speed = 3.03 x (wave period in seconds) NB output units need to be confirmed"));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("Wave_speed = 3.03 * (wave_period)"));
this->m_Result_Unit.Add(_T("knots"));
this->m_Input_parameter.Add(_T("wave_period"));
this->m_Input_unit.Add(_T("seconds"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Change in height of Tide"));
this->m_LongDesc.Add(_("Height is total change in tide height between high and low. The time ratio is time elapsed from the previous tide divided by the time difference between the two tides. (Similar to rule of 12)"));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("Not very accurate - use official publications"));
this->m_Formula.Add(_T("Change_in_height_of_Tide =  (height/2) * (1-cos(dtr*180 * time_ratio))"));
this->m_Result_Unit.Add(_T("meter"));
this->m_Input_parameter.Add(_T("height"));
this->m_Input_unit.Add(_T("meter"));
this->m_Input_parameter1.Add(_T("time_ratio"));
this->m_Input_unit1.Add(_T("-"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Fetch Modified Wilson"));
this->m_LongDesc.Add(_("Calculate Fetch as function of windspeed at 10 meters height (u10) and Fetch. The equation is based on the wilson equation (1965), but modified by Naoto for increased accuracy."));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("Naoto Ebuchi, Journal of oceanography, vol 55, pp 575 to 584, 1999"));
this->m_Formula.Add(_T("Waveheight=0 ,CDU10=(0.879+0.075*U10)*10^-3,U10 < 8 ? alpha = 1 : alpha = 0.6 + 0.05 * U10 ,Cd=CDU10/alpha ,F_hat=(Fetch*9.80665)/U10^2 ,F_star=F_hat/Cd,F_tilde=CDU10*F_star ,H_tilde=0.3*alpha*(1-(1+0.004*sqrt(F_tilde/alpha))^-2) ,H_star=H_tilde/CDU10 ,H_hat=H_star*Cd ,Waveheight=H_hat*(U10^2)/9.80665"));
this->m_Result_Unit.Add(_T("meter"));
this->m_Input_parameter.Add(_T("U10"));
this->m_Input_unit.Add(_T("m/s"));
this->m_Input_parameter1.Add(_T("Fetch"));
this->m_Input_unit1.Add(_T("meter"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Flow rate of leak in boat"));
this->m_LongDesc.Add(_("Flow rate of leak in boat:\tQ = 7.48*A*(2gH)^0.5\n\nQ = volume per minute of water coming in\nA = area of hole\nH = height of water over hole, to bottom of the opening"));
this->m_Category.Add(_("Safety"));
this->m_Source.Add(_("https://www.boatdesign.net/threads/water-intrusion-formula.38075/"));
// Q = 7.48* A x (2gh)^0.5
this->m_Formula.Add(_T("Q = 7.48 * A * (2*32.174*H)^0.5"));
this->m_Result_Unit.Add(_T("US gallons per minute"));
this->m_Input_parameter.Add(_T("A"));
this->m_Input_unit.Add(_T("Square feet"));
this->m_Input_parameter1.Add(_T("H"));
this->m_Input_unit1.Add(_T("feet"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Patch over hole"));
this->m_LongDesc.Add(_("Patch or cover thickness to withstand water pressure (patch over hole):\n\n\tT = square root of:\t(48x (H) (L2))/ 1000)\n\tT = thickness of wood or plywood patch\n\tH = height of water above bottom of hole\n\tL = length of patch, longest distance between supports"));
this->m_Category.Add(_("Safety"));
this->m_Source.Add(_("http://www.bootkeyharbor.com/Formulas.htm"));
this->m_Formula.Add(_T("T = sqrt( (48* H* (L^2))/1000)"));
this->m_Result_Unit.Add(_T("inch"));
this->m_Input_parameter.Add(_T("H"));
this->m_Input_unit.Add(_T("feet"));
this->m_Input_parameter1.Add(_T("L"));
this->m_Input_unit1.Add(_T("feet"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Line Break strength (circumference)"));
this->m_LongDesc.Add(_("Each type of line, natural fiber, synthetic and wire rope, have different breaking strengths and safe working loads. Natural breaking strength of manila line is the standard against which other lines are compared. Synthetic lines have been assigned comparison factors against which they are compared to manila line. The basic breaking strength factor for manila line is found by multiplying the square of the circumference of the line by 900 lbs. Knots and splices only have 50-60 percent of line strength.\n\nLine Material\tComparison Factor \nNylon\t\t\t2.5\nDacron\t\t\t2.0\nPolypropylene\t\t1.4\nManilla \t\t\t1.0"));
this->m_Category.Add(_("Safety"));
this->m_Source.Add(_("http://www.boatsafe.com/marlinespike/breaking.htm"));
this->m_Formula.Add(_T("breaking_strength= 900 * comparison_factor * circumference^2 "));
this->m_Result_Unit.Add(_T("lbs"));
this->m_Input_parameter.Add(_T("comparison_factor"));
this->m_Input_unit.Add(_T("See table"));
this->m_Input_parameter1.Add(_T("circumference"));
this->m_Input_unit1.Add(_T("inch"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Line Break strength (diameter)"));
this->m_LongDesc.Add(_("Each type of line, natural fiber, synthetic and wire rope, have different breaking strengths and safe working loads. Natural breaking strength of manila line is the standard against which other lines are compared. Synthetic lines have been assigned comparison factors against which they are compared to manila line. The basic breaking strength factor for manila line is found by multiplying the square of the circumference of the line by 900 lbs. Knots and splices only have 50-60 of line strenght.\n\nLine Material\tComparison Factor \nNylon\t\t\t2.5\nDacron\t\t\t2.0\nPolypropylene\t\t1.4\nManilla \t\t\t1.0"));
this->m_Category.Add(_("Safety"));
this->m_Source.Add(_("http://www.boatsafe.com/marlinespike/breaking.htm"));
this->m_Formula.Add(_T("breaking_strength= 900 * comparison_factor * (pi*diameter)^2 "));
this->m_Result_Unit.Add(_T("lbs"));
this->m_Input_parameter.Add(_T("comparison_factor"));
this->m_Input_unit.Add(_T("See table"));
this->m_Input_parameter1.Add(_T("diameter"));
this->m_Input_unit1.Add(_T("inch"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Velocity Made Good (angle)"));
this->m_LongDesc.Add(_("Velocity made good, or vmg, is a term in sailing, and specifically yacht racing, that refers to the component of a sailboats velocity that is in the direction of the true wind. The concept is useful in sailing, because a sailboat often cannot, or should not, sail directly to a mark to reach the mark as quickly as possible. Sailboats cannot sail directly upwind, and it is usually less than optimal, and sometimes dangerous, to sail directly downwind. Instead of sailing toward the mark, the helmsman chooses a point of sail that optimizes velocity made good."));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("https://en.wikipedia.org/wiki/Velocity_made_good"));
this->m_Formula.Add(_T("VMG=V*cos(alpha*dtr)"));
this->m_Result_Unit.Add(_T("Knots"));
this->m_Input_parameter.Add(_T("V"));
this->m_Input_unit.Add(_T("Knots"));
this->m_Input_parameter1.Add(_T("alpha"));
this->m_Input_unit1.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));
/*
this->m_ShortDesc.Add(_("Velocity Made Good (delta)"));
this->m_LongDesc.Add(_("Velocity made good, or vmg, is a term in sailing, and specifically yacht racing, that refers to the component of a sailboats velocity that is in the direction of the true wind. The concept is useful in sailing, because a sailboat often cannot, or should not, sail directly to a mark to reach the mark as quickly as possible. Sailboats cannot sail directly upwind, and it is usually less than optimal, and sometimes dangerous, to sail directly downwind. Instead of sailing toward the mark, the helmsman chooses a point of sail that optimizes velocity made good."));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("https://en.wikipedia.org/wiki/Velocity_made_good"));
this->m_Formula.Add(_T("VMG=V*cos((alpha1-alpha2)*dtr)"));
this->m_Result_Unit.Add(_T("Knots"));
this->m_Input_parameter.Add(_T("V"));
this->m_Input_unit.Add(_T("Knots"));
this->m_Input_parameter1.Add(_T("alpha1"));
this->m_Input_unit1.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter2.Add(_T("alpha2"));
this->m_Input_unit2.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));
*/
this->m_ShortDesc.Add(_("Wind Chill"));
this->m_LongDesc.Add(_("In November 2001 Canada, U.S. and U.K. implemented a new wind chill index developed by scientists and medical experts on the Joint Action Group for Temperature Indices (JAG/TI). It is determined by iterating a model of skin temperature under various wind speeds and temperatures using standard engineering correlations of wind speed and heat transfer rate. Heat transfer was calculated for a bare face in wind, facing the wind, while walking into it at 1.4 metre per second (3.1mph). The model corrects the officially measured wind speed (at 10 meter height) to the wind speed at face height, assuming the person is in an open field. The results of this model may be approximated, to within one degree, from the following formula:"));
this->m_Category.Add(_("Weather"));
this->m_Source.Add(_("http://en.wikipedia.org/wiki/Wind_chill, http://climate.weatheroffice.gc.ca/prods_servs/normals_documentation_e.html"));
this->m_Formula.Add(_T("T_wind_chill = 13.12 + 0.6215 * T_air - 11.37 * V_wind^0.16 + 0.3965 * T_air* V_wind^0.16 "));
this->m_Result_Unit.Add(_T("Celsius"));
this->m_Input_parameter.Add(_T("T_air"));
this->m_Input_unit.Add(_T("Celsius"));
this->m_Input_parameter1.Add(_T("V_wind"));
this->m_Input_unit1.Add(_T("m/s"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Humidex"));
this->m_LongDesc.Add(_("Humidex is an index to indicate how hot or humid the weather feels to the average person. It is derived by combining temperature and humidity values into one number to reflect the perceived temperature. For example, a humidex of 40 means that the sensation of heat when the temperature is 30 degrees and the air is humid feels more or less the same as when the temperature is 40 degrees and the air is dry. "));
this->m_Category.Add(_("Weather"));
this->m_Source.Add(_("http://climate.weather.gc.ca/glossary_e.html"));
this->m_Formula.Add(_T("humidex = (T_air) + (0.5555)*(((6.11 * (exp(5417.7530 * ((1 / 273.16) - (1 / dewpoint))))) - 10))"));
this->m_Result_Unit.Add(_T("Celsius"));
this->m_Input_parameter.Add(_T("T_air"));
this->m_Input_unit.Add(_T("Celsius"));
this->m_Input_parameter1.Add(_T("dewpoint"));
this->m_Input_unit1.Add(_T("Kelvin"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Beaufort to Wind Velocity"));
this->m_LongDesc.Add(_("Beaufort scale was created in 1805 by Sir Francis Beaufort, British admiral and hydrographer. It describes wind speed based mainly on observed sea conditions."));
this->m_Category.Add(_("Weather"));
this->m_Source.Add(_("http://planetcalc.com/384/"));
this->m_Formula.Add(_T("Wind_Speed=0.837*Beaufort^(3/2)"));
this->m_Result_Unit.Add(_T("m/s"));
this->m_Input_parameter.Add(_T("Beaufort"));
this->m_Input_unit.Add(_T("Beaufort"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Wind Velocity to Beaufort"));
this->m_LongDesc.Add(_("Beaufort scale was created in 1805 by Sir Francis Beaufort, British admiral and hydrographer. It describes wind speed based mainly on observed sea conditions."));
this->m_Category.Add(_("Weather"));
this->m_Source.Add(_("http://planetcalc.com/384/"));
this->m_Formula.Add(_T("Beaufort=(Wind_Speed/0.837)^(2/3)"));
this->m_Result_Unit.Add(_T("Beaufort"));
this->m_Input_parameter.Add(_T("Wind_Speed"));
this->m_Input_unit.Add(_T("m/s"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Pressure at depth"));
this->m_LongDesc.Add(_("If a fluid is within a container then the depth of an object placed in that fluid can be measured. The deeper the object is placed in the fluid, the more pressure it experiences. This is because is the weight of the fluid above it. The more dense the fluid above it, the more pressure is exerted on the object that is submerged, due to the weight of the fluid. Density is function of salinity and water temperature. Below are average values.\nDensity Sea Water = 1.035 kg/liter\nDensity Fresh Water = 1.0 kg/liter"));
this->m_Category.Add(_("Diving"));
this->m_Source.Add(_("http://www.grc.nasa.gov/WWW/k-12/WindTunnel/Activities/fluid_pressure.html\nSaltypaws"));
this->m_Formula.Add(_T("Pressure=density*9.80665*depth"));
this->m_Result_Unit.Add(_T("Pa"));
this->m_Input_parameter.Add(_T("density"));
this->m_Input_unit.Add(_T("kg/m3"));
this->m_Input_parameter1.Add(_T("depth"));
this->m_Input_unit1.Add(_T("meter"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Distance to horizon"));
this->m_LongDesc.Add(_("If the Earth is assumed to be a sphere with no atmosphere then the distance to the horizon can easily be calculated. (The Earths radius of curvature actually varies between the Equator and the Poles, so this formula isnt absolutely exact even assuming no refraction.) This formula assumes earth diameter of 12756.32 km."));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("https://en.wikipedia.org/wiki/Horizon#Exact_formula_for_a_spherical_Earth"));
this->m_Formula.Add(_T("distance_horizon=sqrt(height* (height + 12756.32))"));
this->m_Result_Unit.Add(_T("kilometer"));
this->m_Input_parameter.Add(_T("height"));
this->m_Input_unit.Add(_T("kilometer"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Objects above horizon"));
this->m_LongDesc.Add(_("To compute the greatest distance at which an observer can see the top of an object above the horizon, compute the distance to the horizon for a hypothetical observer on top of that object, and add it to the real observers distance to the horizon. This formula assumes earth diameter of 12 756.32 km."));
this->m_Category.Add(_("Navigation"));
this->m_Source.Add(_("https://en.wikipedia.org/wiki/Horizon, Objects above horizon"));
this->m_Formula.Add(_T("distance_visible=(sqrt(height_observer * (height_observer + 12756.32)) + sqrt(height_object * (height_object + 12756.32)))"));
this->m_Result_Unit.Add(_T("kilometer"));
this->m_Input_parameter.Add(_T("height_observer"));
this->m_Input_unit.Add(_T("kilometer"));
this->m_Input_parameter1.Add(_T("height_object"));
this->m_Input_unit1.Add(_T("kilometer"));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Distance"));
this->m_LongDesc.Add(_("Convert Distance"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Distance_Out=Distance_In"));
this->m_Result_Unit.Add(_T("meter"));
this->m_Input_parameter.Add(_T("Distance_In"));
this->m_Input_unit.Add(_T("meter"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Temperature"));
this->m_LongDesc.Add(_("Convert Temperature"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Temperature_Out=Temperature_In"));
this->m_Result_Unit.Add(_T("Celsius"));
this->m_Input_parameter.Add(_T("Temperature_In"));
this->m_Input_unit.Add(_T("Celsius"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Speed"));
this->m_LongDesc.Add(_("Convert Speed"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Speed_Out=Speed_In"));
this->m_Result_Unit.Add(_T("m/s"));
this->m_Input_parameter.Add(_T("Speed_In"));
this->m_Input_unit.Add(_T("m/s"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Pressure"));
this->m_LongDesc.Add(_("Convert Pressure"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Pressure_Out=Pressure_In"));
this->m_Result_Unit.Add(_T("bara"));
this->m_Input_parameter.Add(_T("Pressure_In"));
this->m_Input_unit.Add(_T("bara"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Angle"));
this->m_LongDesc.Add(_("Convert Angle"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Angle_Out=Angle_In"));
this->m_Result_Unit.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter.Add(_T("Angle_In"));
this->m_Input_unit.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));

this->m_ShortDesc.Add(_("Convert Flowrate"));
this->m_LongDesc.Add(_("Convert Flowrate"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Saltypaws"));
this->m_Formula.Add(_T("Flowrate_Out=Flowrate_In"));
this->m_Result_Unit.Add(_T("m3/s"));
this->m_Input_parameter.Add(_T("Flowrate_In"));
this->m_Input_unit.Add(_T("m3/s"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));


this->m_ShortDesc.Add(_("Convert Degrees (All formats)"));
this->m_LongDesc.Add(_("Convert (All formats)"));
this->m_Category.Add(_("Conversions"));
this->m_Source.Add(_("Rasbats"));
this->m_Formula.Add(_T("DegreesIn=DegreesOut"));
this->m_Result_Unit.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter.Add(_T("DegreesIn"));
this->m_Input_unit.Add(_T("Degree (\u00b0)"));
this->m_Input_parameter1.Add(_T(""));
this->m_Input_unit1.Add(_T(""));
this->m_Input_parameter2.Add(_T(""));
this->m_Input_unit2.Add(_T(""));
this->m_Input_parameter3.Add(_T(""));
this->m_Input_unit3.Add(_T(""));
this->m_Input_parameter4.Add(_T(""));
this->m_Input_unit4.Add(_T(""));
this->m_Input_parameter5.Add(_T(""));
this->m_Input_unit5.Add(_T(""));
this->m_Input_parameter6.Add(_T(""));
this->m_Input_unit6.Add(_T(""));
this->m_Input_parameter7.Add(_T(""));
this->m_Input_unit7.Add(_T(""));
this->m_Input_parameter8.Add(_T(""));
this->m_Input_unit8.Add(_T(""));
this->m_Input_parameter9.Add(_T(""));
this->m_Input_unit9.Add(_T(""));


 //End Class

}