/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.Negotiable;

public class NegotiableNumeric
implements Negotiable {
    Number number;
    Class elementClass;

    public NegotiableNumeric(byte b) {
        this.number = new Byte(b);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(short s) {
        this.number = new Short(s);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(int i) {
        this.number = new Integer(i);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(long l) {
        this.number = new Long(l);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(float f) {
        this.number = new Float(f);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(double d) {
        this.number = new Double(d);
        this.elementClass = this.number.getClass();
    }

    public NegotiableNumeric(Number n) {
        if (n == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableNumeric0"));
        }
        this.number = n;
        this.elementClass = this.number.getClass();
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public Negotiable negotiate(Negotiable other) {
        if (other == null) {
            return null;
        }
        if (!(other instanceof NegotiableNumeric) || other.getNegotiatedValueClass() != this.elementClass) {
            return null;
        }
        NegotiableNumeric otherNN = (NegotiableNumeric)other;
        if (this.number.equals(otherNN.getNumber())) {
            return new NegotiableNumeric(this.number);
        }
        return null;
    }

    @Override
    public Object getNegotiatedValue() {
        return this.number;
    }

    @Override
    public Class getNegotiatedValueClass() {
        return this.elementClass;
    }

    public byte getNegotiatedValueAsByte() {
        if (this.elementClass != Byte.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.byteValue();
    }

    public short getNegotiatedValueAsShort() {
        if (this.elementClass != Short.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.shortValue();
    }

    public int getNegotiatedValueAsInt() {
        if (this.elementClass != Integer.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.intValue();
    }

    public long getNegotiatedValueAsLong() {
        if (this.elementClass != Long.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.longValue();
    }

    public float getNegotiatedValueAsFloat() {
        if (this.elementClass != Float.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.floatValue();
    }

    public double getNegotiatedValueAsDouble() {
        if (this.elementClass != Double.class) {
            throw new ClassCastException(JaiI18N.getString("NegotiableNumeric1"));
        }
        return this.number.doubleValue();
    }
}

