/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceMenu;
import org.jvnet.substance.SubstanceMenuBackgroundDelegate;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.MenuColorDelegate;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceMenuUI
extends BasicMenuUI
implements SubstanceMenu {
    private static SubstanceMenuBackgroundDelegate backgroundDelegate = new SubstanceMenuBackgroundDelegate(1.0f);
    protected MouseListener substanceMouseListener;
    protected FadeStateListener substanceFadeStateListener;
    protected MenuUtilities.MenuPropertyListener substanceMenuPropertyListener;
    protected PropertyChangeListener substancePropertyListener;
    protected FocusListener substanceFocusListener;
    protected static Graphics graphics;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
        SubstanceTheme theme = SubstanceLookAndFeel.getTheme();
        SubstanceTheme titleTheme = SubstanceLookAndFeel.getTheme().getActiveTitlePaneTheme();
        ColorUIResource foregroundColor = new ColorUIResource(SubstanceColorUtilities.getForegroundColor(theme));
        ColorUIResource headerForegroundColor = new ColorUIResource(SubstanceColorUtilities.getForegroundColor(titleTheme));
        ColorUIResource backgroundColor = new ColorUIResource(SubstanceColorUtilities.getBackgroundColor(theme));
        ColorUIResource headerBackgroundColor = new ColorUIResource(SubstanceColorUtilities.getBackgroundColor(titleTheme));
        Color fg = this.menuItem.getForeground();
        if (fg instanceof UIResource) {
            this.menuItem.setForeground(new MenuColorDelegate(this.menuItem, headerForegroundColor, foregroundColor));
        }
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = new MenuColorDelegate(this.menuItem, headerBackgroundColor, backgroundColor);
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = new MenuColorDelegate(this.menuItem, headerForegroundColor, foregroundColor);
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = new MenuColorDelegate(this.menuItem, headerForegroundColor, foregroundColor);
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = new MenuColorDelegate(this.menuItem, headerForegroundColor, foregroundColor);
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = new MenuColorDelegate(this.menuItem, headerForegroundColor, foregroundColor);
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.substanceMenuPropertyListener = new MenuUtilities.MenuPropertyListener(this.menuItem);
        this.substanceMenuPropertyListener.install();
        this.substanceMouseListener = new MouseAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            public void mouseEntered(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(true);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }
        };
        this.menuItem.addMouseListener(this.substanceMouseListener);
        this.substanceFocusListener = new FocusAdapter(){

            private boolean toRepaint() {
                MenuElement[] selectedMenuPath;
                for (MenuElement elem : selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()) {
                    if (elem != SubstanceMenuUI.this.menuItem) continue;
                    return true;
                }
                return selectedMenuPath.length == 0;
            }

            public void focusLost(FocusEvent e) {
                if (this.toRepaint()) {
                    SubstanceMenuUI.this.menuItem.getModel().setRollover(false);
                    SubstanceMenuUI.this.menuItem.repaint();
                }
            }
        };
        this.menuItem.addFocusListener(this.substanceFocusListener);
        HashSet<FadeTracker.FadeKind> toIgnore = new HashSet<FadeTracker.FadeKind>();
        toIgnore.add(FadeTracker.FadeKind.SELECTION);
        this.substanceFadeStateListener = new FadeStateListener(this.menuItem, this.menuItem.getModel(), null, toIgnore);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceMenuUI.this.substanceFadeStateListener != null) {
                        SubstanceMenuUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceMenuUI.this.substanceFadeStateListener = new FadeStateListener(SubstanceMenuUI.this.menuItem, SubstanceMenuUI.this.menuItem.getModel(), null);
                    SubstanceMenuUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        this.menuItem.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.substanceMenuPropertyListener.uninstall();
        this.substanceMenuPropertyListener = null;
        this.menuItem.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.menuItem.removeFocusListener(this.substanceFocusListener);
        this.substanceFocusListener = null;
        this.menuItem.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        int textOffset = MenuUtilities.getTextOffset(g, menuItem);
        if (menuItem.getParent() instanceof JMenuBar) {
            textOffset = 0;
        }
        backgroundDelegate.paintBackground(g, menuItem, bgColor, true, textOffset);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        MenuUtilities.lineupTextRectangle(g, menuItem, textRect, this.defaultTextIconGap);
        super.paintText(g, menuItem, textRect, text);
    }

    public JMenuItem getAssociatedMenuItem() {
        return this.menuItem;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public Icon getCheckIcon() {
        return null;
    }

    public int getDefaultTextIconGap() {
        return this.defaultTextIconGap;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension superDim = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        SubstanceMenuUI ui = (SubstanceMenuUI)this.menuItem.getUI();
        int textOffset = MenuUtilities.getTextOffset(graphics, this.menuItem) - MenuUtilities.getTextOffset(graphics, this.menuItem, ui.getAcceleratorFont(), checkIcon, arrowIcon, defaultTextIconGap);
        return new Dimension(superDim.width + textOffset, superDim.height);
    }

    static {
        BufferedImage dummy = new BufferedImage(1, 1, 2);
        graphics = dummy.getGraphics();
    }
}

