//---------------------------------------------------------------------------------------
// This file is part of the Lomse library.
// Lomse is copyrighted work (c) 2010-2018. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice, this
//      list of conditions and the following disclaimer.
//
//    * Redistributions in binary form must reproduce the above copyright notice, this
//      list of conditions and the following disclaimer in the documentation and/or
//      other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
// SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
// ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// For any comment, suggestion or feature request, please contact the manager of
// the project at cecilios@users.sourceforge.net
//---------------------------------------------------------------------------------------

#ifndef __LOMSE_VIEW_H__
#define __LOMSE_VIEW_H__

#include "lomse_basic.h"


///@cond INTERNALS
namespace lomse
{
///@endcond

//forward declarations
class Interactor;

/** Class %View is an abstract class from which all views must derive

    In the <i>Model/View/Controller</i> (MVC) model, maintaining the necessary
    relationships between the @IM and the @GM is a responsibility of the %View.

    %View main responsibility is to render the @GM on a device.

    Also, the %View:
    - Knows how to transform physical into logical coordinates, and vice-versa.
    - Does not generate events. All %View related events are generated by the Interactor.

*/
class View
{
protected:
    Interactor* m_pInteractor;

public:
    virtual ~View();

    virtual void new_viewport(Pixels UNUSED(x), Pixels UNUSED(y)) {}
    virtual void get_viewport(Pixels* UNUSED(x), Pixels* UNUSED(y)) {}


///@cond INTERNALS

    inline void set_interactor(Interactor* pIntor) { m_pInteractor = pIntor; }


protected:
    View();

};


}   //namespace lomse
///@endcond

#endif      //__LOMSE_VIEW_H__
