# Contributing to LenMus

Thanks for taking the time to contribute!


#### Contribution agreement

By contributing to LenMus through pull-requests, comments,
or otherwise, you accept to release your contribution to the
license terms as described in the [LICENSE](https://github.com/lenmus/lenmus/blob/master/LICENSE).

LenMus uses a shared copyright model: each contributor holds copyright over
their contributions. The project versioning records all such
contribution and copyright details. If a contributor wants to further mark
their specific copyright on a particular contribution, they should indicate
their copyright solely in the commit message of the change when it is
committed.


## **Do you have questions about the project?**

Feel free to ask any question in the [lenmus forum](https://sourceforge.net/p/lenmus/discussion/). I always answer the posts.


## How can I contribute?

### Report bugs, propose new features or send feedback

If you encountered a bug, please tell about it. Go to the LenMus [issues page](https://github.com/lenmus/lenmus/issues) and create a new issue. Explain what you did and how you encountered it, and what happened afterwards. Most importantly, state how to go about and recreate the same error. Thank you!

I would like very much to know how you feel about the software and hear your suggestions for new exercises, improvements, etc. Please, go to the LenMus [issues page](https://github.com/lenmus/lenmus/issues) and create a new issue. Explain your ideas, suggestions and requests. Thank you!


### Music advice, art design, documentation

Not all tasks require programming. You can help in other ways such as designing icons, improving GUI layout, art design, music advice, texts for music books, designing new exercises, and improving or creating documentation. These issues are identified with the labels `art design`, `music advice` and `docs`. I not always open issues for these categories, but help in these areas is always welcome. Please, contact me if you don't find something suitable for you! Thank you.

* [Art design issues][art-design] - Issues related to art design and user interface design.
* [Music advice issues][music-advice] - Issues for which you can contribute as a musician: provide music advice and direction, create texts for music books, design new exercises, etc.
* [Documentation issues][docs] - Issues related to improving or writing documentation.



### Programming

Unsure where to begin contributing to LenMus? You can start by looking through these issues:

* [Beginner issues][beginner] - Issues labeled with `beginner` do not require deep knowledge of LenMus internals so they are suitable for start contributing with code to this project.
* [Help wanted issues][help-wanted] - To do or complete issues labeled as `help-wanted` I need help (advice, explanations or code) because I do not have enough knowledge for doing the task. Perhaps you have the knowledge and can help me!

If you would like to join this project, you are welcome. I'm currently the only developer, so I would like to find a few committed developers to create a core team. If you are interested and would like to take this project as your own project, you are welcome. The project has no commercial aim, so do not expect any money. I do this in my free time, for learning and for creating useful free software for the community. And costs me money!


### Translations

Currently there are no many available translations. But your collaboration is welcome to translate LenMus to your language. [Here](http://www.lenmus.org/en/phonascus/translation_instructions) you will find instructions. Thank you!


### Quality assurance

Use LenMus regularly and explore it in depth. Submit your feedback to improve the program and fix the bugs you find.


#### Thanks for contributing !!!!!!!


[beginner]:https://github.com/lenmus/lenmus/labels/beginner
[help-wanted]:https://github.com/lenmus/lenmus/labels/help%20wanted
[art-design]:https://github.com/lenmus/lenmus/labels/art%20design
[music-advice]:https://github.com/lenmus/lenmus/labels/music%20advice
[docs]:https://github.com/lenmus/lenmus/labels/docs


