--- a/gtk/gtkmenu.c
+++ b/gtk/gtkmenu.c
@@ -1398,7 +1398,7 @@
                   gboolean            flipped_y,
                   GtkMenu            *menu)
 {
-	GtkMenuPrivate *priv = menu->priv;
+  GtkMenuPrivate *priv = menu->priv;
 
   gtk_window_fixate_size (GTK_WINDOW (priv->toplevel));
 
@@ -2681,7 +2681,7 @@
   GtkMenuPrivate *priv;
 
   g_return_if_fail (GTK_IS_MENU (menu));
-  g_return_if_fail (GTK_IS_ACCEL_GROUP (accel_group));
+  g_return_if_fail (!accel_group || GTK_IS_ACCEL_GROUP (accel_group));
 
   priv = menu->priv;
 
@@ -2822,7 +2822,7 @@
 {
   GtkMenuPrivate *priv = menu->priv;
 
-  if (priv->accel_path && priv->accel_group)
+  if (priv->accel_path)
     {
       AccelPropagation prop;
 
@@ -5272,6 +5272,7 @@
    * the right place to popup the menu.
    */
   gtk_widget_realize (priv->toplevel);
+  gtk_window_move_resize (GTK_WINDOW (priv->toplevel));
 
   if (!gtk_widget_get_visible (priv->toplevel))
     gtk_window_set_type_hint (GTK_WINDOW (priv->toplevel), priv->menu_type_hint);
@@ -5291,7 +5292,7 @@
 
   g_signal_handlers_disconnect_by_func (toplevel, moved_to_rect_cb, menu);
 
-g_signal_connect (toplevel, "moved-to-rect", G_CALLBACK (moved_to_rect_cb),
+  g_signal_connect (toplevel, "moved-to-rect", G_CALLBACK (moved_to_rect_cb),
                     menu);
   priv->emulated_move_to_rect = emulated_move_to_rect;
 
@@ -5397,7 +5398,7 @@
           if (!priv->upper_arrow_visible || !priv->lower_arrow_visible)
             gtk_widget_queue_draw (GTK_WIDGET (menu));
 
-          if (!priv->upper_arrow_visible &
+          if (!priv->upper_arrow_visible &&
               flags & GTK_MENU_SCROLL_FLAG_ADAPT)
             should_offset_by_arrow = TRUE;
           else
--- a/gtk/gtkwindow.c
+++ b/gtk/gtkwindow.c
@@ -6439,7 +6439,7 @@
    * size of the window, so it's remembered.
    */
   priv->need_default_position = TRUE;
- 
+
   priv->fixate_size = FALSE;
 
   info = gtk_window_get_geometry_info (window, FALSE);
@@ -10483,6 +10483,22 @@
  * gtk_window_present:
  * @window: a #GtkWindow
  *
+ * Presents a window to the user. This function should not be used
+ * as when it is called, it is too late to gather a valid timestamp
+ * to allow focus stealing prevention to work correctly.
+ **/
+void
+gtk_window_present (GtkWindow *window)
+{
+  gtk_window_present_with_time (window, GDK_CURRENT_TIME);
+}
+
+/**
+ * gtk_window_present_with_time:
+ * @window: a #GtkWindow
+ * @timestamp: the timestamp of the user interaction (typically a 
+ *   button or key press event) which triggered this call
+ *
  * Presents a window to the user. This may mean raising the window
  * in the stacking order, deiconifying it, moving it to the current
  * desktop, and/or giving it the keyboard focus, possibly dependent
@@ -10490,33 +10506,18 @@
  *
  * If @window is hidden, this function calls gtk_widget_show()
  * as well.
- * 
+ *
  * This function should be used when the user tries to open a window
  * that’s already open. Say for example the preferences dialog is
  * currently open, and the user chooses Preferences from the menu
  * a second time; use gtk_window_present() to move the already-open dialog
  * where the user can see it.
  *
- * If you are calling this function in response to a user interaction,
- * it is preferable to use gtk_window_present_with_time().
- * 
- **/
-void
-gtk_window_present (GtkWindow *window)
-{
-  gtk_window_present_with_time (window, GDK_CURRENT_TIME);
-}
-
-/**
- * gtk_window_present_with_time:
- * @window: a #GtkWindow
- * @timestamp: the timestamp of the user interaction (typically a 
- *   button or key press event) which triggered this call
+ * Presents a window to the user in response to a user interaction. The
+ * timestamp should be gathered when the window was requested to be shown
+ * (when clicking a link for example), rather than once the window is
+ * ready to be shown.
  *
- * Presents a window to the user in response to a user interaction.
- * If you need to present a window without a timestamp, use 
- * gtk_window_present(). See gtk_window_present() for details. 
- * 
  * Since: 2.8
  **/
 void
@@ -10526,6 +10527,7 @@
   GtkWindowPrivate *priv;
   GtkWidget *widget;
   GdkWindow *gdk_window;
+  static gsize warned_current_time = FALSE;
 
   g_return_if_fail (GTK_IS_WINDOW (window));
 
@@ -10543,6 +10545,15 @@
       /* Translate a timestamp of GDK_CURRENT_TIME appropriately */
       if (timestamp == GDK_CURRENT_TIME)
         {
+	  if (g_once_init_enter (&warned_current_time))
+	    {
+	      gboolean warned = TRUE;
+	      g_warning ("gtk_window_present_with_time() should not be called with 0, or "
+			 "GDK_CURRENT_TIME as a timestamp, the timestamp should instead be "
+			 "gathered at the time the user initiated the request for the window "
+			 "to be shown");
+	      g_once_init_leave (&warned_current_time, warned);
+	    }
 #ifdef GDK_WINDOWING_X11
 	  if (GDK_IS_X11_WINDOW(gdk_window))
 	    {
@@ -12787,7 +12798,9 @@
 
   if (enable)
     {
+      G_GNUC_BEGIN_IGNORE_DEPRECATIONS
       gtk_window_present (GTK_WINDOW (inspector_window));
+      G_GNUC_END_IGNORE_DEPRECATIONS
       if (dialog)
         gtk_widget_show (dialog);
 
