; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -global-isel -O0 -mtriple=aarch64-- -stop-after=irtranslator -verify-machineinstrs -o - %s | FileCheck %s

define i64 @expect_i64(i64 %arg0) {
  ; CHECK-LABEL: name: expect_i64
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(s64) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s64) = COPY [[COPY]](s64)
  ; CHECK:   $x0 = COPY [[COPY1]](s64)
  ; CHECK:   RET_ReallyLR implicit $x0
  %expval = call i64 @llvm.expect.i64(i64 %arg0, i64 1)
  ret i64 %expval
}

define i8* @ptr_annotate(i8* %arg0, i8* %arg1, i8* %arg2, i32 %arg3) {
  ; CHECK-LABEL: name: ptr_annotate
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $w3, $x0, $x1, $x2
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p0) = COPY $x1
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY $x2
  ; CHECK:   [[COPY3:%[0-9]+]]:_(s32) = COPY $w3
  ; CHECK:   [[COPY4:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; CHECK:   $x0 = COPY [[COPY4]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %call = call i8* @llvm.ptr.annotation.p0i8(i8* %arg0, i8* %arg1, i8* %arg2, i32 %arg3, i8* null)
  ret i8* %call
}

@.str = private unnamed_addr constant [4 x i8] c"sth\00", section "llvm.metadata"
@.str1 = private unnamed_addr constant [4 x i8] c"t.c\00", section "llvm.metadata"

define i32 @annotation(i32 %a) {
  ; CHECK-LABEL: name: annotation
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $w0
  ; CHECK:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY [[COPY]](s32)
  ; CHECK:   $w0 = COPY [[COPY1]](s32)
  ; CHECK:   RET_ReallyLR implicit $w0
  %call = call i32 @llvm.annotation.i32(i32 %a, i8* getelementptr inbounds ([4 x i8], [4 x i8]* @.str, i32 0, i32 0), i8* getelementptr inbounds ([4 x i8], [4 x i8]* @.str1, i32 0, i32 0), i32 2)
  ret i32 %call
}

define i8* @launder_invariant_group(i8* %p) {
  ; CHECK-LABEL: name: launder_invariant_group
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; CHECK:   $x0 = COPY [[COPY1]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %q = call i8* @llvm.launder.invariant.group.p0i8(i8* %p)
  ret i8* %q
}

define i8* @strip_invariant_group(i8* %p) {
  ; CHECK-LABEL: name: strip_invariant_group
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[COPY1:%[0-9]+]]:_(p0) = COPY [[COPY]](p0)
  ; CHECK:   $x0 = COPY [[COPY1]](p0)
  ; CHECK:   RET_ReallyLR implicit $x0
  %q = call i8* @llvm.strip.invariant.group.p0i8(i8* %p)
  ret i8* %q
}

declare i64 @llvm.expect.i64(i64, i64) #0
declare i8* @llvm.ptr.annotation.p0i8(i8*, i8*, i8*, i32, i8*) #1
declare i32 @llvm.annotation.i32(i32, i8*, i8*, i32) #1
declare i8* @llvm.launder.invariant.group.p0i8(i8*) #2
declare i8* @llvm.strip.invariant.group.p0i8(i8*) #3

attributes #0 = { nounwind readnone willreturn }
attributes #1 = { nounwind willreturn }
attributes #2 = { inaccessiblememonly nounwind speculatable willreturn }
attributes #3 = { nounwind readnone speculatable willreturn }
