; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=fiji -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefix=GCN %s

define half @known_nnan_extract_vector_elt(float %a, float %b, i32 %idx, half %c) {
; GCN-LABEL: known_nnan_extract_vector_elt:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cvt_pkrtz_f16_f32 v0, v0, v1
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 4, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v0, v1, v0
; GCN-NEXT:    v_add_f16_e32 v1, 1.0, v3
; GCN-NEXT:    v_cmp_lt_f16_e32 vcc, v0, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cvt = call nnan <2 x half> @llvm.amdgcn.cvt.pkrtz(float %a, float %b)
  %extract = extractelement <2 x half> %cvt, i32 %idx
  %canon = call half @llvm.canonicalize.f16(half %extract)
  %nnan.c = fadd nnan nsz half %c, 1.0
  %cmp = fcmp olt half %extract, %nnan.c
  %select = select i1 %cmp, half %extract, half %nnan.c
  ret half %select
}

declare <2 x half> @llvm.amdgcn.cvt.pkrtz(float, float) #0
declare half @llvm.canonicalize.f16(half) #0
