/*
  Copyright © 2013 Frédéric Gaudet <fred@linuxmint.com>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of
  the License or (at your option) version 3 or any later version
  accepted by the membership of KDE e.V. (or its successor approved
  by the membership of KDE e.V.), which shall act as a proxy
  defined in Section 14 of version 3 of the license.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  
    Based on QT Graphics KCM module by Harald Sitter
    http://kde-apps.org/content/show.php/KCM+Qt+Graphics+System?content=129817
  
  
*/

#include "Module.h"
#include "ui_Module.h"

#include <QtCore/QFile>
#include <QtCore/QDir>
#include <QtGui/QPaintEngine>

#include <KAboutData>
#include <KPluginFactory>
#include <KStandardDirs>

#include "Version.h"
#include <krun.h>

K_PLUGIN_FACTORY_DECLARATION(KcmMintsourcesFactory);

Module::Module(QWidget *parent, const QVariantList &args) :
    KCModule(KcmMintsourcesFactory::componentData(), parent, args),
    ui(new Ui::Module)
{
    KAboutData *about = new KAboutData("mintsources", 0,
                                       ki18n("MintSources"),
                                       global_s_versionStringFull,
                                       ki18n("Configure MintSources"),
                                       KAboutData::License_GPL_V3,
                                       ki18n("Copyright 2013 Frédéric Gaudet"),
                                       KLocalizedString(), QByteArray(),
                                       "fred@linuxmint.com");

    about->addAuthor(ki18n("Frédéric Gaudet"), ki18n("Fred"), "fred@linuxmint.com");
    setAboutData(about);

    ui->setupUi(this);
    

    // We have no help so remove the button from the buttons.
    setButtons(buttons() ^ KCModule::Help);
}

Module::~Module()
{

    delete ui;
}

void Module::load()
{
   KRun::runCommand("/usr/bin/software-sources", this);

}

