/*  xfce4
 *  Copyright (C) 2002 Olivier Fourdan (fourdan@xfce.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gdk/gdk.h>
#include <gtk/gtktogglebutton.h>

#include "xfce_decortoggle.h"

#include "xfce_togglebutton.h"

/* Forward declarations */
static void xfce_togglebutton_toggle (GtkWidget * widget,
				      XfceTogglebutton * togglebutton);

/* Local data */
G_DEFINE_TYPE (XfceTogglebutton, xfce_togglebutton, GTK_TYPE_TOGGLE_BUTTON)

static void
xfce_togglebutton_class_init (XfceTogglebuttonClass * class)
{
}

static void
xfce_togglebutton_init (XfceTogglebutton * togglebutton)
{
    togglebutton->decortoggle = xfce_decortoggle_new (GTK_ARROW_LEFT);
    gtk_widget_show (togglebutton->decortoggle);
    gtk_container_add (GTK_CONTAINER (togglebutton),
		       togglebutton->decortoggle);
    g_signal_connect (G_OBJECT (togglebutton), "toggled",
		      G_CALLBACK (xfce_togglebutton_toggle), togglebutton);
}

GtkWidget *
xfce_togglebutton_new (GtkArrowType arrow_type)
{
    XfceTogglebutton *togglebutton;

    togglebutton = g_object_new (xfce_togglebutton_get_type (), NULL);
    xfce_decortoggle_set_arrow_type (XFCE_DECORTOGGLE
				     (togglebutton->decortoggle), arrow_type);
    return GTK_WIDGET (togglebutton);
}

static void
xfce_togglebutton_toggle (GtkWidget * widget, XfceTogglebutton * togglebutton)
{
    g_return_if_fail (togglebutton != NULL);
    g_return_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton));

    xfce_decortoggle_toggled (XFCE_DECORTOGGLE (togglebutton->decortoggle));
}

void
xfce_togglebutton_set_arrow_type (XfceTogglebutton * togglebutton,
				  GtkArrowType arrow_type)
{
    g_return_if_fail (togglebutton != NULL);
    g_return_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton));

    xfce_decortoggle_set_arrow_type (XFCE_DECORTOGGLE
				     (togglebutton->decortoggle), arrow_type);
}

GtkArrowType
xfce_togglebutton_get_arrow_type (XfceTogglebutton * togglebutton)
{
    g_return_val_if_fail (togglebutton != NULL, GTK_ARROW_LEFT);
    g_return_val_if_fail (XFCE_IS_TOGGLEBUTTON (togglebutton),
			  GTK_ARROW_LEFT);

    return
	xfce_decortoggle_get_arrow_type (XFCE_DECORTOGGLE
					 (togglebutton->decortoggle));
}
