import { Zcl } from "zigbee-herdsman";
import * as m from "../lib/modernExtend";
import type { KeyValue, ModernExtend, Range } from "../lib/types";
export declare const manufacturerOptions: {
    manufacturerCode: Zcl.ManufacturerCode;
};
export declare function ikeaLight(args?: Omit<m.LightArgs, "colorTemp"> & {
    colorTemp?: true | {
        range: Range;
        viaColor: true;
    };
}): ModernExtend;
export declare function ikeaBattery(): ModernExtend;
export declare function ikeaConfigureStyrbar(): ModernExtend;
export declare function ikeaConfigureRemote(): ModernExtend;
export declare function ikeaAirPurifier(): ModernExtend;
export declare function ikeaVoc(args?: Partial<m.NumericArgs<"manuSpecificIkeaVocIndexMeasurement", IkeaVocIndexMeasurement>>): ModernExtend;
export declare function ikeaConfigureGenPollCtrl(args?: {
    endpointId: number;
}): ModernExtend;
export declare function tradfriOccupancy(): ModernExtend;
export declare function tradfriRequestedBrightness(): ModernExtend;
export declare function tradfriCommandsOnOff(): ModernExtend;
export declare function tradfriCommandsLevelCtrl(): ModernExtend;
export declare function styrbarCommandOn(): ModernExtend;
export declare function ikeaDotsClick(args: {
    actionLookup?: KeyValue;
    dotsPrefix?: boolean;
    endpointNames: string[];
}): ModernExtend;
export declare function ikeaArrowClick(args?: {
    styrbar?: boolean;
    bind?: boolean;
}): ModernExtend;
export declare function ikeaMediaCommands(): ModernExtend;
export interface IkeaAirPurifier {
    attributes: {
        filterRunTime: number;
        replaceFilter: number;
        filterLifeTime: number;
        controlPanelLight: number;
        particulateMatter25Measurement: number;
        childLock: number;
        fanMode: number;
        fanSpeed: number;
        deviceRunTime: number;
    };
    commands: never;
    commandResponses: never;
}
export declare function addCustomClusterManuSpecificIkeaAirPurifier(): ModernExtend;
export interface IkeaVocIndexMeasurement {
    attributes: {
        measuredValue: number;
        measuredMinValue: number;
        measuredMaxValue: number;
    };
    commands: never;
    commandResponses: never;
}
export declare function addCustomClusterManuSpecificIkeaVocIndexMeasurement(): ModernExtend;
export declare function addCustomClusterManuSpecificIkeaSmartPlug(): ModernExtend;
export interface IkeaUnknown {
    attributes: never;
    commands: never;
    commandResponses: never;
}
export declare function addCustomClusterManuSpecificIkeaUnknown(): ModernExtend;
export declare const ikeaModernExtend: {
    smartPlugChildLock: (args?: Partial<m.BinaryArgs<"manuSpecificIkeaSmartPlug">>) => ModernExtend;
    smartPlugLedEnable: (args?: Partial<m.BinaryArgs<"manuSpecificIkeaSmartPlug">>) => ModernExtend;
};
//# sourceMappingURL=ikea.d.ts.map