/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Glacier2;

import com.zeroc.Glacier2.CannotCreateSessionException;
import com.zeroc.Glacier2.SessionControlPrx;
import com.zeroc.Glacier2.SessionPrx;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface SessionManager
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public SessionPrx create(String var1, SessionControlPrx var2, Current var3) throws CannotCreateSessionException;

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return SessionManager.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Glacier2::SessionManager";
    }

    public static CompletionStage<OutputStream> _iceD_create(SessionManager obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        SessionControlPrx iceP_control = SessionControlPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        inS.setFormat(FormatType.SlicedFormat);
        SessionPrx ret = obj.create(iceP_userId, iceP_control, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return SessionManager._iceD_create(this, in, current);
            }
            case 1: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 4: {
                return Object._iceD_ice_ping(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Glacier2::SessionManager", "::Ice::Object"};
        _iceOps = new String[]{"create", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    }
}

