/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AuthenticationException;

public abstract class Authenticator {
    private static final StringManager sm = StringManager.getManager(Authenticator.class);
    private static final Pattern pattern = Pattern.compile("(\\w+)\\s*=\\s*(\"([^\"]+)\"|([^,=\"]+))\\s*,?");

    @Deprecated
    public String getAuthorization(String string, String string2, Map<String, Object> map) throws AuthenticationException {
        return this.getAuthorization(string, string2, (String)map.get("org.apache.tomcat.websocket.WS_AUTHENTICATION_USER_NAME"), (String)map.get("org.apache.tomcat.websocket.WS_AUTHENTICATION_PASSWORD"), (String)map.get("org.apache.tomcat.websocket.WS_AUTHENTICATION_REALM"));
    }

    public abstract String getAuthorization(String var1, String var2, String var3, String var4, String var5) throws AuthenticationException;

    public abstract String getSchemeName();

    @Deprecated
    public Map<String, String> parseWWWAuthenticateHeader(String string) {
        return this.parseAuthenticateHeader(string);
    }

    public Map<String, String> parseAuthenticateHeader(String string) {
        Matcher matcher = pattern.matcher(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            hashMap.put(string2, string3 != null ? string3 : string4);
        }
        return hashMap;
    }

    protected void validateUsername(String string) throws AuthenticationException {
        if (string == null) {
            throw new AuthenticationException(sm.getString("authenticator.nullUserName"));
        }
    }

    protected void validatePassword(String string) throws AuthenticationException {
        if (string == null) {
            throw new AuthenticationException(sm.getString("authenticator.nullPassword"));
        }
    }

    protected void validateRealm(String string, String string2) throws AuthenticationException {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (string2 != null && string.equals(string2 = string2.trim())) {
            return;
        }
        throw new AuthenticationException(sm.getString("authenticator.realmMismatch", new Object[]{string, string2}));
    }
}

