/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import org.slf4j.Logger;
import org.zeroturnaround.exec.MessageLogger;
import org.zeroturnaround.exec.stream.slf4j.Level;

public class MessageLoggers {
    public static final MessageLogger NOP = new MessageLogger(){

        @Override
        public void message(Logger log2, String format2, Object ... arguments2) {
        }
    };
    public static final MessageLogger TRACE = new MessageLogger(){

        @Override
        public void message(Logger log2, String format2, Object ... arguments2) {
            log2.trace(format2, arguments2);
        }
    };
    public static final MessageLogger DEBUG = new MessageLogger(){

        @Override
        public void message(Logger log2, String format2, Object ... arguments2) {
            log2.debug(format2, arguments2);
        }
    };
    public static final MessageLogger INFO = new MessageLogger(){

        @Override
        public void message(Logger log2, String format2, Object ... arguments2) {
            log2.info(format2, arguments2);
        }
    };

    public static final MessageLogger get(Level level) {
        switch (level) {
            case TRACE: {
                return TRACE;
            }
            case DEBUG: {
                return DEBUG;
            }
            case INFO: {
                return INFO;
            }
        }
        throw new IllegalArgumentException("Invalid level " + (Object)((Object)level));
    }

    private MessageLoggers() {
    }
}

