/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.interleaving;

import org.apache.lucene.search.ScoreDoc;
import org.apache.solr.common.SolrException;
import org.apache.solr.ltr.interleaving.InterleavingResult;
import org.apache.solr.ltr.interleaving.algorithms.TeamDraftInterleaving;

public interface Interleaving {
    public static final String TEAM_DRAFT = "TeamDraft";

    public InterleavingResult interleave(ScoreDoc[] var1, ScoreDoc[] var2);

    public static Interleaving getImplementation(String algorithm) {
        switch (algorithm) {
            case "TeamDraft": {
                return new TeamDraftInterleaving();
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Interleaving algorithm: " + algorithm);
    }
}

