/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TalismanOfForesight;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.watabou.utils.Bundle;
import com.watabou.utils.PointF;

public class VaultMob
extends Mob {
    private int previousPos;
    private static final String PREV_POS = "prev_pos";
    private static final String INVEST_TURNS = "invest_turns";
    private static final String WANDER_POSITIONS = "wander_positions";
    private static final String WANDER_POS_IDX = "wander_pos_idx";
    private int investigatingTurns;
    public int wanderPosIdx;
    public int[] wanderPositions;

    public VaultMob() {
        this.WANDERING = new Wandering();
        this.INVESTIGATING = new Investigating();
        this.state = this.SLEEPING = new Sleeping();
        this.previousPos = -1;
        this.wanderPosIdx = 0;
    }

    @Override
    public void move(int step, boolean travelling) {
        this.previousPos = this.pos;
        super.move(step, travelling);
        if (travelling && !this.sprite.visible && Dungeon.level.distance(this.pos, Dungeon.hero.pos) <= 6) {
            if (this.state == this.HUNTING) {
                WandOfBlastWave.BlastWave.blast(this.pos, 1.0f, 0xFF0000);
            } else if (this.state == this.INVESTIGATING) {
                WandOfBlastWave.BlastWave.blast(this.pos, 1.0f, 0xFF8800);
            } else {
                WandOfBlastWave.BlastWave.blast(this.pos, 1.0f);
            }
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(PREV_POS, this.previousPos);
        bundle.put(INVEST_TURNS, this.investigatingTurns);
        if (this.wanderPositions != null) {
            bundle.put(WANDER_POSITIONS, this.wanderPositions);
            bundle.put(WANDER_POS_IDX, this.wanderPosIdx);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.previousPos = bundle.getInt(PREV_POS);
        this.investigatingTurns = bundle.getInt(INVEST_TURNS);
        if (bundle.contains(WANDER_POSITIONS)) {
            this.wanderPositions = bundle.getIntArray(WANDER_POSITIONS);
            this.wanderPosIdx = bundle.getInt(WANDER_POS_IDX);
        }
    }

    public class Wandering
    extends Mob.Wandering {
        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            return super.act(enemyInFOV, justAlerted);
        }

        @Override
        protected float detectionChance(Char enemy) {
            if (!Dungeon.level.adjacent(VaultMob.this.pos, VaultMob.this.previousPos)) {
                return 1.0f / ((float)VaultMob.this.distance(enemy) + enemy.stealth());
            }
            float movementDir = PointF.angle(Dungeon.level.cellToPoint(VaultMob.this.previousPos), Dungeon.level.cellToPoint(VaultMob.this.pos)) / ((float)Math.PI / 180);
            float enemyDir = PointF.angle(Dungeon.level.cellToPoint(VaultMob.this.pos), Dungeon.level.cellToPoint(enemy.pos)) / ((float)Math.PI / 180);
            if (Math.abs(enemyDir - movementDir) <= 45.0f) {
                return 1.0f / ((float)VaultMob.this.distance(enemy) / 2.0f + enemy.stealth());
            }
            if (Math.abs(enemyDir - movementDir) < 90.0f) {
                return 1.0f / ((float)VaultMob.this.distance(enemy) + enemy.stealth());
            }
            float chance = 1.0f / (float)Math.pow((float)VaultMob.this.distance(enemy) + enemy.stealth(), 3.0);
            if (chance < 0.1f) {
                return 0.0f;
            }
            return chance;
        }

        @Override
        protected boolean noticeEnemy() {
            super.noticeEnemy();
            VaultMob.this.alerted = false;
            VaultMob.this.state = VaultMob.this.INVESTIGATING;
            VaultMob.this.investigatingTurns = 0;
            VaultMob.this.sprite.showInvestigate();
            VaultMob.this.spend(1.0f);
            if (!Dungeon.level.heroFOV[VaultMob.this.pos]) {
                Buff.affect((Char)Dungeon.hero, TalismanOfForesight.CharAwareness.class, (float)1.0f).charID = VaultMob.this.id();
            }
            return true;
        }

        @Override
        protected int randomDestination() {
            int wanderPos;
            if (VaultMob.this.wanderPositions == null) {
                VaultMob.this.wanderPositions = new int[1];
                VaultMob.this.wanderPositions[0] = VaultMob.this.pos;
            }
            if ((wanderPos = VaultMob.this.wanderPositions[VaultMob.this.wanderPosIdx]) == VaultMob.this.pos) {
                if (VaultMob.this.wanderPositions.length > 1) {
                    ++VaultMob.this.wanderPosIdx;
                    if (VaultMob.this.wanderPosIdx == VaultMob.this.wanderPositions.length) {
                        VaultMob.this.wanderPosIdx = 0;
                    }
                    wanderPos = VaultMob.this.wanderPositions[VaultMob.this.wanderPosIdx];
                } else {
                    VaultMob.this.previousPos = VaultMob.this.pos;
                    VaultMob.this.sprite.idle();
                }
            }
            return wanderPos;
        }
    }

    public class Investigating
    extends Mob.Investigating {
        @Override
        public boolean act(boolean enemyInFOV, boolean justAlerted) {
            VaultMob.this.investigatingTurns = enemyInFOV ? ++VaultMob.this.investigatingTurns : 0;
            return super.act(enemyInFOV, justAlerted);
        }

        @Override
        protected float detectionChance(Char enemy) {
            float chance = 1.0f / ((float)VaultMob.this.distance(enemy) / 2.0f + enemy.stealth());
            if (VaultMob.this.investigatingTurns == 1 && chance <= 1.0f) {
                chance -= 0.33f;
            }
            return chance;
        }
    }

    public class Sleeping
    extends Mob.Sleeping {
        @Override
        protected void awaken(boolean enemyInFOV) {
            super.awaken(enemyInFOV);
            if (VaultMob.this.wanderPositions == null) {
                VaultMob.this.wanderPositions = new int[1];
                VaultMob.this.wanderPositions[0] = VaultMob.this.pos;
            }
            if (VaultMob.this.state == VaultMob.this.HUNTING) {
                VaultMob.this.alerted = false;
                VaultMob.this.state = VaultMob.this.INVESTIGATING;
                VaultMob.this.investigatingTurns = 0;
                VaultMob.this.sprite.showInvestigate();
                if (!Dungeon.level.heroFOV[VaultMob.this.pos]) {
                    Buff.affect((Char)Dungeon.hero, TalismanOfForesight.CharAwareness.class, (float)1.0f).charID = VaultMob.this.id();
                }
            }
        }

        @Override
        protected float detectionChance(Char enemy) {
            float chance = 1.0f / (float)Math.pow((float)VaultMob.this.distance(enemy) + enemy.stealth(), 2.0);
            if (chance < 0.1f) {
                return 0.0f;
            }
            return chance;
        }
    }
}

