/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.json.DupDetector;

public class SimpleStreamReadContext
extends TokenStreamContext {
    protected final SimpleStreamReadContext _parent;
    protected DupDetector _dups;
    protected SimpleStreamReadContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected int _lineNr;
    protected int _columnNr;

    public SimpleStreamReadContext(int type, SimpleStreamReadContext parent, int nestingDepth, DupDetector dups, int lineNr, int colNr) {
        this._parent = parent;
        this._nestingDepth = nestingDepth;
        this._dups = dups;
        this._type = type;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
    }

    @Deprecated
    public SimpleStreamReadContext(int type, SimpleStreamReadContext parent, DupDetector dups, int lineNr, int colNr) {
        this._parent = parent;
        this._dups = dups;
        this._type = type;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
        this._nestingDepth = -1;
    }

    protected void reset(int type, int lineNr, int colNr) {
        this._type = type;
        this._currentValue = null;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
        this._currentName = null;
        if (this._dups != null) {
            this._dups.reset();
        }
    }

    @Override
    public Object currentValue() {
        return this._currentValue;
    }

    @Override
    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static SimpleStreamReadContext createRootContext(int lineNr, int colNr, DupDetector dups) {
        return new SimpleStreamReadContext(0, null, 0, dups, lineNr, colNr);
    }

    public static SimpleStreamReadContext createRootContext(DupDetector dups) {
        return SimpleStreamReadContext.createRootContext(1, 0, dups);
    }

    public SimpleStreamReadContext createChildArrayContext(int lineNr, int colNr) {
        SimpleStreamReadContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleStreamReadContext(1, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), lineNr, colNr);
        } else {
            ctxt.reset(1, lineNr, colNr);
        }
        return ctxt;
    }

    public SimpleStreamReadContext createChildObjectContext(int lineNr, int colNr) {
        SimpleStreamReadContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleStreamReadContext(2, this, this._nestingDepth + 1, this._dups == null ? null : this._dups.child(), lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(2, lineNr, colNr);
        return ctxt;
    }

    @Override
    public String currentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    @Override
    public SimpleStreamReadContext getParent() {
        return this._parent;
    }

    @Override
    public TokenStreamLocation startLocation(ContentReference srcRef) {
        long totalChars = -1L;
        return new TokenStreamLocation(srcRef, totalChars, this._lineNr, this._columnNr);
    }

    public SimpleStreamReadContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public int valueRead() {
        return ++this._index;
    }

    public void setCurrentName(String name) throws StreamReadException {
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
    }

    protected void _checkDup(DupDetector dd, String name) throws StreamReadException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new StreamReadException(src instanceof JsonParser ? (JsonParser)src : null, "Duplicate Object property \"" + name + "\"");
        }
    }
}

