/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import com.oracle.common.base.Disposable;
import com.oracle.common.internal.net.ipclw.mql.AtomicBuffers;
import com.oracle.common.internal.net.ipclw.mql.Context;
import com.oracle.common.internal.net.ipclw.mql.KeyedBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.KeyedSingleBufferSequence;
import com.oracle.common.internal.net.ipclw.mql.RegistrationKey;
import com.oracle.common.internal.net.ipclw.mql.RemoteQueue;
import com.oracle.common.io.BufferSequence;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

public class MQLFlowControl {
    private RemoteQueue remoteQueue;
    private ByteBuffer localFCB;
    private RegistrationKey localFCBKey;
    private ByteBuffer writeBuffer;
    private KeyedBufferSequence writeBufferSeq;
    private RegistrationKey remoteFCBKey;
    private short localBufferPostCount;
    private short availableRcvBuffers;
    private short remoteBufferPostCount;
    private byte localIRCount;
    private byte remoteIRCount;
    private boolean receivedIR = false;
    private BufferSequence interrupt;
    private boolean rdmaPending = false;
    private Disposable cookie = new Disposable(){
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        public void dispose() {
            MQLFlowControl.this.rdmaPending = false;
        }

        static {
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(MQLFlowControl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("dispose", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    };
    private short lastCountSent = 0;
    static final int USR_WRITE_WAIT = 5000;
    static final int SYS_WRITE_WAIT = 0;
    static final int USR_PENDING_WAIT = 5000;
    static final int SYS_PENDING_WAIT = 0;
    static final int FCB_SIZE = 8;
    static final int OFFSET_SHORT_BUFFER_COUNT = 0;
    static final int BUFFER_COUNT_SIZE = 2;
    static final int OFFSET_BYTE_INTERRUPT_REQUEST = 2;
    static final int INTERRUPT_REQUEST_SIZE = 1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    public MQLFlowControl(Context localQueueContext, Context keyRegistryContext) throws IOException {
        this.initLocalFCB(localQueueContext);
        this.initWriteBuffer(keyRegistryContext);
    }

    private void initLocalFCB(Context localQueueContext) throws IOException {
        this.localFCB = ByteBuffer.allocateDirect(8);
        this.localFCB.order(ByteOrder.nativeOrder());
        this.localFCB.clear();
        this.localFCBKey = localQueueContext.register(this.localFCB);
        this.localFCB.clear();
    }

    private void initWriteBuffer(Context keyRegContext) throws IOException {
        this.writeBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
        RegistrationKey key = keyRegContext.register(this.writeBuffer);
        this.writeBufferSeq = new KeyedSingleBufferSequence(null, this.writeBuffer, keyRegContext, key);
    }

    protected RegistrationKey getLocalFCBKey() {
        return this.localFCBKey;
    }

    protected void resetLocalFCB() {
        this.localFCB.clear();
        while (this.localFCB.hasRemaining()) {
            this.localFCB.put((byte)0);
        }
        this.localFCB.clear();
    }

    protected void onFlowControlEnabled(short initialBufferPostCount, ByteBuffer keyBuffer, long addr, RemoteQueue remoteQueue, BufferSequence interrupt) throws IOException {
        this.remoteQueue = remoteQueue;
        this.interrupt = interrupt;
        this.localFCB.putShort(0, initialBufferPostCount);
        this.availableRcvBuffers = initialBufferPostCount;
        this.remoteBufferPostCount = initialBufferPostCount;
        this.remoteFCBKey = new RegistrationKey(keyBuffer, addr, 8L);
        this.writeRemoteFCB(true);
    }

    private short readRemoteBufferPostCount() {
        short rdmaCounter;
        long fcbBytes;
        do {
            fcbBytes = this.localFCB.getLong(0);
            rdmaCounter = this.localFCB.getShort(0);
        } while (fcbBytes != AtomicBuffers.getAndAdd((ByteBuffer)this.localFCB, (int)0, (long)0L));
        return rdmaCounter;
    }

    private boolean isInterruptRequested() {
        byte rdmaCounter;
        long fcbBytes;
        do {
            fcbBytes = this.localFCB.getLong(0);
            rdmaCounter = this.localFCB.get(2);
        } while (fcbBytes != AtomicBuffers.getAndAdd((ByteBuffer)this.localFCB, (int)0, (long)0L));
        if ((byte)(rdmaCounter - this.remoteIRCount) > 0) {
            this.remoteIRCount = rdmaCounter;
            return true;
        }
        return false;
    }

    public void sendCounterUpdate() throws IOException {
        while (this.needToUpdate()) {
            this.writeRemoteFCB(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onBufferPosted(int n2) {
        block3: {
            void nPosted;
            boolean bl;
            boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
            if (nPosted <= 0) {
                return;
            }
            this.localBufferPostCount = (short)(this.localBufferPostCount + nPosted);
            try {
                this.writeRemoteFCB(false, false);
            }
            catch (IOException e2) {
                if (!bl) break block3;
                this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "Error attempting schedule RDMA write");
            }
        }
    }

    private void writeRemoteFCB(boolean awaitWork) throws IOException {
        this.writeRemoteFCB(awaitWork, true);
    }

    private boolean writeRemoteFCB(boolean awaitWork, boolean canAwait) throws IOException {
        if (this.rdmaPending) {
            if (canAwait) {
                while (this.remoteQueue.isWorkPending()) {
                    this.remoteQueue.getContext().await(5000, 0);
                }
            } else {
                return false;
            }
        }
        this.writeBuffer.putShort(0, this.localBufferPostCount);
        this.writeBuffer.put(2, this.localIRCount);
        short lastLastCountSent = this.lastCountSent;
        this.lastCountSent = this.localBufferPostCount;
        BufferSequence iMsg = null;
        if (this.receivedIR) {
            iMsg = this.interrupt;
            this.receivedIR = false;
        }
        this.rdmaPending = true;
        if (canAwait) {
            while (!this.remoteQueue.write(this.remoteFCBKey, 0L, this.writeBufferSeq, iMsg, (Object)this.cookie, 1)) {
                this.remoteQueue.getContext().await(5000, 0);
            }
            if (awaitWork) {
                while (this.remoteQueue.isWorkPending()) {
                    this.remoteQueue.getContext().await(5000, 0);
                }
            }
        } else if (!this.remoteQueue.write(this.remoteFCBKey, 0L, this.writeBufferSeq, iMsg, (Object)this.cookie, 1)) {
            this.receivedIR = iMsg != null;
            this.lastCountSent = lastLastCountSent;
            this.rdmaPending = false;
            return false;
        }
        return true;
    }

    public boolean needToUpdate() {
        return this.receivedIR || this.localBufferPostCount > this.lastCountSent || this.rdmaPending;
    }

    protected boolean sendInterruptRequest(boolean canAwait) throws IOException {
        this.localIRCount = (byte)(this.localIRCount + 1);
        if (this.writeRemoteFCB(true, canAwait)) {
            return true;
        }
        this.localIRCount = (byte)(this.localIRCount - 1);
        return false;
    }

    public byte getInterruptRequestCount() {
        return this.localIRCount;
    }

    protected int getAvailableBufferCount() {
        short prevPostCount = this.remoteBufferPostCount;
        this.remoteBufferPostCount = this.readRemoteBufferPostCount();
        this.availableRcvBuffers = (short)(this.availableRcvBuffers + (short)(this.remoteBufferPostCount - prevPostCount));
        return this.availableRcvBuffers;
    }

    protected void onMessageSent() {
        this.availableRcvBuffers = (short)(this.availableRcvBuffers - 1);
    }

    protected void onMessageReceived() {
        if (this.isInterruptRequested()) {
            this.receivedIR = true;
        }
    }

    protected void onIRMessage(byte msgCounter) {
        if ((byte)(msgCounter - this.remoteIRCount) > 0) {
            this.remoteIRCount = msgCounter;
            this.receivedIR = true;
        }
    }

    protected void setLocalPostCount(short count) {
        this.localBufferPostCount = count;
    }

    protected int getLocalPostCount() {
        return this.localBufferPostCount;
    }

    /*
     * WARNING - void declaration
     */
    public void onDisconnect(Context context) {
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (this.localFCB != null) {
            block5: {
                try {
                    void localQueueContext;
                    localQueueContext.unregister(this.localFCBKey);
                }
                catch (IOException e2) {
                    if (!bl) break block5;
                    this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "Failed to unregister the memory region used for the local FCB");
                }
            }
            this.localFCB = null;
        }
        if (this.writeBufferSeq != null) {
            this.writeBufferSeq.dispose();
            this.writeBufferSeq = null;
        }
        if (this.interrupt != null) {
            this.interrupt.dispose();
        }
    }

    public String toString() {
        return "Local Counter = " + this.localBufferPostCount + "Local Counter Last Written = " + this.lastCountSent + " Remote Counter Last Read = " + this.remoteBufferPostCount + " Current Remote Counter = " + this.readRemoteBufferPostCount() + " Remote Available Receive Buffers = " + this.availableRcvBuffers + " Interrupt Requested = " + this.isInterruptRequested();
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$22 = MQLFlowControl.class.getDeclaredConstructor(Context.class, Context.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = MQLFlowControl.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = MQLFlowControl.class.getDeclaredMethod("onDisconnect", Context.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = MQLFlowControl.class.getDeclaredMethod("getLocalPostCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = MQLFlowControl.class.getDeclaredMethod("setLocalPostCount", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = MQLFlowControl.class.getDeclaredMethod("onIRMessage", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = MQLFlowControl.class.getDeclaredMethod("onMessageReceived", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = MQLFlowControl.class.getDeclaredMethod("onMessageSent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = MQLFlowControl.class.getDeclaredMethod("getAvailableBufferCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = MQLFlowControl.class.getDeclaredMethod("getInterruptRequestCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = MQLFlowControl.class.getDeclaredMethod("sendInterruptRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = MQLFlowControl.class.getDeclaredMethod("needToUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = MQLFlowControl.class.getDeclaredMethod("writeRemoteFCB", Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = MQLFlowControl.class.getDeclaredMethod("writeRemoteFCB", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = MQLFlowControl.class.getDeclaredMethod("onBufferPosted", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = MQLFlowControl.class.getDeclaredMethod("sendCounterUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = MQLFlowControl.class.getDeclaredMethod("isInterruptRequested", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = MQLFlowControl.class.getDeclaredMethod("readRemoteBufferPostCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = MQLFlowControl.class.getDeclaredMethod("onFlowControlEnabled", Short.TYPE, ByteBuffer.class, Long.TYPE, RemoteQueue.class, BufferSequence.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = MQLFlowControl.class.getDeclaredMethod("resetLocalFCB", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = MQLFlowControl.class.getDeclaredMethod("getLocalFCBKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = MQLFlowControl.class.getDeclaredMethod("initWriteBuffer", Context.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = MQLFlowControl.class.getDeclaredMethod("initLocalFCB", Context.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

