/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Objects;
import schemacrawler.ermodel.implementation.AbstractDatabaseObjectBacked;
import schemacrawler.ermodel.model.Entity;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.ermodel.model.TableReferenceRelationship;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;

final class MutableTableReferenceRelationship
extends AbstractDatabaseObjectBacked<TableReference>
implements TableReferenceRelationship {
    private static final long serialVersionUID = 3561028568798848133L;
    private RelationshipCardinality cardinality = RelationshipCardinality.unknown;
    private Entity leftEntity;
    private Entity rightEntity;

    public MutableTableReferenceRelationship(TableReference tableReference) {
        super(tableReference);
    }

    @Override
    public Entity getLeftEntity() {
        return this.leftEntity;
    }

    @Override
    public Entity getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public TableReference getTableReference() {
        return (TableReference)this.getDatabaseObject();
    }

    @Override
    public RelationshipCardinality getType() {
        return this.cardinality;
    }

    void setCardinality(RelationshipCardinality cardinality) {
        if (cardinality != null) {
            this.cardinality = cardinality;
        }
    }

    void setEntities(Entity leftEntity, Entity rightEntity) {
        this.leftEntity = Objects.requireNonNull(leftEntity, "No left entity provided");
        if (!leftEntity.key().equals(this.getTableReference().getForeignKeyTable().key())) {
            throw new ExecutionRuntimeException("Table reference left key does not match");
        }
        this.rightEntity = Objects.requireNonNull(rightEntity, "No right entity provided");
        if (!rightEntity.key().equals(this.getTableReference().getPrimaryKeyTable().key())) {
            throw new ExecutionRuntimeException("Table reference right key does not match");
        }
    }
}

