/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltins;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttrNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={SpecialMethodNames.class, PGuards.class})
public abstract class PyObjectLookupAttr
extends Node {
    public static Object executeUncached(Object receiver, TruffleString name) {
        return PyObjectLookupAttrNodeGen.getUncached().execute(null, null, receiver, name);
    }

    public final Object executeCached(Frame frame, Object receiver, TruffleString name) {
        return this.execute(frame, this, receiver, name);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3, TruffleString var4);

    protected static boolean hasNoGetAttr(Object lazyClass) {
        return LookupAttributeInMRONode.Dynamic.getUncached().execute(lazyClass, SpecialMethodNames.T___GETATTR__) == PNone.NO_VALUE;
    }

    protected static boolean getAttributeIs(Node inliningTarget, TpSlots.GetCachedTpSlotsNode getSlotsNode, Object lazyClass, TpSlot slot) {
        TpSlots slots = getSlotsNode.execute(inliningTarget, lazyClass);
        return slots.tp_getattro() == slot;
    }

    protected static boolean isObjectGetAttribute(Node inliningTarget, TpSlots.GetCachedTpSlotsNode getSlotsNode, Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(inliningTarget, getSlotsNode, lazyClass, ObjectBuiltins.SLOTS.tp_getattro());
    }

    protected static boolean isModuleGetAttribute(Node inliningTarget, TpSlots.GetCachedTpSlotsNode getSlotsNode, Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(inliningTarget, getSlotsNode, lazyClass, ModuleBuiltins.SLOTS.tp_getattro());
    }

    protected static boolean isTypeGetAttribute(Node inliningTarget, TpSlots.GetCachedTpSlotsNode getSlotsNode, Object lazyClass) {
        return PyObjectLookupAttr.getAttributeIs(inliningTarget, getSlotsNode, lazyClass, TypeBuiltins.SLOTS.tp_getattro());
    }

    protected static boolean isBuiltinTypeType(Object type) {
        return type == PythonBuiltinClassType.PythonClass;
    }

    protected static boolean isTypeSlot(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return TpSlots.canBeSpecialMethod(name, codePointLengthNode, codePointAtIndexNode) || name.equalsUncached((AbstractTruffleString)SpecialMethodNames.T_MRO, PythonUtils.TS_ENCODING);
    }

    @Specialization(guards={"isObjectGetAttribute(inliningTarget, getSlotsNode, type)", "name == cachedName", "isNoValue(descr)"}, limit="3")
    static Object doBuiltinObject(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getSlotsNode, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)") LookupAttributeInMRONode lookupName, @Bind(value="lookupName.execute(type)") Object descr, @Cached.Shared @Cached(inline=false) ReadAttributeFromObjectNode readNode) {
        assert (PyObjectLookupAttr.hasNoGetAttr(type));
        return readNode.execute(object, cachedName);
    }

    @Specialization(guards={"isModuleGetAttribute(inliningTarget, getSlotsNode, type)", "name == cachedName", "isNoValue(descr)"}, limit="1")
    static Object doBuiltinModule(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getSlotsNode, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)") LookupAttributeInMRONode lookupName, @Bind(value="lookupName.execute(type)") Object descr, @Cached.Shared @Cached(inline=false) ReadAttributeFromObjectNode readNode, @Cached.Exclusive @Cached(inline=false) ReadAttributeFromObjectNode readGetattr, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached InlinedConditionProfile noValueFound, @Cached(inline=false) CallNode callGetattr) {
        assert (PyObjectLookupAttr.hasNoGetAttr(type));
        Object value = readNode.execute(object, cachedName);
        if (noValueFound.profile(inliningTarget, value == PNone.NO_VALUE)) {
            Object getAttr = readGetattr.execute(object, SpecialMethodNames.T___GETATTR__);
            if (getAttr != PNone.NO_VALUE) {
                try {
                    return callGetattr.execute((Frame)frame, getAttr, name);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                    return PNone.NO_VALUE;
                }
            }
            return PNone.NO_VALUE;
        }
        return value;
    }

    @Specialization(guards={"isTypeGetAttribute(inliningTarget, getTypeSlotsNode, type)", "isBuiltinTypeType(type)", "!isTypeSlot(name, codePointLengthNode, codePointAtIndexNode)"}, limit="1")
    static Object doBuiltinTypeType(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getTypeSlotsNode, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(inline=false) LookupAttributeInMRONode.Dynamic readNode, @Cached.Exclusive @Cached InlinedConditionProfile valueFound, @Cached.Exclusive @Cached InlinedConditionProfile noGetMethod, @Cached.Exclusive @Cached TpSlotDescrGet.CallSlotDescrGet callGetSlot, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object value = readNode.execute(object, name);
        if (valueFound.profile(inliningTarget, value != PNone.NO_VALUE)) {
            TpSlots valueSlots = getSlotsNode.execute(inliningTarget, value);
            TpSlot valueGet = valueSlots.tp_descr_get();
            if (noGetMethod.profile(inliningTarget, valueGet == null)) {
                return value;
            }
            try {
                return callGetSlot.execute(frame, inliningTarget, valueGet, value, PNone.NO_VALUE, object);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                return PNone.NO_VALUE;
            }
        }
        return PNone.NO_VALUE;
    }

    @Specialization(guards={"isTypeGetAttribute(inliningTarget, getTypeSlotsNode, type)", "name == cachedName", "isNoValue(metaClassDescr)"}, replaces={"doBuiltinTypeType"}, limit="1")
    static Object doBuiltinType(VirtualFrame frame, Node inliningTarget, Object object, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getTypeSlotsNode, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Bind(value="getClass.execute(inliningTarget, object)") Object type, @Cached(value="create(name)", inline=false) LookupAttributeInMRONode lookupInMetaclassHierachy, @Bind(value="lookupInMetaclassHierachy.execute(type)") Object metaClassDescr, @Cached(value="create(name)", inline=false) LookupAttributeInMRONode readNode, @Cached.Exclusive @Cached InlinedConditionProfile valueFound, @Cached.Exclusive @Cached InlinedConditionProfile noGetMethod, @Cached.Exclusive @Cached TpSlotDescrGet.CallSlotDescrGet callGetSlot, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        assert (PyObjectLookupAttr.hasNoGetAttr(type));
        Object value = readNode.execute(object);
        if (valueFound.profile(inliningTarget, value != PNone.NO_VALUE)) {
            TpSlots valueSlots = getSlotsNode.execute(inliningTarget, value);
            TpSlot valueGet = valueSlots.tp_descr_get();
            if (noGetMethod.profile(inliningTarget, valueGet == null)) {
                return value;
            }
            try {
                return callGetSlot.execute(frame, inliningTarget, valueGet, value, PNone.NO_VALUE, object);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
                return PNone.NO_VALUE;
            }
        }
        return PNone.NO_VALUE;
    }

    @Specialization(replaces={"doBuiltinObject", "doBuiltinModule", "doBuiltinType"})
    static Object getDynamicAttr(Frame frame, Node inliningTarget, Object receiver, TruffleString name, @Cached.Exclusive @Cached GetClassNode getClass, @Cached.Exclusive @Cached TpSlots.GetCachedTpSlotsNode getSlotsNode, @Cached.Exclusive @Cached TpSlotGetAttr.CallSlotGetAttrNode callGetattribute, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        Object result;
        Object type = getClass.execute(inliningTarget, receiver);
        TpSlots slots = getSlotsNode.execute(inliningTarget, type);
        if (!codePointLengthNode.isAdoptable() && (result = PyObjectLookupAttr.readAttributeQuickly(type, slots, receiver, name, codePointLengthNode, codePointAtIndexNode)) != null) {
            return result;
        }
        try {
            return callGetattribute.execute((VirtualFrame)frame, inliningTarget, slots, receiver, name);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, errorProfile);
            return PNone.NO_VALUE;
        }
    }

    @NeverDefault
    public static PyObjectLookupAttr create() {
        return PyObjectLookupAttrNodeGen.create();
    }

    public static PyObjectLookupAttr getUncached() {
        return PyObjectLookupAttrNodeGen.getUncached();
    }

    static Object readAttributeQuickly(Object type, TpSlots slots, Object receiver, TruffleString stringName, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        ReadAttributeFromObjectNode readUncached;
        Object result;
        if (slots.tp_getattro() == ObjectBuiltins.SLOTS.tp_getattro() && type instanceof PythonManagedClass) {
            ReadAttributeFromObjectNode readUncached2;
            Object descr;
            PythonAbstractClass base;
            PythonAbstractClass[] bases = ((PythonManagedClass)type).getBaseClasses();
            if (bases.length == 1 && (base = bases[0]) instanceof PythonBuiltinClass && ((PythonBuiltinClass)base).getType() == PythonBuiltinClassType.PythonObject && (codePointAtIndexNode.execute((AbstractTruffleString)stringName, 0, PythonUtils.TS_ENCODING) != 95 || codePointAtIndexNode.execute((AbstractTruffleString)stringName, 1, PythonUtils.TS_ENCODING) != 95) && (descr = (readUncached2 = ReadAttributeFromObjectNode.getUncached()).execute(type, stringName)) == PNone.NO_VALUE) {
                return readUncached2.execute(receiver, stringName);
            }
        } else if (slots.tp_getattro() == ModuleBuiltins.SLOTS.tp_getattro() && type == PythonBuiltinClassType.PythonModule && !TpSlots.canBeSpecialMethod(stringName, codePointLengthNode, codePointAtIndexNode) && (result = (readUncached = ReadAttributeFromObjectNode.getUncached()).execute(receiver, stringName)) != PNone.NO_VALUE) {
            return result;
        }
        return null;
    }
}

