/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(defineModule="errno")
public final class ErrnoModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return new ArrayList();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        OSErrorEnum[] enumValues = OSErrorEnum.values();
        EconomicMapStorage storage = EconomicMapStorage.create(enumValues.length + 1);
        for (OSErrorEnum value : enumValues) {
            this.addConstant(value.getNumber(), PythonUtils.toTruffleStringUncached(value.name()), storage);
        }
        PDict errorCode = PFactory.createDict(core.getLanguage(), storage);
        this.addBuiltinConstant("errorcode", (Object)errorCode);
    }

    private void addConstant(int number, TruffleString name, EconomicMapStorage storage) {
        this.addBuiltinConstant(name, (Object)number);
        storage.putUncached(number, (Object)name);
    }
}

